/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import io.wispforest.accessories.api.client.DefaultAccessoryRenderer;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryRenderOverrideComponent;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

public class AccessoriesRendererRegistry {
    private static final Map<class_1792, Supplier<AccessoryRenderer>> RENDERERS = new HashMap<class_1792, Supplier<AccessoryRenderer>>();
    private static final Map<class_1792, AccessoryRenderer> CACHED_RENDERERS = new HashMap<class_1792, AccessoryRenderer>();

    public static void registerRenderer(class_1792 item, Supplier<AccessoryRenderer> renderer) {
        RENDERERS.put(item, renderer);
    }

    public static void registerNoRenderer(class_1792 item) {
        RENDERERS.put(item, () -> null);
    }

    @Nullable
    public static AccessoryRenderer getRender(class_1799 stack) {
        Boolean shouldOverride = ((AccessoryRenderOverrideComponent)stack.method_57825(AccessoriesDataComponents.RENDER_OVERRIDE, (Object)AccessoryRenderOverrideComponent.DEFAULT)).defaultRenderOverride();
        if (shouldOverride != null) {
            if (shouldOverride.booleanValue()) {
                return DefaultAccessoryRenderer.INSTANCE;
            }
            if (AccessoriesAPI.isDefaultAccessory(AccessoriesAPI.getOrDefaultAccessory(stack))) {
                return null;
            }
        }
        return AccessoriesRendererRegistry.getRender(stack.method_7909());
    }

    @Nullable
    public static AccessoryRenderer getRender(class_1792 item) {
        AccessoryRenderer renderer = CACHED_RENDERERS.getOrDefault(item, DefaultAccessoryRenderer.INSTANCE);
        if (renderer == null && Accessories.getConfig().clientData.forceNullRenderReplacement) {
            renderer = DefaultAccessoryRenderer.INSTANCE;
        }
        return renderer;
    }

    public static void onReload() {
        CACHED_RENDERERS.clear();
        RENDERERS.forEach((item, supplier) -> CACHED_RENDERERS.put((class_1792)item, (AccessoryRenderer)supplier.get()));
    }
}

