/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client;

import io.wispforest.accessories.api.client.AccessoryRenderer;
import io.wispforest.accessories.api.client.ModelTarget;
import io.wispforest.accessories.api.client.Transformation;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_4587;
import net.minecraft.class_572;
import net.minecraft.class_630;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class ClientTransformationUtils {
    @Environment(value=EnvType.CLIENT)
    public static void transformStack(List<Transformation> transformations, class_4587 poseStack, class_572<? extends class_1309> model, Runnable renderCall) {
        poseStack.method_22903();
        ClientTransformationUtils.transformStack(transformations, poseStack, model);
        renderCall.run();
        poseStack.method_22909();
    }

    @Environment(value=EnvType.CLIENT)
    public static void transformStack(List<Transformation> transformations, class_4587 poseStack, class_572<? extends class_1309> model) {
        for (Transformation transformation : transformations) {
            ClientTransformationUtils.transform(transformation, poseStack, model);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void transform(Transformation value, class_4587 poseStack, class_572<? extends class_1309> model) {
        Transformation transformation = value;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Transformation.Translation.class, Transformation.RawRotation.class, Transformation.AxisRotation.class, Transformation.Scale.class, Transformation.TransformTo.class, Transformation.Matrix.class}, (Object)transformation, n)) {
            case 0: {
                Transformation.Translation translation = (Transformation.Translation)transformation;
                Vector3f translationVector = translation.translation();
                poseStack.method_46416(translationVector.x, translationVector.y, translationVector.z);
                break;
            }
            case 1: {
                Transformation.RawRotation rawRotation = (Transformation.RawRotation)transformation;
                poseStack.method_22907(rawRotation.quarternionf());
                break;
            }
            case 2: {
                Transformation.AxisRotation axisRotation = (Transformation.AxisRotation)transformation;
                poseStack.method_22907(axisRotation.axisAngle4f().get(new Quaternionf()));
                break;
            }
            case 3: {
                Transformation.Scale scale = (Transformation.Scale)transformation;
                Vector3f scaleVector = scale.scale();
                poseStack.method_22905(scaleVector.x, scaleVector.y, scaleVector.z);
                break;
            }
            case 4: {
                Transformation.TransformTo transformTo = (Transformation.TransformTo)transformation;
                ModelTarget modelTarget = transformTo.target();
                class_630 part = ClientTransformationUtils.getPart(modelTarget.modelPart(), model);
                if (part == null) break;
                if (modelTarget.rawNormal() != null) {
                    Vector3f axisTranslations = modelTarget.rawNormal();
                    AccessoryRenderer.transformToModelPart(poseStack, part, Float.valueOf(axisTranslations.x), Float.valueOf(axisTranslations.y), Float.valueOf(axisTranslations.z));
                    break;
                }
                if (modelTarget.side() != null) {
                    AccessoryRenderer.transformToFace(poseStack, part, modelTarget.side());
                    break;
                }
                AccessoryRenderer.transformToModelPart(poseStack, part);
                break;
            }
            case 5: {
                Transformation.Matrix matrix = (Transformation.Matrix)transformation;
                poseStack.method_34425(matrix.matrix4f());
                break;
            }
            default: {
                throw new IllegalStateException("A invalid transform was created meaning such is unable to be encoded!");
            }
        }
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    private static class_630 getPart(String partKey, class_572<? extends class_1309> model) {
        return switch (partKey) {
            case "head" -> model.field_3398;
            case "hat" -> model.field_3394;
            case "body" -> model.field_3391;
            case "rightArm" -> model.field_3401;
            case "leftArm" -> model.field_27433;
            case "rightLeg" -> model.field_3392;
            case "leftLeg" -> model.field_3397;
            default -> null;
        };
    }
}

