/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client;

import io.wispforest.accessories.api.client.ModelTarget;
import io.wispforest.accessories.utils.EndecUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public sealed interface Transformation {
    public static final Endec<Transformation> ENDEC = Endec.dispatchedStruct(key -> switch (key) {
        case "translation" -> Translation.ENDEC;
        case "raw_rotation" -> RawRotation.ENDEC;
        case "axis_rotation" -> AxisRotation.ENDEC;
        case "scale" -> Scale.ENDEC;
        case "transform_to" -> TransformTo.ENDEC;
        case "matrix" -> Matrix.ENDEC;
        default -> throw new IllegalStateException("A invalid transform was created meaning such is unable to be decoded!");
    }, Transformation::key, (Endec)Endec.STRING, (String)"type");

    public static Transformation translation(Vector3f translation) {
        return new Translation(translation);
    }

    public static Transformation rawRotation(Quaternionf rotation) {
        return new RawRotation(rotation);
    }

    public static Transformation axisRotation(AxisAngle4f rotation) {
        return new AxisRotation(rotation);
    }

    public static Transformation scale(Vector3f scale) {
        return new Scale(scale);
    }

    public static Transformation modelTarget(ModelTarget target) {
        return new TransformTo(target);
    }

    public static Transformation matrix(Matrix4f matrix4f) {
        return new Matrix(matrix4f);
    }

    default public String key() {
        throw new IllegalStateException("A invalid transform was created meaning a valid key was not found!");
    }

    public record Translation(Vector3f translation) implements Transformation
    {
        public static final StructEndec<Translation> ENDEC = StructEndecBuilder.of((StructField)EndecUtils.VECTOR_3_F_ENDEC.fieldOf("value", Translation::translation), Translation::new);

        @Override
        public String key() {
            return "translation";
        }
    }

    public record RawRotation(Quaternionf quarternionf) implements Transformation
    {
        public static final StructEndec<RawRotation> ENDEC = StructEndecBuilder.of((StructField)EndecUtils.QUATERNIONF_COMPONENTS.fieldOf("value", RawRotation::quarternionf), RawRotation::new);

        @Override
        public String key() {
            return "raw_rotation";
        }
    }

    public record AxisRotation(AxisAngle4f axisAngle4f) implements Transformation
    {
        public static final StructEndec<AxisRotation> ENDEC = StructEndecBuilder.of((StructField)EndecUtils.AXISANGLE4F.fieldOf("value", AxisRotation::axisAngle4f), AxisRotation::new);

        @Override
        public String key() {
            return "axis_rotation";
        }
    }

    public record Scale(Vector3f scale) implements Transformation
    {
        public static final StructEndec<Scale> ENDEC = StructEndecBuilder.of((StructField)EndecUtils.VECTOR_3_F_ENDEC.fieldOf("value", Scale::scale), Scale::new);

        @Override
        public String key() {
            return "scale";
        }
    }

    public record TransformTo(ModelTarget target) implements Transformation
    {
        public static final StructEndec<TransformTo> ENDEC = StructEndecBuilder.of((StructField)ModelTarget.ENDEC.fieldOf("value", TransformTo::target), TransformTo::new);

        @Override
        public String key() {
            return "transform_to";
        }
    }

    public record Matrix(Matrix4f matrix4f) implements Transformation
    {
        public static final StructEndec<Matrix> ENDEC = StructEndecBuilder.of((StructField)EndecUtils.MATRIX4F.fieldOf("value", Matrix::matrix4f), Matrix::new);

        @Override
        public String key() {
            return "matrix";
        }
    }
}

