/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.components;

import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.events.SlotStateChange;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.endec.CodecUtils;
import io.wispforest.accessories.impl.AccessoryNestUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1799;

public final class AccessoryNestContainerContents {
    public static final AccessoryNestContainerContents EMPTY = new AccessoryNestContainerContents(List.of());
    public static final Endec<AccessoryNestContainerContents> ENDEC = StructEndecBuilder.of((StructField)CodecUtils.toEndec(class_1799.field_49266).listOf().fieldOf("accessories", AccessoryNestContainerContents::accessories), AccessoryNestContainerContents::new);
    private final List<class_1799> accessories;
    private final Map<Integer, SlotStateChange> slotChanges = new Int2ObjectOpenHashMap();

    public AccessoryNestContainerContents(List<class_1799> accessories) {
        this.accessories = accessories;
    }

    public AccessoryNestContainerContents setStack(int index, class_1799 stack) {
        ArrayList<class_1799> accessories = new ArrayList<class_1799>(this.accessories());
        accessories.set(index, stack);
        AccessoryNestContainerContents contents = new AccessoryNestContainerContents(accessories);
        contents.slotChanges.putAll(this.slotChanges);
        contents.slotChanges.put(index, SlotStateChange.REPLACEMENT);
        return contents;
    }

    public AccessoryNestContainerContents addStack(class_1799 stack) {
        ArrayList<class_1799> accessories = new ArrayList<class_1799>(this.accessories());
        int index = accessories.size();
        accessories.add(stack);
        AccessoryNestContainerContents contents = new AccessoryNestContainerContents(accessories);
        contents.slotChanges.putAll(this.slotChanges);
        contents.slotChanges.put(index, SlotStateChange.REPLACEMENT);
        return contents;
    }

    public Map<Integer, SlotStateChange> slotChanges() {
        return this.slotChanges;
    }

    public Map<class_1799, Accessory> getMap() {
        LinkedHashMap<class_1799, Accessory> map = new LinkedHashMap<class_1799, Accessory>();
        this.accessories().forEach(stack1 -> map.put((class_1799)stack1, AccessoriesAPI.getOrDefaultAccessory(stack1)));
        return map;
    }

    public Map<SlotEntryReference, Accessory> getMap(SlotReference slotReference) {
        LinkedHashMap<SlotEntryReference, Accessory> map = new LinkedHashMap<SlotEntryReference, Accessory>();
        List<class_1799> innerStacks = this.accessories();
        for (int i = 0; i < innerStacks.size(); ++i) {
            class_1799 innerStack = innerStacks.get(i);
            if (innerStack.method_7960()) continue;
            map.put(new SlotEntryReference(AccessoryNestUtils.create(slotReference, i), innerStack), AccessoriesAPI.getOrDefaultAccessory(innerStack));
        }
        return map;
    }

    public List<class_1799> accessories() {
        return this.accessories;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AccessoryNestContainerContents that = (AccessoryNestContainerContents)obj;
        return Objects.equals(this.accessories, that.accessories);
    }

    public int hashCode() {
        return Objects.hash(this.accessories);
    }

    public String toString() {
        return "AccessoryNestContainerContents[accessories=" + String.valueOf(this.accessories) + "]";
    }
}

