/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.endec;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.wispforest.accessories.endec.MinecraftEndecs;
import io.wispforest.accessories.endec.RegistriesAttribute;
import io.wispforest.accessories.endec.format.ContextHolder;
import io.wispforest.accessories.endec.format.ContextedDelegatingOps;
import io.wispforest.accessories.endec.format.edm.EdmOps;
import io.wispforest.accessories.endec.format.nbt.NbtDeserializer;
import io.wispforest.accessories.endec.format.nbt.NbtEndec;
import io.wispforest.accessories.endec.format.nbt.NbtSerializer;
import io.wispforest.accessories.mixin.DelegatingOpsAccessor;
import io.wispforest.accessories.mixin.RegistryOpsAccessor;
import io.wispforest.endec.Deserializer;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SelfDescribedDeserializer;
import io.wispforest.endec.SelfDescribedSerializer;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.Serializer;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.format.bytebuf.ByteBufDeserializer;
import io.wispforest.endec.format.bytebuf.ByteBufSerializer;
import io.wispforest.endec.format.edm.EdmElement;
import io.wispforest.endec.format.edm.EdmEndec;
import io.wispforest.endec.format.edm.EdmMap;
import io.wispforest.endec.format.edm.EdmSerializer;
import io.wispforest.endec.format.edm.LenientEdmDeserializer;
import io.wispforest.endec.format.forwarding.ForwardingDeserializer;
import io.wispforest.endec.format.forwarding.ForwardingSerializer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_5379;
import net.minecraft.class_6903;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class CodecUtils {
    private static final Map<Class<? extends Serializer<?>>, CodecInteropBinding<?>> serializerToBinding = new HashMap();
    private static final Map<Class<? extends Deserializer<?>>, CodecInteropBinding<?>> deserializerToBinding = new HashMap();
    private static final Map<Class<? extends DynamicOps<?>>, CodecInteropBinding<?>> opsToBinding = new HashMap();

    public static <T> Endec<T> toEndec(Codec<T> codec) {
        return Endec.of(CodecUtils.encoderOfCodec(codec), CodecUtils.decoderOfCodec(codec));
    }

    private static <T> Endec.Encoder<T> encoderOfCodec(Codec<T> codec) {
        return (ctx, serializer, value) -> {
            Pair pair = CodecUtils.convertToOps(serializer, ctx);
            if (pair != null) {
                CodecUtils.setDecodedValueUnsafe((CodecInteropBinding)pair.getSecond(), serializer, codec.encodeStart((DynamicOps)pair.getFirst(), value).getOrThrow());
            } else {
                EdmEndec.INSTANCE.encode(ctx, serializer, (EdmElement)codec.encodeStart(CodecUtils.createEdmOps(ctx), value).getOrThrow());
            }
        };
    }

    private static <T> Endec.Decoder<T> decoderOfCodec(Codec<T> codec) {
        return (ctx, deserializer) -> {
            Pair pair = CodecUtils.convertToOps(deserializer, ctx);
            return pair != null ? codec.parse((DynamicOps)pair.getFirst(), CodecUtils.getEncodedValueUnsafe((CodecInteropBinding)pair.getSecond(), deserializer)).getOrThrow() : codec.parse(CodecUtils.createEdmOps(ctx), (Object)EdmEndec.INSTANCE.decode(ctx, deserializer)).getOrThrow();
        };
    }

    public static <T> Endec<T> toEndec(Codec<T> codec, class_9139<ByteBuf, T> packetCodec) {
        Endec.Encoder encoder = CodecUtils.encoderOfCodec(codec);
        Endec.Decoder decoder = CodecUtils.decoderOfCodec(codec);
        return Endec.of((ctx, serializer, value) -> {
            if (serializer instanceof ByteBufSerializer) {
                class_2540 buffer = new class_2540(Unpooled.buffer());
                packetCodec.encode((Object)buffer, value);
                MinecraftEndecs.PACKET_BYTE_BUF.encode(ctx, serializer, (Object)buffer);
            } else {
                encoder.encode(ctx, serializer, value);
            }
        }, (ctx, deserializer) -> {
            if (deserializer instanceof ByteBufDeserializer) {
                return packetCodec.decode((Object)((ByteBuf)MinecraftEndecs.PACKET_BYTE_BUF.decode(ctx, deserializer)));
            }
            return decoder.decode(ctx, deserializer);
        });
    }

    public static <T> Endec<T> toEndecWithRegistries(Codec<T> codec, class_9139<class_9129, T> packetCodec) {
        Endec.Encoder encoder = CodecUtils.encoderOfCodec(codec);
        Endec.Decoder decoder = CodecUtils.decoderOfCodec(codec);
        return Endec.of((ctx, serializer, value) -> {
            if (serializer instanceof ByteBufSerializer) {
                class_9129 buffer = new class_9129((ByteBuf)new class_2540(Unpooled.buffer()), ((RegistriesAttribute)ctx.requireAttributeValue(RegistriesAttribute.REGISTRIES)).registryManager());
                packetCodec.encode((Object)buffer, value);
                MinecraftEndecs.PACKET_BYTE_BUF.encode(ctx, serializer, (Object)buffer);
            } else {
                encoder.encode(ctx, serializer, value);
            }
        }, (ctx, deserializer) -> {
            if (deserializer instanceof ByteBufDeserializer) {
                return packetCodec.decode((Object)new class_9129((ByteBuf)MinecraftEndecs.PACKET_BYTE_BUF.decode(ctx, deserializer), ((RegistriesAttribute)ctx.requireAttributeValue(RegistriesAttribute.REGISTRIES)).registryManager()));
            }
            return decoder.decode(ctx, deserializer);
        });
    }

    public static <T> Codec<T> toCodec(final Endec<T> endec, final SerializationContext assumedContext) {
        return new Codec<T>(){

            public <D> DataResult<Pair<T, D>> decode(DynamicOps<D> ops, D input) {
                return CodecUtils.captureThrows(() -> {
                    Deserializer<Object> deserializer = CodecUtils.convertToDeserializer(ops, input);
                    SerializationContext context = CodecUtils.createContext(ops, assumedContext);
                    Object decodedValue = deserializer != null ? endec.decode(deserializer.setupContext(context), deserializer) : endec.decode(context, (Deserializer)LenientEdmDeserializer.of((EdmElement)((EdmElement)ops.convertTo((DynamicOps)EdmOps.withoutContext(), input))));
                    return new Pair(decodedValue, input);
                });
            }

            public <D> DataResult<D> encode(T input, DynamicOps<D> ops, D prefix) {
                return CodecUtils.captureThrows(() -> {
                    Serializer serializer = CodecUtils.convertToSerializer(ops);
                    SerializationContext context = CodecUtils.createContext(ops, assumedContext);
                    return serializer != null ? endec.encodeFully(context, () -> serializer, input) : EdmOps.withoutContext().convertTo(ops, (EdmElement)endec.encodeFully(context, EdmSerializer::of, input));
                });
            }
        };
    }

    @Deprecated
    public static <T> Codec<T> ofEndec(Endec<T> endec) {
        return CodecUtils.toCodec(endec);
    }

    public static <T> Codec<T> toCodec(Endec<T> endec) {
        return CodecUtils.toCodec(endec, SerializationContext.empty());
    }

    public static <T> MapCodec<T> toMapCodec(final StructEndec<T> structEndec, final SerializationContext assumedContext) {
        return new MapCodec<T>(){

            public <T1> Stream<T1> keys(DynamicOps<T1> ops) {
                throw new UnsupportedOperationException("MapCodec generated from StructEndec cannot report keys");
            }

            public <T1> DataResult<T> decode(DynamicOps<T1> ops, MapLike<T1> input) {
                return CodecUtils.captureThrows(() -> {
                    Deserializer deserializer = CodecUtils.convertToDeserializerStruct(ops, input);
                    SerializationContext context = CodecUtils.createContext(ops, assumedContext);
                    if (deserializer != null) {
                        return structEndec.decode(deserializer.setupContext(context), deserializer);
                    }
                    HashMap map = new HashMap();
                    input.entries().forEach(pair -> map.put((String)ops.getStringValue(pair.getFirst()).getOrThrow(s -> new IllegalStateException("Unable to parse key: " + s)), (EdmElement)ops.convertTo((DynamicOps)EdmOps.withoutContext(), pair.getSecond())));
                    return structEndec.decode(context, (Deserializer)LenientEdmDeserializer.of((EdmElement)EdmElement.wrapMap(map)));
                });
            }

            public <T1> RecordBuilder<T1> encode(T input, DynamicOps<T1> ops, RecordBuilder<T1> prefix) {
                try {
                    SerializationContext context = CodecUtils.createContext(ops, assumedContext);
                    Pair<Serializer<T1>, Function<T1, RecordBuilder<T1>>> pair = CodecUtils.convertToSerializerStruct(ops, prefix);
                    if (pair != null) {
                        Serializer serializer = (Serializer)pair.getFirst();
                        return (RecordBuilder)((Function)pair.getSecond()).apply(structEndec.encodeFully(serializer.setupContext(context), () -> serializer, input));
                    }
                    Map element = (Map)((EdmElement)structEndec.encodeFully(context, EdmSerializer::of, input)).cast();
                    RecordBuilder result = prefix;
                    for (Map.Entry entry : element.entrySet()) {
                        result = result.add((String)entry.getKey(), EdmOps.withoutContext().convertTo(ops, (EdmElement)entry.getValue()));
                    }
                    return result;
                }
                catch (Exception e) {
                    return prefix.withErrorsFrom(DataResult.error(e::getMessage, input));
                }
            }
        };
    }

    public static <T> MapCodec<T> toMapCodec(StructEndec<T> structEndec) {
        return CodecUtils.toMapCodec(structEndec, SerializationContext.empty());
    }

    @ApiStatus.Experimental
    public static <T> StructEndec<T> toStructEndec(final MapCodec<T> mapCodec) {
        return new StructEndec<T>(){

            public void encodeStruct(SerializationContext ctx, Serializer<?> serializer, Serializer.Struct struct, T value) {
                Pair<DynamicOps<?>, CodecInteropBinding<?>> pair = CodecUtils.convertToOps(serializer, ctx);
                if (pair != null) {
                    CodecUtils.setEncodedValueStructUnsafe((CodecInteropBinding)pair.getSecond(), (DynamicOps)pair.getFirst(), serializer, struct, mapCodec, value);
                } else {
                    DynamicOps<EdmElement<?>> edmOps = CodecUtils.createEdmOps(ctx);
                    EdmMap edmMap = ((EdmElement)mapCodec.encode(value, edmOps, edmOps.mapBuilder()).build((Object)((EdmElement)edmOps.emptyMap())).getOrThrow()).asMap();
                    if (serializer instanceof SelfDescribedSerializer) {
                        ((Map)edmMap.value()).forEach((s, element) -> struct.field(s, ctx, (Endec)EdmEndec.INSTANCE, element));
                    } else {
                        struct.field("element", ctx, EdmEndec.MAP, (Object)edmMap);
                    }
                }
            }

            public T decodeStruct(SerializationContext ctx, Deserializer<?> deserializer, Deserializer.Struct struct) {
                Pair<DynamicOps<?>, CodecInteropBinding<?>> pair = CodecUtils.convertToOps(deserializer, ctx);
                if (pair != null) {
                    return CodecUtils.getEncodedValueStructUnsafe((CodecInteropBinding)pair.getSecond(), (DynamicOps)pair.getFirst(), deserializer, struct, mapCodec);
                }
                EdmMap edmMap = deserializer instanceof SelfDescribedDeserializer ? (EdmMap)EdmEndec.MAP.decode(ctx, deserializer) : (EdmMap)struct.field("element", ctx, EdmEndec.MAP);
                DynamicOps<EdmElement<?>> ops = CodecUtils.createEdmOps(ctx);
                return mapCodec.decode(ops, (MapLike)ops.getMap((Object)edmMap).getOrThrow()).getOrThrow();
            }
        };
    }

    public static <B extends class_2540, T> class_9139<B, T> packetCodec(final Endec<T> endec) {
        return new class_9139<B, T>(){

            public T decode(B buf) {
                SerializationContext serializationContext;
                if (buf instanceof class_9129) {
                    class_9129 registryByteBuf = (class_9129)buf;
                    serializationContext = SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of(registryByteBuf.method_56349())});
                } else {
                    serializationContext = SerializationContext.empty();
                }
                SerializationContext ctx = serializationContext;
                return endec.decode(ctx, (Deserializer)ByteBufDeserializer.of(buf));
            }

            public void encode(B buf, T value) {
                SerializationContext serializationContext;
                if (buf instanceof class_9129) {
                    class_9129 registryByteBuf = (class_9129)buf;
                    serializationContext = SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of(registryByteBuf.method_56349())});
                } else {
                    serializationContext = SerializationContext.empty();
                }
                SerializationContext ctx = serializationContext;
                endec.encode(ctx, (Serializer)ByteBufSerializer.of(buf), value);
            }
        };
    }

    private static SerializationContext createContext(DynamicOps<?> ops, SerializationContext assumedContext) {
        SerializationContext context;
        ContextHolder holder;
        Object rootOps = ops;
        if (rootOps instanceof ContextHolder) {
            holder = (ContextHolder)rootOps;
            v0 = holder.capturedContext().and(assumedContext);
        } else {
            v0 = context = null;
        }
        while (rootOps instanceof class_5379) {
            rootOps = ((DelegatingOpsAccessor)rootOps).delegate();
            if (context != null || !(rootOps instanceof ContextHolder)) continue;
            holder = (ContextHolder)rootOps;
            context = holder.capturedContext().and(assumedContext);
        }
        if (context == null) {
            context = assumedContext;
        }
        if (ops instanceof class_6903) {
            class_6903 registryOps = (class_6903)ops;
            context = context.withAttributes(new SerializationAttribute.Instance[]{RegistriesAttribute.infoGetterOnly(((RegistryOpsAccessor)registryOps).lookupProvider())});
        }
        return context;
    }

    private static DynamicOps<EdmElement<?>> createEdmOps(SerializationContext ctx) {
        EdmOps ops = EdmOps.withContext(ctx);
        if (ctx.hasAttribute(RegistriesAttribute.REGISTRIES)) {
            ops = class_6903.method_40414((DynamicOps)ops, (class_6903.class_7863)((RegistriesAttribute)ctx.getAttributeValue(RegistriesAttribute.REGISTRIES)).infoGetter());
        }
        return ops;
    }

    private static <T> DataResult<T> captureThrows(Supplier<T> action) {
        try {
            return DataResult.success(action.get());
        }
        catch (Exception e) {
            return DataResult.error(e::getMessage);
        }
    }

    public static <T> void registerInteropBinding(CodecInteropBinding<T> binding) {
        if (serializerToBinding.containsKey(binding.serializerClass())) {
            throw new IllegalStateException("Unable to add the given CodecInteropBinding as the given Serializer clazz was already added by another! [Class: " + String.valueOf(binding.serializerClass()) + "]");
        }
        if (deserializerToBinding.containsKey(binding.deserializerClass())) {
            throw new IllegalStateException("Unable to add the given CodecInteropBinding as the given Deserializer clazz was already added by another! [Class: " + String.valueOf(binding.deserializerClass()) + "]");
        }
        if (opsToBinding.containsKey(binding.opsClass())) {
            throw new IllegalStateException("Unable to add the given CodecInteropBinding as the given DynamicOps clazz was already added by another! [Class: " + String.valueOf(binding.opsClass()) + "]");
        }
        serializerToBinding.put(binding.serializerClass(), binding);
        deserializerToBinding.put(binding.deserializerClass(), binding);
        opsToBinding.put(binding.opsClass(), binding);
    }

    private static <T> DynamicOps<T> unpackOps(DynamicOps<T> ops) {
        DynamicOps<T> rootOps = ops;
        while (rootOps instanceof class_5379) {
            rootOps = ((DelegatingOpsAccessor)rootOps).delegate();
        }
        return rootOps;
    }

    private static <T> Serializer<T> unpackSerializer(Serializer<T> serializer) {
        Serializer rootSerializer = serializer;
        while (rootSerializer instanceof ForwardingSerializer) {
            ForwardingSerializer forwardingSerializer = (ForwardingSerializer)rootSerializer;
            rootSerializer = forwardingSerializer.delegate();
        }
        return rootSerializer;
    }

    private static <T> Deserializer<T> unpackDeserializer(Deserializer<T> deserializer) {
        Deserializer rootDeserializer = deserializer;
        while (rootDeserializer instanceof ForwardingDeserializer) {
            ForwardingDeserializer forwardingDeserializer = (ForwardingDeserializer)rootDeserializer;
            rootDeserializer = forwardingDeserializer.delegate();
        }
        return rootDeserializer;
    }

    @Nullable
    private static <T> Pair<DynamicOps<T>, CodecInteropBinding<T>> convertToOps(Serializer<T> serializer, SerializationContext ctx) {
        CodecInteropBinding<?> bindings = serializerToBinding.get(CodecUtils.unpackSerializer(serializer).getClass());
        if (bindings != null) {
            class_6903 ops = ContextedDelegatingOps.withContext(ctx, bindings.getOps());
            if (ctx.hasAttribute(RegistriesAttribute.REGISTRIES)) {
                ops = class_6903.method_40414(ops, (class_6903.class_7863)((RegistriesAttribute)ctx.getAttributeValue(RegistriesAttribute.REGISTRIES)).infoGetter());
            }
            return new Pair(ops, bindings);
        }
        return null;
    }

    @Nullable
    private static <T> Pair<DynamicOps<T>, CodecInteropBinding<T>> convertToOps(Deserializer<T> deserializer, SerializationContext ctx) {
        CodecInteropBinding<?> bindings = deserializerToBinding.get(CodecUtils.unpackDeserializer(deserializer).getClass());
        if (bindings != null) {
            class_6903 ops = ContextedDelegatingOps.withContext(ctx, bindings.getOps());
            if (ctx.hasAttribute(RegistriesAttribute.REGISTRIES)) {
                ops = class_6903.method_40414(ops, (class_6903.class_7863)((RegistriesAttribute)ctx.getAttributeValue(RegistriesAttribute.REGISTRIES)).infoGetter());
            }
            return new Pair(ops, bindings);
        }
        return null;
    }

    @Nullable
    private static <T> Deserializer<T> convertToDeserializer(DynamicOps<T> dynamicOps, T t) {
        CodecInteropBinding<?> bindings = opsToBinding.get(CodecUtils.unpackOps(dynamicOps).getClass());
        return bindings != null ? bindings.createDeserializer(t) : null;
    }

    @Nullable
    private static <T> Deserializer<T> convertToDeserializerStruct(DynamicOps<T> dynamicOps, MapLike<T> mapLike) {
        CodecInteropBinding<?> bindings = opsToBinding.get(CodecUtils.unpackOps(dynamicOps).getClass());
        return bindings != null ? bindings.createDeserializer(bindings.convertMapLike(mapLike)) : null;
    }

    @Nullable
    private static <T> Pair<Serializer<T>, Function<T, RecordBuilder<T>>> convertToSerializerStruct(DynamicOps<T> dynamicOps, RecordBuilder<T> builder) {
        CodecInteropBinding<?> bindings = opsToBinding.get(CodecUtils.unpackOps(dynamicOps).getClass());
        return bindings != null ? new Pair(bindings.createSerializer(), t -> bindings.addToBuilder(t, builder)) : null;
    }

    @Nullable
    private static <T> Serializer<T> convertToSerializer(DynamicOps<T> dynamicOps) {
        CodecInteropBinding<?> bindings = opsToBinding.get(CodecUtils.unpackOps(dynamicOps).getClass());
        return bindings != null ? bindings.createSerializer() : null;
    }

    private static <T> void setDecodedValueUnsafe(CodecInteropBinding<T> binding, Serializer<?> serializer, Object t) {
        try {
            binding.setEncodedValue(serializer, t);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Unable to set the given encoded value into the passed Serializer as its not the correct type!", e);
        }
    }

    private static <T> T getEncodedValueUnsafe(CodecInteropBinding<T> binding, Deserializer<?> deserializer) {
        try {
            return binding.getEncodedValue(deserializer);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Unable to get the given encoded value from the passed Deserializer as its not the correct type!", e);
        }
    }

    private static <T, V> void setEncodedValueStructUnsafe(CodecInteropBinding<T> binding, DynamicOps<?> ops, Serializer<?> serializer, Serializer.Struct struct, MapCodec<V> mapCodec, V v) {
        try {
            DynamicOps<?> typedOps = ops;
            Object t = mapCodec.encode(v, typedOps, typedOps.mapBuilder()).build(typedOps.emptyMap()).getOrThrow();
            binding.setEncodedValueStruct(SerializationContext.empty(), serializer, struct, t);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Unable to set the given encoded value into the passed Struct Serializer as its not the correct type!", e);
        }
    }

    private static <T, V> V getEncodedValueStructUnsafe(CodecInteropBinding<T> binding, DynamicOps<?> ops, Deserializer<?> deserializer, Deserializer.Struct struct, MapCodec<V> mapCodec) {
        try {
            DynamicOps<?> typedOps = ops;
            T t = binding.getEncodedValueStruct(SerializationContext.empty(), deserializer, struct);
            return (V)mapCodec.decode(typedOps, (MapLike)typedOps.getMap(t).getOrThrow()).getOrThrow();
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Unable to set the given encoded value into the passed Struct Deserializer as its not the correct type!", e);
        }
    }

    static {
        CodecUtils.registerInteropBinding(new CodecInteropBinding<class_2520>(){

            @Override
            public Class<? extends Serializer<class_2520>> serializerClass() {
                return NbtSerializer.class;
            }

            @Override
            public Class<? extends Deserializer<class_2520>> deserializerClass() {
                return NbtDeserializer.class;
            }

            @Override
            public Class<? extends DynamicOps<class_2520>> opsClass() {
                return class_2509.class;
            }

            @Override
            public Serializer<class_2520> createSerializer() {
                return NbtSerializer.of();
            }

            @Override
            public Deserializer<class_2520> createDeserializer(class_2520 tag) {
                return NbtDeserializer.of(tag);
            }

            @Override
            public DynamicOps<class_2520> getOps() {
                return class_2509.field_11560;
            }

            @Override
            public class_2520 convertMapLike(MapLike<class_2520> mapLike) {
                return (class_2520)mapLike.entries().map(pair -> pair.mapFirst(tag -> {
                    if (!(tag instanceof class_2519)) {
                        throw new IllegalStateException("Unable to parse key: " + String.valueOf(tag));
                    }
                    class_2519 stringTag = (class_2519)tag;
                    return stringTag.method_10714();
                })).collect(Collector.of(class_2487::new, (compound, pair) -> compound.method_10566((String)pair.getFirst(), (class_2520)pair.getSecond()), class_2487::method_10543, new Collector.Characteristics[0]));
            }

            @Override
            public RecordBuilder<class_2520> addToBuilder(class_2520 tag, RecordBuilder<class_2520> builder) {
                if (!(tag instanceof class_2487)) {
                    throw new IllegalStateException("Unable to add to builder as the given Tag was not a CompoundTag: " + String.valueOf(tag));
                }
                class_2487 compoundTag = (class_2487)tag;
                RecordBuilder result = builder;
                for (String key : compoundTag.method_10541()) {
                    result = result.add(key, (Object)compoundTag.method_10580(key));
                }
                return result;
            }

            @Override
            public void setEncodedValue(Serializer<class_2520> serializer, class_2520 tag) {
                ((SelfDescribedDeserializer)this.createDeserializer(tag)).readAny(SerializationContext.empty(), serializer);
            }

            @Override
            public class_2520 getEncodedValue(Deserializer<class_2520> deserializer) {
                Serializer<class_2520> serializer = this.createSerializer();
                ((SelfDescribedDeserializer)deserializer).readAny(SerializationContext.empty(), serializer);
                return (class_2520)serializer.result();
            }

            @Override
            public void setEncodedValueStruct(SerializationContext ctx, Serializer<?> serializer, Serializer.Struct struct, class_2520 tag) {
                if (!(tag instanceof class_2487)) {
                    throw new IllegalStateException("Unable to add to builder as the given Tag was not a CompoundTag: " + String.valueOf(tag));
                }
                class_2487 compoundTag = (class_2487)tag;
                if (serializer instanceof SelfDescribedSerializer) {
                    compoundTag.method_10541().forEach(key -> struct.field(key, ctx, NbtEndec.ELEMENT, (Object)compoundTag.method_10580(key)));
                } else {
                    struct.field("element", ctx, NbtEndec.COMPOUND, (Object)compoundTag);
                }
            }

            @Override
            public class_2520 getEncodedValueStruct(SerializationContext ctx, Deserializer<?> deserializer, Deserializer.Struct struct) {
                return deserializer instanceof SelfDescribedDeserializer ? (class_2520)NbtEndec.COMPOUND.decode(ctx, deserializer) : (class_2520)struct.field("element", ctx, NbtEndec.ELEMENT);
            }
        });
    }

    public static interface CodecInteropBinding<T> {
        public Class<? extends Serializer<T>> serializerClass();

        public Class<? extends Deserializer<T>> deserializerClass();

        public Class<? extends DynamicOps<T>> opsClass();

        public Serializer<T> createSerializer();

        public Deserializer<T> createDeserializer(T var1);

        public DynamicOps<T> getOps();

        public T convertMapLike(MapLike<T> var1);

        public RecordBuilder<T> addToBuilder(T var1, RecordBuilder<T> var2);

        public void setEncodedValue(Serializer<T> var1, T var2);

        public T getEncodedValue(Deserializer<T> var1);

        public void setEncodedValueStruct(SerializationContext var1, Serializer<?> var2, Serializer.Struct var3, T var4);

        public T getEncodedValueStruct(SerializationContext var1, Deserializer<?> var2, Deserializer.Struct var3);
    }
}

