/*
 * Decompiled with CFR 0.152.
 */
package salted.packedup.common.block.utils;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import salted.packedup.common.block.BookBundleBlock;
import salted.packedup.common.block.BookBundleSlabBlock;
import salted.packedup.common.block.BookPileBlock;
import salted.packedup.common.block.state.PUProperties;
import salted.packedup.common.registry.PUBlocks;

public class BundleUtils {
    private static boolean isBundle(Block block, BookBundleBlock bundleBlock, BookBundleSlabBlock bundleSlab) {
        return block == bundleBlock || block == bundleSlab;
    }

    private static InteractionResult convert(BlockState state, int layers, Level world, BlockPos pos, Player player) {
        ItemStack item = player.m_21205_();
        if (!(item.m_41720_() instanceof ShearsItem)) {
            return InteractionResult.PASS;
        }
        if (!player.m_7500_()) {
            item.m_41622_(1, (LivingEntity)player, user -> user.m_21166_(EquipmentSlot.MAINHAND));
        }
        world.m_7731_(pos, (BlockState)((BlockState)((BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)))).m_61124_((Property)PUProperties.QUARTER_LAYERS, (Comparable)Integer.valueOf(layers))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_))), 0);
        world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12344_, SoundSource.BLOCKS, 1.0f, 0.9f);
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InteractionResult shearBundle(Block block, BlockState state, Level world, BlockPos pos, Player player) {
        int size;
        if (block instanceof BookBundleBlock) {
            size = 4;
        } else {
            if (!(block instanceof BookBundleSlabBlock)) return InteractionResult.PASS;
            SlabType type = (SlabType)state.m_61143_((Property)BlockStateProperties.f_61397_);
            if (type.equals((Object)SlabType.BOTTOM)) {
                size = 2;
            } else {
                if (!type.equals((Object)SlabType.DOUBLE)) return InteractionResult.PASS;
                size = 4;
            }
        }
        Bundle bundle = BundleUtils.getBundle(block);
        switch (bundle) {
            case WHITE: {
                return BundleUtils.convert(((BookPileBlock)((Object)PUBlocks.WHITE_BOOK_PILE.get())).m_152465_(state), size, world, pos, player);
            }
            case LIGHT_GRAY: {
                return BundleUtils.convert(((BookPileBlock)((Object)PUBlocks.LIGHT_GRAY_BOOK_PILE.get())).m_152465_(state), size, world, pos, player);
            }
            case GRAY: {
                return BundleUtils.convert(((BookPileBlock)((Object)PUBlocks.GRAY_BOOK_PILE.get())).m_152465_(state), size, world, pos, player);
            }
            case BLACK: {
                return BundleUtils.convert(((BookPileBlock)((Object)PUBlocks.BLACK_BOOK_PILE.get())).m_152465_(state), size, world, pos, player);
            }
            case BROWN: {
                return BundleUtils.convert(((BookPileBlock)((Object)PUBlocks.BROWN_BOOK_PILE.get())).m_152465_(state), size, world, pos, player);
            }
            case RED: {
                return BundleUtils.convert(((BookPileBlock)((Object)PUBlocks.RED_BOOK_PILE.get())).m_152465_(state), size, world, pos, player);
            }
            case ORANGE: {
                return BundleUtils.convert(((BookPileBlock)((Object)PUBlocks.ORANGE_BOOK_PILE.get())).m_152465_(state), size, world, pos, player);
            }
            case YELLOW: {
                return BundleUtils.convert(((BookPileBlock)((Object)PUBlocks.YELLOW_BOOK_PILE.get())).m_152465_(state), size, world, pos, player);
            }
            case LIME: {
                return BundleUtils.convert(((BookPileBlock)((Object)PUBlocks.LIME_BOOK_PILE.get())).m_152465_(state), size, world, pos, player);
            }
            case GREEN: {
                return BundleUtils.convert(((BookPileBlock)((Object)PUBlocks.GREEN_BOOK_PILE.get())).m_152465_(state), size, world, pos, player);
            }
            case CYAN: {
                return BundleUtils.convert(((BookPileBlock)((Object)PUBlocks.CYAN_BOOK_PILE.get())).m_152465_(state), size, world, pos, player);
            }
            case LIGHT_BLUE: {
                return BundleUtils.convert(((BookPileBlock)((Object)PUBlocks.LIGHT_BLUE_BOOK_PILE.get())).m_152465_(state), size, world, pos, player);
            }
            case BLUE: {
                return BundleUtils.convert(((BookPileBlock)((Object)PUBlocks.BLUE_BOOK_PILE.get())).m_152465_(state), size, world, pos, player);
            }
            case PURPLE: {
                return BundleUtils.convert(((BookBundleBlock)((Object)PUBlocks.PURPLE_BOOK_BUNDLE.get())).m_152465_(state), size, world, pos, player);
            }
            case MAGENTA: {
                return BundleUtils.convert(((BookPileBlock)((Object)PUBlocks.MAGENTA_BOOK_PILE.get())).m_152465_(state), size, world, pos, player);
            }
            case PINK: {
                return BundleUtils.convert(((BookPileBlock)((Object)PUBlocks.PINK_BOOK_PILE.get())).m_152465_(state), size, world, pos, player);
            }
        }
        return BundleUtils.convert(((BookPileBlock)((Object)PUBlocks.BOOK_PILE.get())).m_152465_(state), size, world, pos, player);
    }

    private static Bundle getBundle(Block block) {
        if (BundleUtils.isBundle(block, (BookBundleBlock)((Object)PUBlocks.WHITE_BOOK_BUNDLE.get()), (BookBundleSlabBlock)((Object)PUBlocks.WHITE_BOOK_BUNDLE_SLAB.get()))) {
            return Bundle.WHITE;
        }
        if (BundleUtils.isBundle(block, (BookBundleBlock)((Object)PUBlocks.LIGHT_GRAY_BOOK_BUNDLE.get()), (BookBundleSlabBlock)((Object)PUBlocks.LIGHT_GRAY_BOOK_BUNDLE_SLAB.get()))) {
            return Bundle.LIGHT_GRAY;
        }
        if (BundleUtils.isBundle(block, (BookBundleBlock)((Object)PUBlocks.GRAY_BOOK_BUNDLE.get()), (BookBundleSlabBlock)((Object)PUBlocks.GRAY_BOOK_BUNDLE_SLAB.get()))) {
            return Bundle.GRAY;
        }
        if (BundleUtils.isBundle(block, (BookBundleBlock)((Object)PUBlocks.BLACK_BOOK_BUNDLE.get()), (BookBundleSlabBlock)((Object)PUBlocks.BLACK_BOOK_BUNDLE_SLAB.get()))) {
            return Bundle.BLACK;
        }
        if (BundleUtils.isBundle(block, (BookBundleBlock)((Object)PUBlocks.BROWN_BOOK_BUNDLE.get()), (BookBundleSlabBlock)((Object)PUBlocks.BROWN_BOOK_BUNDLE_SLAB.get()))) {
            return Bundle.BROWN;
        }
        if (BundleUtils.isBundle(block, (BookBundleBlock)((Object)PUBlocks.RED_BOOK_BUNDLE.get()), (BookBundleSlabBlock)((Object)PUBlocks.RED_BOOK_BUNDLE_SLAB.get()))) {
            return Bundle.RED;
        }
        if (BundleUtils.isBundle(block, (BookBundleBlock)((Object)PUBlocks.ORANGE_BOOK_BUNDLE.get()), (BookBundleSlabBlock)((Object)PUBlocks.ORANGE_BOOK_BUNDLE_SLAB.get()))) {
            return Bundle.ORANGE;
        }
        if (BundleUtils.isBundle(block, (BookBundleBlock)((Object)PUBlocks.YELLOW_BOOK_BUNDLE.get()), (BookBundleSlabBlock)((Object)PUBlocks.YELLOW_BOOK_BUNDLE_SLAB.get()))) {
            return Bundle.YELLOW;
        }
        if (BundleUtils.isBundle(block, (BookBundleBlock)((Object)PUBlocks.LIME_BOOK_BUNDLE.get()), (BookBundleSlabBlock)((Object)PUBlocks.LIME_BOOK_BUNDLE_SLAB.get()))) {
            return Bundle.LIME;
        }
        if (BundleUtils.isBundle(block, (BookBundleBlock)((Object)PUBlocks.GREEN_BOOK_BUNDLE.get()), (BookBundleSlabBlock)((Object)PUBlocks.GREEN_BOOK_BUNDLE_SLAB.get()))) {
            return Bundle.GREEN;
        }
        if (BundleUtils.isBundle(block, (BookBundleBlock)((Object)PUBlocks.CYAN_BOOK_BUNDLE.get()), (BookBundleSlabBlock)((Object)PUBlocks.CYAN_BOOK_BUNDLE_SLAB.get()))) {
            return Bundle.CYAN;
        }
        if (BundleUtils.isBundle(block, (BookBundleBlock)((Object)PUBlocks.LIGHT_BLUE_BOOK_BUNDLE.get()), (BookBundleSlabBlock)((Object)PUBlocks.LIGHT_BLUE_BOOK_BUNDLE_SLAB.get()))) {
            return Bundle.LIGHT_BLUE;
        }
        if (BundleUtils.isBundle(block, (BookBundleBlock)((Object)PUBlocks.BLUE_BOOK_BUNDLE.get()), (BookBundleSlabBlock)((Object)PUBlocks.BLUE_BOOK_BUNDLE_SLAB.get()))) {
            return Bundle.BLUE;
        }
        if (BundleUtils.isBundle(block, (BookBundleBlock)((Object)PUBlocks.PURPLE_BOOK_BUNDLE.get()), (BookBundleSlabBlock)((Object)PUBlocks.PURPLE_BOOK_BUNDLE_SLAB.get()))) {
            return Bundle.PURPLE;
        }
        if (BundleUtils.isBundle(block, (BookBundleBlock)((Object)PUBlocks.MAGENTA_BOOK_BUNDLE.get()), (BookBundleSlabBlock)((Object)PUBlocks.MAGENTA_BOOK_BUNDLE_SLAB.get()))) {
            return Bundle.MAGENTA;
        }
        if (BundleUtils.isBundle(block, (BookBundleBlock)((Object)PUBlocks.PINK_BOOK_BUNDLE.get()), (BookBundleSlabBlock)((Object)PUBlocks.PINK_BOOK_BUNDLE_SLAB.get()))) {
            return Bundle.PINK;
        }
        return Bundle.BASE;
    }

    private static enum Bundle {
        BASE,
        WHITE,
        LIGHT_GRAY,
        GRAY,
        BLACK,
        BROWN,
        RED,
        ORANGE,
        YELLOW,
        LIME,
        GREEN,
        CYAN,
        LIGHT_BLUE,
        BLUE,
        PURPLE,
        MAGENTA,
        PINK;

    }
}

