/*
 * Decompiled with CFR 0.152.
 */
package salted.packedup.common.block.utils;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.phys.BlockHitResult;
import salted.packedup.common.block.TurfBlock;
import salted.packedup.common.block.TurfLayerBlock;
import salted.packedup.common.block.state.PUProperties;
import salted.packedup.common.registry.PUBlocks;

public class TurfUtils {
    public static InteractionResult shovelTurf(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        ItemStack item = player.m_21205_();
        Block block = state.m_60734_();
        if (!item.m_204117_(ItemTags.f_271138_)) {
            return InteractionResult.PASS;
        }
        if (block instanceof TurfLayerBlock) {
            if ((Integer)state.m_61143_((Property)PUProperties.QUARTER_LAYERS) <= 1) {
                return InteractionResult.PASS;
            }
            ItemStack blockItem = state.m_60734_().m_5456_().m_7968_();
            world.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)PUProperties.QUARTER_LAYERS, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)PUProperties.QUARTER_LAYERS) - 1))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_))));
            if (!player.m_7500_()) {
                Block.m_152435_((Level)world, (BlockPos)pos, (Direction)hit.m_82434_(), (ItemStack)blockItem);
            }
        } else if (block instanceof TurfBlock) {
            Block layerBlock = TurfUtils.getTurfLayer(state);
            ItemStack blockItem = layerBlock.m_5456_().m_7968_();
            world.m_46597_(pos, (BlockState)((BlockState)layerBlock.m_152465_(layerBlock.m_49966_()).m_61124_((Property)PUProperties.QUARTER_LAYERS, (Comparable)Integer.valueOf(3))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
            if (!player.m_7500_()) {
                Block.m_152435_((Level)world, (BlockPos)pos, (Direction)hit.m_82434_(), (ItemStack)blockItem);
            }
        }
        world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    private static Block getTurfLayer(BlockState state) {
        Block block = state.m_60734_();
        if (state.m_60713_((Block)PUBlocks.GRASS_TURF.get())) {
            return (Block)PUBlocks.GRASS_TURF_LAYER.get();
        }
        if (state.m_60713_((Block)PUBlocks.PODZOL_TURF.get())) {
            return (Block)PUBlocks.PODZOL_TURF_LAYER.get();
        }
        if (state.m_60713_((Block)PUBlocks.MYCELIUM_TURF.get())) {
            return (Block)PUBlocks.MYCELIUM_TURF_LAYER.get();
        }
        return block;
    }

    public static boolean isBonemealable(BlockState state, LevelReader world, BlockPos pos) {
        if (!TurfUtils.isTurf(state, (TurfBlock)((Object)PUBlocks.GRASS_TURF.get()), (TurfLayerBlock)((Object)PUBlocks.GRASS_TURF_LAYER.get()))) {
            return false;
        }
        if (state.m_60713_((Block)PUBlocks.GRASS_TURF_LAYER.get()) && (Integer)state.m_61143_((Property)PUProperties.QUARTER_LAYERS) != 4) {
            return false;
        }
        return world.m_8055_(pos.m_7494_()).m_60795_();
    }

    public static void bonemealTurf(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos blockpos = pos.m_7494_();
        Registry feature = world.m_9598_().m_175515_(Registries.f_256988_);
        Optional optional = feature.m_203636_(VegetationPlacements.f_195459_);
        block0: for (int i = 0; i < 128; ++i) {
            Holder holder;
            BlockPos blockpos1 = blockpos;
            for (int j = 0; j < i / 16; ++j) {
                int x = random.m_188503_(3) - 1;
                int y = (random.m_188503_(3) - 1) * random.m_188503_(3) / 2;
                int z = random.m_188503_(3) - 1;
                BlockState blockState1 = world.m_8055_(blockpos1.m_7495_());
                boolean belowIsThis = TurfUtils.isTurf(blockState1, (TurfBlock)((Object)PUBlocks.GRASS_TURF.get()), (TurfLayerBlock)((Object)PUBlocks.GRASS_TURF_LAYER.get()));
                boolean isFullBlock = world.m_8055_(blockpos1).m_60838_((BlockGetter)world, blockpos1);
                blockpos1 = blockpos1.m_7918_(x, y, z);
                if (!belowIsThis || isFullBlock) continue block0;
            }
            BlockState blockstate2 = world.m_8055_(blockpos1);
            if (blockstate2.m_60713_(state.m_60734_()) && random.m_188503_(10) == 0) {
                ((BonemealableBlock)state.m_60734_()).m_214148_(world, random, blockpos1, blockstate2);
            }
            if (!blockstate2.m_60795_()) continue;
            if (random.m_188503_(8) == 0) {
                Holder biome = world.m_204166_(blockpos1);
                List list = ((Biome)biome.m_203334_()).m_47536_().m_47815_();
                if (list.isEmpty()) continue;
                holder = ((RandomPatchConfiguration)((ConfiguredFeature)list.get(0)).f_65378_()).f_191304_();
            } else {
                if (!optional.isPresent()) continue;
                holder = (Holder)optional.get();
            }
            ((PlacedFeature)holder.m_203334_()).m_226357_((WorldGenLevel)world, world.m_7726_().m_8481_(), random, blockpos1);
        }
    }

    public static void spawnMyceliumParticles(BlockState state, Level world, BlockPos pos, RandomSource random) {
        int layers;
        if (!TurfUtils.isTurf(state, (TurfBlock)((Object)PUBlocks.MYCELIUM_TURF.get()), (TurfLayerBlock)((Object)PUBlocks.MYCELIUM_TURF_LAYER.get()))) {
            return;
        }
        double yOffset = 1.1;
        if (state.m_60713_((Block)PUBlocks.MYCELIUM_TURF_LAYER.get()) && (layers = ((Integer)state.m_61143_((Property)PUProperties.QUARTER_LAYERS)).intValue()) < 4) {
            yOffset = 0.34 * (double)layers - ((double)layers * 0.1 - 0.1);
        }
        if (random.m_188503_(10) == 0) {
            double x = (double)pos.m_123341_() + random.m_188500_();
            double y = (double)pos.m_123342_() + yOffset;
            double z = (double)pos.m_123343_() + random.m_188500_();
            world.m_7106_((ParticleOptions)ParticleTypes.f_123757_, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static void spreadGrass(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (TurfUtils.isTurf(state, (TurfBlock)((Object)PUBlocks.PODZOL_TURF.get()), (TurfLayerBlock)((Object)PUBlocks.PODZOL_TURF_LAYER.get()))) {
            return;
        }
        if (!world.isAreaLoaded(pos, 3)) {
            return;
        }
        if (world.m_46803_(pos.m_7494_()) < 9) {
            return;
        }
        BlockState blockstate = TurfUtils.getTurfSource(state);
        for (int i = 0; i < 4; ++i) {
            int z;
            int y;
            int x = random.m_188503_(3) - 1;
            BlockPos blockpos = pos.m_7918_(x, y = random.m_188503_(5) - 3, z = random.m_188503_(3) - 1);
            if (!world.m_8055_(blockpos).m_60713_(Blocks.f_50493_) || !TurfUtils.canPropagate(blockstate, (LevelReader)world, blockpos)) continue;
            world.m_46597_(blockpos, (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61451_, (Comparable)Boolean.valueOf(world.m_8055_(blockpos.m_7494_()).m_60713_(Blocks.f_50125_))));
        }
    }

    public static BlockState getTurfSource(BlockState state) {
        if (TurfUtils.isTurf(state, (TurfBlock)((Object)PUBlocks.GRASS_TURF.get()), (TurfLayerBlock)((Object)PUBlocks.GRASS_TURF_LAYER.get()))) {
            return Blocks.f_50440_.m_49966_();
        }
        if (TurfUtils.isTurf(state, (TurfBlock)((Object)PUBlocks.MYCELIUM_TURF.get()), (TurfLayerBlock)((Object)PUBlocks.MYCELIUM_TURF_LAYER.get()))) {
            return Blocks.f_50195_.m_49966_();
        }
        return state;
    }

    private static boolean canBeGrass(BlockState state, LevelReader worldReader, BlockPos pos) {
        BlockPos blockpos = pos.m_7494_();
        BlockState blockstate = worldReader.m_8055_(blockpos);
        if (blockstate.m_60713_(Blocks.f_50125_) && (Integer)blockstate.m_61143_((Property)SnowLayerBlock.f_56581_) == 1) {
            return true;
        }
        if (blockstate.m_60819_().m_76186_() == 8) {
            return false;
        }
        int lightLevel = LightEngine.m_284282_((BlockGetter)worldReader, (BlockState)state, (BlockPos)pos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.m_60739_((BlockGetter)worldReader, blockpos));
        return lightLevel < worldReader.m_7469_();
    }

    private static boolean canPropagate(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockpos = pos.m_7494_();
        return TurfUtils.canBeGrass(state, world, pos) && !world.m_6425_(blockpos).m_205070_(FluidTags.f_13131_);
    }

    private static boolean isTurf(BlockState state, TurfBlock turf, TurfLayerBlock turfLayer) {
        Block block = state.m_60734_();
        return block == turf || block == turfLayer;
    }
}

