/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.cyclopscore.block.BlockWithEntity;
import org.cyclops.cyclopscore.client.icon.Icon;
import org.cyclops.cyclopscore.client.model.IDynamicModelElement;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.block.IDynamicLight;
import org.cyclops.integrateddynamics.api.block.IDynamicRedstone;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartRenderPosition;
import org.cyclops.integrateddynamics.block.BlockCableConfig;
import org.cyclops.integrateddynamics.block.shapes.VoxelShapeComponentsFactoryHandlerCableCenter;
import org.cyclops.integrateddynamics.block.shapes.VoxelShapeComponentsFactoryHandlerCableConnections;
import org.cyclops.integrateddynamics.block.shapes.VoxelShapeComponentsFactoryHandlerFacade;
import org.cyclops.integrateddynamics.block.shapes.VoxelShapeComponentsFactoryHandlerParts;
import org.cyclops.integrateddynamics.capability.dynamiclight.DynamicLightConfig;
import org.cyclops.integrateddynamics.capability.dynamicredstone.DynamicRedstoneConfig;
import org.cyclops.integrateddynamics.client.model.CableModel;
import org.cyclops.integrateddynamics.client.model.IRenderState;
import org.cyclops.integrateddynamics.core.block.BlockRayTraceResultComponent;
import org.cyclops.integrateddynamics.core.block.VoxelShapeComponents;
import org.cyclops.integrateddynamics.core.block.VoxelShapeComponentsFactory;
import org.cyclops.integrateddynamics.core.blockentity.BlockEntityMultipartTicking;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;

public class BlockCable
extends BlockWithEntity
implements IDynamicModelElement,
SimpleWaterloggedBlock {
    public static final float BLOCK_HARDNESS = 3.0f;
    public static final Material BLOCK_MATERIAL = Material.f_76275_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final ModelProperty<Boolean> REALCABLE = new ModelProperty();
    public static final ModelProperty<Boolean>[] CONNECTED = new ModelProperty[6];
    public static final ModelProperty<PartRenderPosition>[] PART_RENDERPOSITIONS = new ModelProperty[6];
    public static final ModelProperty<Optional<BlockState>> FACADE = new ModelProperty();
    public static final ModelProperty<IPartContainer> PARTCONTAINER;
    public static final ModelProperty<IRenderState> RENDERSTATE;
    public static final AABB CABLE_CENTER_BOUNDINGBOX;
    private static final EnumFacingMap<AABB> CABLE_SIDE_BOUNDINGBOXES;
    private final VoxelShapeComponentsFactory voxelShapeComponentsFactory = new VoxelShapeComponentsFactory(new VoxelShapeComponentsFactoryHandlerCableCenter(), new VoxelShapeComponentsFactoryHandlerCableConnections(), new VoxelShapeComponentsFactoryHandlerParts(), new VoxelShapeComponentsFactoryHandlerFacade());
    @OnlyIn(value=Dist.CLIENT)
    @Icon(location="block/cable")
    public TextureAtlasSprite texture;
    private boolean disableCollisionBox = false;
    private final Cache<String, VoxelShape> CACHE_COLLISION_SHAPES = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();

    public BlockCable(BlockBehaviour.Properties properties) {
        super(properties, BlockEntityMultipartTicking::new);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        if (MinecraftHelpers.isClientSide()) {
            IntegratedDynamics._instance.getIconProvider().registerIconHolderObject((Object)this);
        }
    }

    public boolean m_7923_(BlockState p_60576_) {
        return true;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : BlockCable.m_152132_(blockEntityType, RegistryEntries.BLOCK_ENTITY_MULTIPART_TICKING, new BlockEntityMultipartTicking.Ticker());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        NetworkHelpers.onElementProviderBlockNeighborChange((Level)worldIn, currentPos, facingState.m_60734_(), facing, facingPos);
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState ifluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_6044_(BlockGetter worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) == false && fluidIn == Fluids.f_76193_ && !CableHelpers.hasFacade(worldIn, pos);
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos blockPos, Explosion explosion) {
        CableHelpers.setRemovingCable(true);
        CableHelpers.onCableRemoving(world, blockPos, true, false);
        Collection<Direction> connectedCables = CableHelpers.getExternallyConnectedCables(world, blockPos);
        super.onBlockExploded(state, world, blockPos, explosion);
        CableHelpers.onCableRemoved(world, blockPos, connectedCables);
        CableHelpers.setRemovingCable(false);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockRayTraceResultComponent rayTraceResult = this.getSelectedShape(state, (BlockGetter)world, pos, CollisionContext.m_82750_((Entity)player)).rayTrace(pos, (Entity)player);
        if (rayTraceResult != null && rayTraceResult.getComponent().destroy(world, pos, player, false)) {
            return false;
        }
        return rayTraceResult != null && super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void m_6810_(BlockState state, Level world, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (newState.m_60734_() != this) {
            Collection<Direction> connectedCables = null;
            if (!CableHelpers.isRemovingCable()) {
                CableHelpers.onCableRemoving(world, blockPos, false, false);
                connectedCables = CableHelpers.getExternallyConnectedCables(world, blockPos);
            }
            super.m_6810_(state, world, blockPos, newState, isMoving);
            if (!CableHelpers.isRemovingCable()) {
                CableHelpers.onCableRemoved(world, blockPos, connectedCables);
            }
        } else {
            super.m_6810_(state, world, blockPos, newState, isMoving);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult actionResultType;
        BlockRayTraceResultComponent rayTraceResult;
        BlockEntityMultipartTicking tile = BlockEntityHelpers.get((BlockGetter)world, (BlockPos)pos, BlockEntityMultipartTicking.class).orElse(null);
        if (tile != null && (rayTraceResult = this.getSelectedShape(state, (BlockGetter)world, pos, CollisionContext.m_82750_((Entity)player)).rayTrace(pos, (Entity)player)) != null && (actionResultType = rayTraceResult.getComponent().onBlockActivated(state, world, pos, player, hand, rayTraceResult)).m_19077_()) {
            return actionResultType;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, world, pos, oldState, isMoving);
        if (!world.m_5776_() && !state.m_155947_()) {
            CableHelpers.onCableAdded(world, pos);
        }
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        super.m_6402_(world, pos, state, placer, itemStack);
        if (!world.m_5776_()) {
            CableHelpers.onCableAddedByPlayer(world, pos, placer);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos blockPos, Player player) {
        BlockRayTraceResultComponent rayTraceResult = this.getSelectedShape(state, world, blockPos, CollisionContext.m_82750_((Entity)player)).rayTrace(blockPos, (Entity)player);
        if (rayTraceResult != null) {
            return rayTraceResult.getComponent().getCloneItemStack((Level)world, blockPos);
        }
        return this.m_7397_(world, blockPos, state);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, world, pos, neighborBlock, fromPos, isMoving);
        NetworkHelpers.onElementProviderBlockNeighborChange(world, pos, neighborBlock, null, fromPos);
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, world, pos, neighbor);
        if (world instanceof Level) {
            NetworkHelpers.onElementProviderBlockNeighborChange((Level)world, pos, world.m_8055_(neighbor).m_60734_(), null, neighbor);
        }
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        super.m_213897_(state, world, pos, rand);
        BlockEntityHelpers.get((BlockGetter)world, (BlockPos)pos, BlockEntityMultipartTicking.class).ifPresent(tile -> {
            for (Map.Entry entry : tile.getPartContainer().getPartData().entrySet()) {
                this.updateTickPart(((PartHelpers.PartStateHolder)entry.getValue()).getPart(), (Level)world, pos, (IPartState)((PartHelpers.PartStateHolder)entry.getValue()).getState(), rand);
            }
        });
    }

    protected void updateTickPart(IPartType partType, Level world, BlockPos pos, IPartState partState, RandomSource random) {
        partType.updateTick(world, pos, partState, random);
    }

    public AABB getCableBoundingBox(Direction side) {
        if (side == null) {
            return CABLE_CENTER_BOUNDINGBOX;
        }
        return (AABB)CABLE_SIDE_BOUNDINGBOXES.get((Object)side);
    }

    public VoxelShapeComponents getSelectedShape(BlockState blockState, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        return this.voxelShapeComponentsFactory.createShape(blockState, world, pos, selectionContext);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        VoxelShapeComponents selectedShape = this.getSelectedShape(state, world, pos, selectionContext);
        BlockRayTraceResultComponent rayTraceResult = selectedShape.rayTrace(pos, selectionContext instanceof EntityCollisionContext ? ((EntityCollisionContext)selectionContext).m_193113_() : null);
        if (rayTraceResult != null) {
            return rayTraceResult.getComponent().getShape(state, world, pos, selectionContext);
        }
        return selectedShape;
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        if (this.disableCollisionBox) {
            return Shapes.m_83040_();
        }
        VoxelShapeComponents voxelShapeComponents = (VoxelShapeComponents)super.m_5939_(blockState, world, pos, selectionContext);
        String cableState = voxelShapeComponents.getStateId();
        return (VoxelShape)this.CACHE_COLLISION_SHAPES.get((Object)cableState, () -> {
            Iterator<VoxelShape> it = voxelShapeComponents.iterator();
            if (!it.hasNext()) {
                return Shapes.m_83040_();
            }
            VoxelShape shape = it.next();
            while (it.hasNext()) {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)it.next(), (BooleanOp)BooleanOp.f_82695_);
            }
            return shape.m_83296_();
        });
    }

    public boolean m_49967_() {
        return BlockCableConfig.dynamicShape;
    }

    public int m_7753_(BlockState blockState, BlockGetter world, BlockPos pos) {
        if (CableHelpers.isLightTransparent(world, pos, null)) {
            return 0;
        }
        return CableHelpers.getFacade(world, pos).map(facade -> facade.m_60739_(world, pos)).orElse(0);
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(new IClientBlockExtensions(){

            public boolean addHitEffects(BlockState blockState, Level world, HitResult target, ParticleEngine particleManager) {
                BlockPos blockPos = ((BlockHitResult)target).m_82425_();
                if (CableHelpers.hasFacade((BlockGetter)world, blockPos)) {
                    CableHelpers.getFacade((BlockGetter)world, blockPos).ifPresent(facadeState -> RenderHelpers.addBlockHitEffects((ParticleEngine)particleManager, (ClientLevel)((ClientLevel)world), (BlockState)facadeState, (BlockPos)blockPos, (Direction)((BlockHitResult)target).m_82434_()));
                    return true;
                }
                return false;
            }
        });
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter world, BlockPos pos, FluidState fluidState) {
        return CableHelpers.getFacade((BlockGetter)world, pos).isPresent();
    }

    public boolean m_7899_(BlockState blockState) {
        return true;
    }

    public boolean canConnectRedstone(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        if (side == null) {
            for (Direction dummySide : Direction.values()) {
                IDynamicRedstone dynamicRedstone = (IDynamicRedstone)BlockEntityHelpers.getCapability((BlockGetter)world, (BlockPos)pos, (Direction)dummySide, DynamicRedstoneConfig.CAPABILITY).orElse(null);
                if (dynamicRedstone == null || dynamicRedstone.getRedstoneLevel() < 0 && !dynamicRedstone.isAllowRedstoneInput()) continue;
                return true;
            }
            return false;
        }
        IDynamicRedstone dynamicRedstone = (IDynamicRedstone)BlockEntityHelpers.getCapability((BlockGetter)world, (BlockPos)pos, (Direction)side.m_122424_(), DynamicRedstoneConfig.CAPABILITY).orElse(null);
        return dynamicRedstone != null && (dynamicRedstone.getRedstoneLevel() >= 0 || dynamicRedstone.isAllowRedstoneInput());
    }

    public int m_6376_(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        IDynamicRedstone dynamicRedstone = (IDynamicRedstone)BlockEntityHelpers.getCapability((BlockGetter)world, (BlockPos)pos, (Direction)side.m_122424_(), DynamicRedstoneConfig.CAPABILITY).orElse(null);
        return dynamicRedstone != null && dynamicRedstone.isDirect() ? dynamicRedstone.getRedstoneLevel() : 0;
    }

    public int m_6378_(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        IDynamicRedstone dynamicRedstone = (IDynamicRedstone)BlockEntityHelpers.getCapability((BlockGetter)world, (BlockPos)pos, (Direction)side.m_122424_(), DynamicRedstoneConfig.CAPABILITY).orElse(null);
        return dynamicRedstone != null ? dynamicRedstone.getRedstoneLevel() : 0;
    }

    public int getLightEmission(BlockState blockState, BlockGetter world, BlockPos pos) {
        int light = 0;
        for (Direction side : Direction.values()) {
            IDynamicLight dynamicLight = (IDynamicLight)BlockEntityHelpers.getCapability((BlockGetter)world, (BlockPos)pos, (Direction)side, DynamicLightConfig.CAPABILITY).orElse(null);
            if (dynamicLight == null) continue;
            light = Math.max(light, dynamicLight.getLightLevel());
        }
        return light;
    }

    public boolean hasDynamicModel() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BakedModel createDynamicModel(ModelEvent.BakingCompleted event) {
        CableModel model = new CableModel();
        ResourceLocation registryName = ForgeRegistries.BLOCKS.getKey((Object)this);
        event.getModels().put(new ModelResourceLocation(registryName, "waterlogged=false"), model);
        event.getModels().put(new ModelResourceLocation(registryName, "waterlogged=true"), model);
        event.getModels().put(new ModelResourceLocation(registryName, "inventory"), model);
        return model;
    }

    public void setDisableCollisionBox(boolean disableCollisionBox) {
        this.disableCollisionBox = disableCollisionBox;
    }

    static {
        for (Direction side : Direction.values()) {
            BlockCable.CONNECTED[side.ordinal()] = new ModelProperty();
            BlockCable.PART_RENDERPOSITIONS[side.ordinal()] = new ModelProperty();
        }
        PARTCONTAINER = new ModelProperty();
        RENDERSTATE = new ModelProperty();
        CABLE_CENTER_BOUNDINGBOX = new AABB(0.375, 0.375, 0.375, 0.625, 0.625, 0.625);
        CABLE_SIDE_BOUNDINGBOXES = EnumFacingMap.forAllValues((Object)new AABB(0.375, 0.0, 0.375, 0.625, 0.375, 0.625), (Object)new AABB(0.375, 0.625, 0.375, 0.625, 1.0, 0.625), (Object)new AABB(0.375, 0.375, 0.0, 0.625, 0.625, 0.375), (Object)new AABB(0.375, 0.625, 0.625, 0.625, 0.375, 1.0), (Object)new AABB(0.0, 0.375, 0.375, 0.375, 0.625, 0.625), (Object)new AABB(0.625, 0.375, 0.375, 1.0, 0.625, 0.625));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class BlockColor
    implements net.minecraft.client.color.block.BlockColor {
        public int m_92566_(BlockState blockState, @Nullable BlockAndTintGetter world, @Nullable BlockPos blockPos, int color) {
            return world == null || blockPos == null ? -1 : CableHelpers.getFacade((BlockGetter)world, blockPos).map(facadeState -> Minecraft.m_91087_().m_91298_().m_92577_(facadeState, world, blockPos, color)).orElse(-1);
        }
    }
}

