/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part.write;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.cyclopscore.helper.CollectionHelpers;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectWrite;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.api.part.write.IPartTypeWriter;
import org.cyclops.integrateddynamics.core.part.PartStateActiveVariableBase;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public class PartStateWriterBase<P extends IPartTypeWriter>
extends PartStateActiveVariableBase<P>
implements IPartStateWriter<P> {
    private IAspectWrite activeAspect = null;
    private Map<String, List<MutableComponent>> errorMessages = Maps.newHashMap();
    private boolean firstTick = true;

    public PartStateWriterBase(int inventorySize) {
        super(inventorySize);
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        if (this.activeAspect != null) {
            tag.m_128359_("activeAspectName", this.activeAspect.getUniqueName().toString());
        }
        NBTClassType.getType(Map.class, this.errorMessages).writePersistedField("errorMessages", this.errorMessages, tag);
        super.writeToNBT(tag);
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        IAspect aspect = Aspects.REGISTRY.getAspect(new ResourceLocation(tag.m_128461_("activeAspectName")));
        if (aspect instanceof IAspectWrite) {
            this.activeAspect = (IAspectWrite)aspect;
        }
        this.errorMessages = (Map)NBTClassType.getType(Map.class, this.errorMessages).readPersistedField("errorMessages", tag);
        super.readFromNBT(tag);
    }

    @Override
    protected void validate(INetwork network, IPartNetwork partNetwork) {
        if (this.getActiveAspect() != null) {
            this.currentVariableFacade.validate(network, partNetwork, new Validator(this, this.getActiveAspect()), (IValueType)this.getActiveAspect().getValueType());
        }
    }

    @Override
    protected void onCorruptedState() {
        super.onCorruptedState();
        this.activeAspect = null;
    }

    @Override
    public boolean hasVariable() {
        return this.getActiveAspect() != null && this.getErrors(this.getActiveAspect()).isEmpty() && super.hasVariable();
    }

    @Override
    public void triggerAspectInfoUpdate(P partType, PartTarget target, IAspectWrite newAspect) {
        this.onVariableContentsUpdated(partType, target);
        IAspectWrite activeAspect = this.getActiveAspect();
        if (activeAspect != null && activeAspect != newAspect) {
            activeAspect.onDeactivate(partType, target, this);
        }
        if (newAspect != null && activeAspect != newAspect) {
            newAspect.onActivate(partType, target, this);
        }
        this.activeAspect = newAspect;
    }

    @Override
    public void onVariableContentsUpdated(P partType, PartTarget target) {
        super.onVariableContentsUpdated(partType, target);
        IAspectWrite activeAspect = this.getActiveAspect();
        if (activeAspect != null) {
            this.addError(activeAspect, null);
        }
    }

    @Override
    public IAspectWrite getActiveAspect() {
        return this.activeAspect;
    }

    @Override
    public List<MutableComponent> getErrors(IAspectWrite aspect) {
        List<MutableComponent> errors = this.errorMessages.get(aspect.getUniqueName().toString());
        if (errors == null) {
            return Collections.emptyList();
        }
        return errors;
    }

    @Override
    public void addError(IAspectWrite aspect, MutableComponent error) {
        if (error == null) {
            this.errorMessages.remove(aspect.getUniqueName().toString());
        } else {
            CollectionHelpers.addToMapList(this.errorMessages, (Object)aspect.getUniqueName().toString(), (Object)error);
        }
        this.onDirty();
        this.sendUpdate();
    }

    @Override
    public boolean checkAndResetFirstTick() {
        if (this.firstTick) {
            this.firstTick = false;
            return true;
        }
        return false;
    }

    public static class Validator
    implements IVariableFacade.IValidator {
        private final IPartStateWriter state;
        private final IAspectWrite aspect;

        public Validator(IPartStateWriter state, IAspectWrite aspect) {
            this.state = state;
            this.aspect = aspect;
        }

        @Override
        public void addError(MutableComponent error) {
            this.state.addError(this.aspect, error);
        }
    }
}

