/*
 * Decompiled with CFR 0.152.
 */
package com.boyonk.shutter.data;

import com.boyonk.shutter.Shutter;
import com.boyonk.shutter.block.ShutterBlock;
import com.boyonk.shutter.block.enums.ShutterType;
import com.boyonk.shutter.compat.BetterEndCompat;
import com.boyonk.shutter.compat.BetterNetherCompat;
import com.boyonk.shutter.compat.BiomesOPlentyCompat;
import com.boyonk.shutter.compat.PineCompat;
import com.boyonk.shutter.data.compat.BetterEndCompatDataGenerator;
import com.boyonk.shutter.data.compat.BetterNetherCompatDataGenerator;
import com.boyonk.shutter.data.compat.BiomesOPlentyCompatDataGenerator;
import com.boyonk.shutter.data.compat.PineCompatDataGenerator;
import com.boyonk.shutter.registry.tag.ShutterBlockTags;
import com.boyonk.shutter.registry.tag.ShutterItemTags;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2446;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2741;
import net.minecraft.class_2750;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_8790;
import org.jetbrains.annotations.Nullable;

public class ShutterDataGenerator
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator generator) {
        FabricDataGenerator.Pack pack = generator.createPack();
        pack.addProvider(ShutterModelProvider::new);
        pack.addProvider(ShutterBlockLootTableProvider::new);
        pack.addProvider(ShutterRecipeProvider::new);
        ShutterBlockTagProvider blockTagProvider = (ShutterBlockTagProvider)pack.addProvider(ShutterBlockTagProvider::new);
        pack.addProvider((output, registriesFuture) -> new ShutterItemTagProvider(output, registriesFuture, blockTagProvider));
        pack.addProvider(ShutterEnglishLanguageProvider::new);
        pack.addProvider(ShutterDutchLanguageProvider::new);
        BetterEndCompatDataGenerator.initialize(generator.createBuiltinResourcePack(BetterEndCompat.RESOURCE_PACK));
        BetterNetherCompatDataGenerator.initialize(generator.createBuiltinResourcePack(BetterNetherCompat.RESOURCE_PACK));
        BiomesOPlentyCompatDataGenerator.initialize(generator.createBuiltinResourcePack(BiomesOPlentyCompat.RESOURCE_PACK));
        PineCompatDataGenerator.initialize(generator.createBuiltinResourcePack(PineCompat.RESOURCE_PACK));
    }

    private static class ShutterBlockTagProvider
    extends FabricTagProvider.BlockTagProvider {
        public ShutterBlockTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            this.getOrCreateTagBuilder(ShutterBlockTags.WOODEN_SHUTTERS).add((Object[])new class_2248[]{Shutter.OAK_SHUTTER, Shutter.SPRUCE_SHUTTER, Shutter.BIRCH_SHUTTER, Shutter.JUNGLE_SHUTTER, Shutter.ACACIA_SHUTTER, Shutter.CHERRY_SHUTTER, Shutter.DARK_OAK_SHUTTER, Shutter.MANGROVE_SHUTTER, Shutter.BAMBOO_SHUTTER, Shutter.CRIMSON_SHUTTER, Shutter.WARPED_SHUTTER});
            this.getOrCreateTagBuilder(ShutterBlockTags.SHUTTERS).addTag(ShutterBlockTags.WOODEN_SHUTTERS).add((Object[])new class_2248[]{Shutter.IRON_SHUTTER, Shutter.COPPER_SHUTTER, Shutter.EXPOSED_COPPER_SHUTTER, Shutter.OXIDIZED_COPPER_SHUTTER, Shutter.WEATHERED_COPPER_SHUTTER, Shutter.WAXED_COPPER_SHUTTER, Shutter.WAXED_EXPOSED_COPPER_SHUTTER, Shutter.WAXED_OXIDIZED_COPPER_SHUTTER, Shutter.WAXED_WEATHERED_COPPER_SHUTTER});
            this.getOrCreateTagBuilder(class_3481.field_33713).addTag(ShutterBlockTags.WOODEN_SHUTTERS);
            this.getOrCreateTagBuilder(class_3481.field_33715).add((Object[])new class_2248[]{Shutter.IRON_SHUTTER, Shutter.COPPER_SHUTTER, Shutter.EXPOSED_COPPER_SHUTTER, Shutter.OXIDIZED_COPPER_SHUTTER, Shutter.WEATHERED_COPPER_SHUTTER, Shutter.WAXED_COPPER_SHUTTER, Shutter.WAXED_EXPOSED_COPPER_SHUTTER, Shutter.WAXED_OXIDIZED_COPPER_SHUTTER, Shutter.WAXED_WEATHERED_COPPER_SHUTTER});
        }
    }

    private static class ShutterItemTagProvider
    extends FabricTagProvider.ItemTagProvider {
        public ShutterItemTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> completableFuture, @Nullable FabricTagProvider.BlockTagProvider blockTagProvider) {
            super(output, completableFuture, blockTagProvider);
        }

        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            this.copy(ShutterBlockTags.WOODEN_SHUTTERS, ShutterItemTags.WOODEN_SHUTTERS);
            this.copy(ShutterBlockTags.SHUTTERS, ShutterItemTags.SHUTTERS);
            this.getOrCreateTagBuilder(class_3489.field_23211).add((Object[])new class_1792[]{Shutter.CRIMSON_SHUTTER.method_8389(), Shutter.WARPED_SHUTTER.method_8389()});
        }
    }

    private static class ShutterDutchLanguageProvider
    extends FabricLanguageProvider {
        protected ShutterDutchLanguageProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, "nl_nl", registryLookup);
        }

        public void generateTranslations(class_7225.class_7874 registryLookup, FabricLanguageProvider.TranslationBuilder builder) {
            builder.add(Shutter.OAK_SHUTTER, "Eikenhouten luik");
            builder.add(Shutter.SPRUCE_SHUTTER, "Sparrenhouten luik");
            builder.add(Shutter.BIRCH_SHUTTER, "Berkenhouten luik");
            builder.add(Shutter.JUNGLE_SHUTTER, "Oerwoudhouten luik");
            builder.add(Shutter.ACACIA_SHUTTER, "Acaciahouten luik");
            builder.add(Shutter.CHERRY_SHUTTER, "Kersenhouten luik");
            builder.add(Shutter.DARK_OAK_SHUTTER, "Donkereikenhouten luik");
            builder.add(Shutter.MANGROVE_SHUTTER, "Mangrovehouten luik");
            builder.add(Shutter.BAMBOO_SHUTTER, "Bamboeluik");
            builder.add(Shutter.IRON_SHUTTER, "IJzeren luik");
            builder.add(Shutter.CRIMSON_SHUTTER, "Helrode houten luik");
            builder.add(Shutter.WARPED_SHUTTER, "Helrode houten luik");
            builder.add(Shutter.COPPER_SHUTTER, "Koperen luik");
            builder.add(Shutter.EXPOSED_COPPER_SHUTTER, "Blootgesteld koperen luik");
            builder.add(Shutter.OXIDIZED_COPPER_SHUTTER, "Geoxideerd koperen luik");
            builder.add(Shutter.WEATHERED_COPPER_SHUTTER, "Verweerd koperen luik");
            builder.add(Shutter.WAXED_COPPER_SHUTTER, "Ingewassen koperen luik");
            builder.add(Shutter.WAXED_EXPOSED_COPPER_SHUTTER, "Ingewassen blootgesteld koperen luik");
            builder.add(Shutter.WAXED_OXIDIZED_COPPER_SHUTTER, "Ingewassen geoxideerd koperen luik");
            builder.add(Shutter.WAXED_WEATHERED_COPPER_SHUTTER, "Ingewassen verweerd koperen luik");
            builder.add(ShutterItemTags.WOODEN_SHUTTERS, "Houten luiken");
            builder.add(ShutterItemTags.SHUTTERS, "Luiken");
        }
    }

    private static class ShutterEnglishLanguageProvider
    extends FabricLanguageProvider {
        protected ShutterEnglishLanguageProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, "en_us", registryLookup);
        }

        public void generateTranslations(class_7225.class_7874 registryLookup, FabricLanguageProvider.TranslationBuilder builder) {
            builder.add(Shutter.OAK_SHUTTER, "Oak Shutter");
            builder.add(Shutter.SPRUCE_SHUTTER, "Spruce Shutter");
            builder.add(Shutter.BIRCH_SHUTTER, "Birch Shutter");
            builder.add(Shutter.JUNGLE_SHUTTER, "Jungle Shutter");
            builder.add(Shutter.ACACIA_SHUTTER, "Acacia Shutter");
            builder.add(Shutter.CHERRY_SHUTTER, "Cherry Shutter");
            builder.add(Shutter.DARK_OAK_SHUTTER, "Dark Oak Shutter");
            builder.add(Shutter.MANGROVE_SHUTTER, "Mangrove Shutter");
            builder.add(Shutter.BAMBOO_SHUTTER, "Bamboo Shutter");
            builder.add(Shutter.IRON_SHUTTER, "Iron Shutter");
            builder.add(Shutter.CRIMSON_SHUTTER, "Crimson Shutter");
            builder.add(Shutter.WARPED_SHUTTER, "Warped Shutter");
            builder.add(Shutter.COPPER_SHUTTER, "Copper Shutter");
            builder.add(Shutter.EXPOSED_COPPER_SHUTTER, "Exposed Copper Shutter");
            builder.add(Shutter.OXIDIZED_COPPER_SHUTTER, "Oxidized Copper Shutter");
            builder.add(Shutter.WEATHERED_COPPER_SHUTTER, "Weathered Copper Shutter");
            builder.add(Shutter.WAXED_COPPER_SHUTTER, "Waxed Copper Shutter");
            builder.add(Shutter.WAXED_EXPOSED_COPPER_SHUTTER, "Waxed Exposed Copper Shutter");
            builder.add(Shutter.WAXED_OXIDIZED_COPPER_SHUTTER, "Waxed Oxidized Copper Shutter");
            builder.add(Shutter.WAXED_WEATHERED_COPPER_SHUTTER, "Waxed Weathered Copper Shutter");
            builder.add(ShutterItemTags.WOODEN_SHUTTERS, "Wooden Shutters");
            builder.add(ShutterItemTags.SHUTTERS, "Shutters");
        }
    }

    public static class ShutterRecipeProvider
    extends FabricRecipeProvider {
        public ShutterRecipeProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        public void method_10419(class_8790 exporter) {
            ShutterRecipeProvider.offerWoodenShutterRecipe(exporter, (class_1935)Shutter.OAK_SHUTTER, (class_1935)class_2246.field_10161);
            ShutterRecipeProvider.offerWoodenShutterRecipe(exporter, (class_1935)Shutter.SPRUCE_SHUTTER, (class_1935)class_2246.field_9975);
            ShutterRecipeProvider.offerWoodenShutterRecipe(exporter, (class_1935)Shutter.BIRCH_SHUTTER, (class_1935)class_2246.field_10148);
            ShutterRecipeProvider.offerWoodenShutterRecipe(exporter, (class_1935)Shutter.JUNGLE_SHUTTER, (class_1935)class_2246.field_10334);
            ShutterRecipeProvider.offerWoodenShutterRecipe(exporter, (class_1935)Shutter.ACACIA_SHUTTER, (class_1935)class_2246.field_10218);
            ShutterRecipeProvider.offerWoodenShutterRecipe(exporter, (class_1935)Shutter.CHERRY_SHUTTER, (class_1935)class_2246.field_42751);
            ShutterRecipeProvider.offerWoodenShutterRecipe(exporter, (class_1935)Shutter.DARK_OAK_SHUTTER, (class_1935)class_2246.field_10075);
            ShutterRecipeProvider.offerWoodenShutterRecipe(exporter, (class_1935)Shutter.MANGROVE_SHUTTER, (class_1935)class_2246.field_37577);
            ShutterRecipeProvider.offerWoodenShutterRecipe(exporter, (class_1935)Shutter.BAMBOO_SHUTTER, (class_1935)class_2246.field_40294);
            ShutterRecipeProvider.offerShutterRecipe(exporter, (class_1935)Shutter.IRON_SHUTTER, (class_1935)class_1802.field_8620);
            ShutterRecipeProvider.offerWoodenShutterRecipe(exporter, (class_1935)Shutter.CRIMSON_SHUTTER, (class_1935)class_2246.field_22126);
            ShutterRecipeProvider.offerWoodenShutterRecipe(exporter, (class_1935)Shutter.WARPED_SHUTTER, (class_1935)class_2246.field_22127);
            ShutterRecipeProvider.offerShutterRecipe(exporter, (class_1935)Shutter.COPPER_SHUTTER, (class_1935)class_1802.field_27022);
            ShutterRecipeProvider.offerWaxingRecipe(exporter, (class_1935)Shutter.WAXED_COPPER_SHUTTER, (class_1935)Shutter.COPPER_SHUTTER);
            ShutterRecipeProvider.offerWaxingRecipe(exporter, (class_1935)Shutter.WAXED_EXPOSED_COPPER_SHUTTER, (class_1935)Shutter.EXPOSED_COPPER_SHUTTER);
            ShutterRecipeProvider.offerWaxingRecipe(exporter, (class_1935)Shutter.WAXED_OXIDIZED_COPPER_SHUTTER, (class_1935)Shutter.OXIDIZED_COPPER_SHUTTER);
            ShutterRecipeProvider.offerWaxingRecipe(exporter, (class_1935)Shutter.WAXED_WEATHERED_COPPER_SHUTTER, (class_1935)Shutter.WEATHERED_COPPER_SHUTTER);
        }

        public static void offerWoodenShutterRecipe(class_8790 exporter, class_1935 output, class_1935 input) {
            class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)output, (int)2).method_10434(Character.valueOf('#'), input).method_10439("# #").method_10439("# #").method_10439("# #").method_10435("wooden_shutter").method_10429(class_2446.method_32807((class_1935)input), class_2446.method_10426((class_1935)input)).method_10431(exporter);
        }

        public static void offerBetterXShutterRecipe(class_8790 exporter, class_1935 output, class_1935 input) {
            class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)output, (int)2).method_10434(Character.valueOf('#'), input).method_10439("# #").method_10439("# #").method_10439("# #").method_10435("shutter").method_10429(class_2446.method_32807((class_1935)input), class_2446.method_10426((class_1935)input)).method_10431(exporter);
        }

        public static void offerEndMetalShutterRecipe(class_8790 exporter, class_1935 output, class_1935 input) {
            class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)output, (int)2).method_10434(Character.valueOf('#'), input).method_10439("# #").method_10439("# #").method_10439("# #").method_10435("end_metal_shutters").method_10429(class_2446.method_32807((class_1935)input), class_2446.method_10426((class_1935)input)).method_10431(exporter);
        }

        public static void offerShutterRecipe(class_8790 exporter, class_1935 output, class_1935 input) {
            class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)output, (int)2).method_10434(Character.valueOf('#'), input).method_10439("# #").method_10439("# #").method_10439("# #").method_10429(class_2446.method_32807((class_1935)input), class_2446.method_10426((class_1935)input)).method_10431(exporter);
        }

        @Deprecated
        public static void offerCheapShutterRecipe(class_8790 exporter, class_1935 output, class_1935 input) {
            class_2447.method_10437((class_7800)class_7800.field_40635, (class_1935)output).method_10434(Character.valueOf('#'), input).method_10439("# #").method_10439("# #").method_10429(class_2446.method_32807((class_1935)input), class_2446.method_10426((class_1935)input)).method_10431(exporter);
        }

        public static void offerWaxingRecipe(class_8790 exporter, class_1935 output, class_1935 input) {
            class_2450.method_10447((class_7800)class_7800.field_40634, (class_1935)output).method_10454(input).method_10454((class_1935)class_1802.field_20414).method_10452(class_2446.method_33716((class_1935)output)).method_10442(class_2446.method_32807((class_1935)input), class_2446.method_10426((class_1935)input)).method_36443(exporter, class_2446.method_33714((class_1935)output, (class_1935)class_1802.field_20414));
        }
    }

    private static class ShutterBlockLootTableProvider
    extends FabricBlockLootTableProvider {
        protected ShutterBlockLootTableProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void method_10379() {
            this.method_46025(Shutter.OAK_SHUTTER);
            this.method_46025(Shutter.SPRUCE_SHUTTER);
            this.method_46025(Shutter.BIRCH_SHUTTER);
            this.method_46025(Shutter.JUNGLE_SHUTTER);
            this.method_46025(Shutter.ACACIA_SHUTTER);
            this.method_46025(Shutter.CHERRY_SHUTTER);
            this.method_46025(Shutter.DARK_OAK_SHUTTER);
            this.method_46025(Shutter.MANGROVE_SHUTTER);
            this.method_46025(Shutter.BAMBOO_SHUTTER);
            this.method_46025(Shutter.IRON_SHUTTER);
            this.method_46025(Shutter.CRIMSON_SHUTTER);
            this.method_46025(Shutter.WARPED_SHUTTER);
            this.method_46025(Shutter.COPPER_SHUTTER);
            this.method_46025(Shutter.EXPOSED_COPPER_SHUTTER);
            this.method_46025(Shutter.OXIDIZED_COPPER_SHUTTER);
            this.method_46025(Shutter.WEATHERED_COPPER_SHUTTER);
            this.method_46025(Shutter.WAXED_COPPER_SHUTTER);
            this.method_46025(Shutter.WAXED_EXPOSED_COPPER_SHUTTER);
            this.method_46025(Shutter.WAXED_OXIDIZED_COPPER_SHUTTER);
            this.method_46025(Shutter.WAXED_WEATHERED_COPPER_SHUTTER);
        }
    }

    public static class ShutterModelProvider
    extends FabricModelProvider {
        public static final class_4945 SINGLE = class_4945.method_27043((String)"single");
        public static final class_4945 TOP = class_4945.field_23015;
        public static final class_4945 MIDDLE = class_4945.method_27043((String)"middle");
        public static final class_4945 BOTTOM = class_4945.field_23014;
        public static final class_4942 SHUTTER_SINGLE_LEFT = new class_4942(Optional.of(class_2960.method_60655((String)"shutter", (String)"block/shutter_single_left")), Optional.of("_single_left"), new class_4945[]{SINGLE});
        public static final class_4942 SHUTTER_SINGLE_LEFT_OPEN = new class_4942(Optional.of(class_2960.method_60655((String)"shutter", (String)"block/shutter_single_left_open")), Optional.of("_single_left_open"), new class_4945[]{SINGLE});
        public static final class_4942 SHUTTER_SINGLE_RIGHT = new class_4942(Optional.of(class_2960.method_60655((String)"shutter", (String)"block/shutter_single_right")), Optional.of("_single_right"), new class_4945[]{SINGLE});
        public static final class_4942 SHUTTER_SINGLE_RIGHT_OPEN = new class_4942(Optional.of(class_2960.method_60655((String)"shutter", (String)"block/shutter_single_right_open")), Optional.of("_single_right_open"), new class_4945[]{SINGLE});
        public static final class_4942 SHUTTER_TOP_LEFT = new class_4942(Optional.of(class_2960.method_60655((String)"shutter", (String)"block/shutter_top_left")), Optional.of("_top_left"), new class_4945[]{TOP});
        public static final class_4942 SHUTTER_TOP_LEFT_OPEN = new class_4942(Optional.of(class_2960.method_60655((String)"shutter", (String)"block/shutter_top_left_open")), Optional.of("_top_left_open"), new class_4945[]{TOP});
        public static final class_4942 SHUTTER_TOP_RIGHT = new class_4942(Optional.of(class_2960.method_60655((String)"shutter", (String)"block/shutter_top_right")), Optional.of("_top_right"), new class_4945[]{TOP});
        public static final class_4942 SHUTTER_TOP_RIGHT_OPEN = new class_4942(Optional.of(class_2960.method_60655((String)"shutter", (String)"block/shutter_top_right_open")), Optional.of("_top_right_open"), new class_4945[]{TOP});
        public static final class_4942 SHUTTER_MIDDLE_LEFT = new class_4942(Optional.of(class_2960.method_60655((String)"shutter", (String)"block/shutter_middle_left")), Optional.of("_middle_left"), new class_4945[]{MIDDLE});
        public static final class_4942 SHUTTER_MIDDLE_LEFT_OPEN = new class_4942(Optional.of(class_2960.method_60655((String)"shutter", (String)"block/shutter_middle_left_open")), Optional.of("_middle_left_open"), new class_4945[]{MIDDLE});
        public static final class_4942 SHUTTER_MIDDLE_RIGHT = new class_4942(Optional.of(class_2960.method_60655((String)"shutter", (String)"block/shutter_middle_right")), Optional.of("_middle_right"), new class_4945[]{MIDDLE});
        public static final class_4942 SHUTTER_MIDDLE_RIGHT_OPEN = new class_4942(Optional.of(class_2960.method_60655((String)"shutter", (String)"block/shutter_middle_right_open")), Optional.of("_middle_right_open"), new class_4945[]{MIDDLE});
        public static final class_4942 SHUTTER_BOTTOM_LEFT = new class_4942(Optional.of(class_2960.method_60655((String)"shutter", (String)"block/shutter_bottom_left")), Optional.of("_bottom_left"), new class_4945[]{BOTTOM});
        public static final class_4942 SHUTTER_BOTTOM_LEFT_OPEN = new class_4942(Optional.of(class_2960.method_60655((String)"shutter", (String)"block/shutter_bottom_left_open")), Optional.of("_bottom_left_open"), new class_4945[]{BOTTOM});
        public static final class_4942 SHUTTER_BOTTOM_RIGHT = new class_4942(Optional.of(class_2960.method_60655((String)"shutter", (String)"block/shutter_bottom_right")), Optional.of("_bottom_right"), new class_4945[]{BOTTOM});
        public static final class_4942 SHUTTER_BOTTOM_RIGHT_OPEN = new class_4942(Optional.of(class_2960.method_60655((String)"shutter", (String)"block/shutter_bottom_right_open")), Optional.of("_bottom_right_open"), new class_4945[]{BOTTOM});
        public static final class_4942 SHUTTER_INVENTORY = new class_4942(Optional.of(class_2960.method_60655((String)"shutter", (String)"block/shutter_inventory")), Optional.empty(), new class_4945[]{SINGLE});

        public ShutterModelProvider(FabricDataOutput output) {
            super(output);
        }

        public void generateBlockStateModels(class_4910 generator) {
            ShutterModelProvider.registerShutter(generator, Shutter.OAK_SHUTTER);
            ShutterModelProvider.registerShutter(generator, Shutter.SPRUCE_SHUTTER);
            ShutterModelProvider.registerShutter(generator, Shutter.BIRCH_SHUTTER);
            ShutterModelProvider.registerShutter(generator, Shutter.JUNGLE_SHUTTER);
            ShutterModelProvider.registerShutter(generator, Shutter.ACACIA_SHUTTER);
            ShutterModelProvider.registerShutter(generator, Shutter.CHERRY_SHUTTER);
            ShutterModelProvider.registerShutter(generator, Shutter.DARK_OAK_SHUTTER);
            ShutterModelProvider.registerShutter(generator, Shutter.MANGROVE_SHUTTER);
            ShutterModelProvider.registerShutter(generator, Shutter.BAMBOO_SHUTTER);
            ShutterModelProvider.registerShutter(generator, Shutter.IRON_SHUTTER);
            ShutterModelProvider.registerShutter(generator, Shutter.CRIMSON_SHUTTER);
            ShutterModelProvider.registerShutter(generator, Shutter.WARPED_SHUTTER);
            ShutterModelProvider.registerShutter(generator, Shutter.COPPER_SHUTTER);
            ShutterModelProvider.registerShutter(generator, Shutter.EXPOSED_COPPER_SHUTTER);
            ShutterModelProvider.registerShutter(generator, Shutter.OXIDIZED_COPPER_SHUTTER);
            ShutterModelProvider.registerShutter(generator, Shutter.WEATHERED_COPPER_SHUTTER);
            ShutterModelProvider.registerParentedShutter(generator, Shutter.WAXED_COPPER_SHUTTER, Shutter.COPPER_SHUTTER);
            ShutterModelProvider.registerParentedShutter(generator, Shutter.WAXED_EXPOSED_COPPER_SHUTTER, Shutter.EXPOSED_COPPER_SHUTTER);
            ShutterModelProvider.registerParentedShutter(generator, Shutter.WAXED_OXIDIZED_COPPER_SHUTTER, Shutter.OXIDIZED_COPPER_SHUTTER);
            ShutterModelProvider.registerParentedShutter(generator, Shutter.WAXED_WEATHERED_COPPER_SHUTTER, Shutter.WEATHERED_COPPER_SHUTTER);
        }

        public void generateItemModels(class_4915 itemModelGenerator) {
        }

        public static void registerShutter(class_4910 generator, class_2248 block) {
            class_4944 textureMap = new class_4944().method_25868(SINGLE, class_4944.method_25866((class_2248)block, (String)"_single")).method_25868(TOP, class_4944.method_25866((class_2248)block, (String)"_top")).method_25868(MIDDLE, class_4944.method_25866((class_2248)block, (String)"_middle")).method_25868(BOTTOM, class_4944.method_25866((class_2248)block, (String)"_bottom"));
            class_2960 singleLeft = SHUTTER_SINGLE_LEFT.method_25846(block, textureMap, generator.field_22831);
            class_2960 singleLeftOpen = SHUTTER_SINGLE_LEFT_OPEN.method_25846(block, textureMap, generator.field_22831);
            class_2960 singleRight = SHUTTER_SINGLE_RIGHT.method_25846(block, textureMap, generator.field_22831);
            class_2960 singleRightOpen = SHUTTER_SINGLE_RIGHT_OPEN.method_25846(block, textureMap, generator.field_22831);
            class_2960 topLeft = SHUTTER_TOP_LEFT.method_25846(block, textureMap, generator.field_22831);
            class_2960 topLeftOpen = SHUTTER_TOP_LEFT_OPEN.method_25846(block, textureMap, generator.field_22831);
            class_2960 topRight = SHUTTER_TOP_RIGHT.method_25846(block, textureMap, generator.field_22831);
            class_2960 topRightOpen = SHUTTER_TOP_RIGHT_OPEN.method_25846(block, textureMap, generator.field_22831);
            class_2960 middleLeft = SHUTTER_MIDDLE_LEFT.method_25846(block, textureMap, generator.field_22831);
            class_2960 middleLeftOpen = SHUTTER_MIDDLE_LEFT_OPEN.method_25846(block, textureMap, generator.field_22831);
            class_2960 middleRight = SHUTTER_MIDDLE_RIGHT.method_25846(block, textureMap, generator.field_22831);
            class_2960 middleRightOpen = SHUTTER_MIDDLE_RIGHT_OPEN.method_25846(block, textureMap, generator.field_22831);
            class_2960 bottomLeft = SHUTTER_BOTTOM_LEFT.method_25846(block, textureMap, generator.field_22831);
            class_2960 bottomLeftOpen = SHUTTER_BOTTOM_LEFT_OPEN.method_25846(block, textureMap, generator.field_22831);
            class_2960 bottomRight = SHUTTER_BOTTOM_RIGHT.method_25846(block, textureMap, generator.field_22831);
            class_2960 bottomRightOpen = SHUTTER_BOTTOM_RIGHT_OPEN.method_25846(block, textureMap, generator.field_22831);
            SHUTTER_INVENTORY.method_25852(class_4941.method_25840((class_1792)block.method_8389()), textureMap, generator.field_22831);
            generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(ShutterModelProvider.fillShutterVariantMap(ShutterType.SINGLE, singleLeft, singleLeftOpen, singleRight, singleRightOpen, ShutterModelProvider.fillShutterVariantMap(ShutterType.TOP, topLeft, topLeftOpen, topRight, topRightOpen, ShutterModelProvider.fillShutterVariantMap(ShutterType.MIDDLE, middleLeft, middleLeftOpen, middleRight, middleRightOpen, ShutterModelProvider.fillShutterVariantMap(ShutterType.BOTTOM, bottomLeft, bottomLeftOpen, bottomRight, bottomRightOpen, (class_4926.class_4930<class_2350, ShutterType, class_2750, Boolean>)class_4926.method_25786((class_2769)class_2741.field_12481, ShutterBlock.TYPE, (class_2769)class_2741.field_12520, (class_2769)class_2741.field_12537)))))));
        }

        public static void registerParentedShutter(class_4910 generator, class_2248 block, class_2248 parent) {
            class_2960 singleLeft = SHUTTER_SINGLE_LEFT.method_54828(parent);
            class_2960 singleLeftOpen = SHUTTER_SINGLE_LEFT_OPEN.method_54828(parent);
            class_2960 singleRight = SHUTTER_SINGLE_RIGHT.method_54828(parent);
            class_2960 singleRightOpen = SHUTTER_SINGLE_RIGHT_OPEN.method_54828(parent);
            class_2960 topLeft = SHUTTER_TOP_LEFT.method_54828(parent);
            class_2960 topLeftOpen = SHUTTER_TOP_LEFT_OPEN.method_54828(parent);
            class_2960 topRight = SHUTTER_TOP_RIGHT.method_54828(parent);
            class_2960 topRightOpen = SHUTTER_TOP_RIGHT_OPEN.method_54828(parent);
            class_2960 middleLeft = SHUTTER_MIDDLE_LEFT.method_54828(parent);
            class_2960 middleLeftOpen = SHUTTER_MIDDLE_LEFT_OPEN.method_54828(parent);
            class_2960 middleRight = SHUTTER_MIDDLE_RIGHT.method_54828(parent);
            class_2960 middleRightOpen = SHUTTER_MIDDLE_RIGHT_OPEN.method_54828(parent);
            class_2960 bottomLeft = SHUTTER_BOTTOM_LEFT.method_54828(parent);
            class_2960 bottomLeftOpen = SHUTTER_BOTTOM_LEFT_OPEN.method_54828(parent);
            class_2960 bottomRight = SHUTTER_BOTTOM_RIGHT.method_54828(parent);
            class_2960 bottomRightOpen = SHUTTER_BOTTOM_RIGHT_OPEN.method_54828(parent);
            generator.method_25623(block, class_4941.method_25840((class_1792)parent.method_8389()));
            generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(ShutterModelProvider.fillShutterVariantMap(ShutterType.SINGLE, singleLeft, singleLeftOpen, singleRight, singleRightOpen, ShutterModelProvider.fillShutterVariantMap(ShutterType.TOP, topLeft, topLeftOpen, topRight, topRightOpen, ShutterModelProvider.fillShutterVariantMap(ShutterType.MIDDLE, middleLeft, middleLeftOpen, middleRight, middleRightOpen, ShutterModelProvider.fillShutterVariantMap(ShutterType.BOTTOM, bottomLeft, bottomLeftOpen, bottomRight, bottomRightOpen, (class_4926.class_4930<class_2350, ShutterType, class_2750, Boolean>)class_4926.method_25786((class_2769)class_2741.field_12481, ShutterBlock.TYPE, (class_2769)class_2741.field_12520, (class_2769)class_2741.field_12537)))))));
        }

        public static class_4926.class_4930<class_2350, ShutterType, class_2750, Boolean> fillShutterVariantMap(ShutterType targetHalf, class_2960 left, class_2960 leftOpen, class_2960 right, class_2960 rightOpen, class_4926.class_4930<class_2350, ShutterType, class_2750, Boolean> variantMap) {
            return variantMap.method_25811((Comparable)class_2350.field_11034, (Comparable)((Object)targetHalf), (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)left)).method_25811((Comparable)class_2350.field_11035, (Comparable)((Object)targetHalf), (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)left).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25811((Comparable)class_2350.field_11039, (Comparable)((Object)targetHalf), (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)left).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25811((Comparable)class_2350.field_11043, (Comparable)((Object)targetHalf), (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)left).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25811((Comparable)class_2350.field_11034, (Comparable)((Object)targetHalf), (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)right)).method_25811((Comparable)class_2350.field_11035, (Comparable)((Object)targetHalf), (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)right).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25811((Comparable)class_2350.field_11039, (Comparable)((Object)targetHalf), (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)right).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25811((Comparable)class_2350.field_11043, (Comparable)((Object)targetHalf), (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)right).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25811((Comparable)class_2350.field_11034, (Comparable)((Object)targetHalf), (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)leftOpen).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25811((Comparable)class_2350.field_11035, (Comparable)((Object)targetHalf), (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)leftOpen).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25811((Comparable)class_2350.field_11039, (Comparable)((Object)targetHalf), (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)leftOpen).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25811((Comparable)class_2350.field_11043, (Comparable)((Object)targetHalf), (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)leftOpen)).method_25811((Comparable)class_2350.field_11034, (Comparable)((Object)targetHalf), (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)rightOpen).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25811((Comparable)class_2350.field_11035, (Comparable)((Object)targetHalf), (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)rightOpen)).method_25811((Comparable)class_2350.field_11039, (Comparable)((Object)targetHalf), (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)rightOpen).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25811((Comparable)class_2350.field_11043, (Comparable)((Object)targetHalf), (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)rightOpen).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892));
        }
    }
}

