/*
 * Decompiled with CFR 0.152.
 */
package com.boyonk.shutter.data.compat;

import com.boyonk.shutter.compat.BetterNetherCompat;
import com.boyonk.shutter.data.ShutterDataGenerator;
import com.boyonk.shutter.registry.tag.ShutterBlockTags;
import com.boyonk.shutter.registry.tag.ShutterItemTags;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_7225;
import net.minecraft.class_8790;
import org.betterx.betternether.registry.NetherBlocks;
import org.jetbrains.annotations.Nullable;

public class BetterNetherCompatDataGenerator {
    public static void initialize(FabricDataGenerator.Pack pack) {
        pack.addProvider(BetterNetherCompatModelProvider::new);
        pack.addProvider(BetterNetherCompatBlockLootTableProvider::new);
        pack.addProvider(BetterNetherCompatRecipeProvider::new);
        BetterNetherCompatBlockTagProvider blockTagProvider = (BetterNetherCompatBlockTagProvider)pack.addProvider(BetterNetherCompatBlockTagProvider::new);
        pack.addProvider((output, registriesFuture) -> new BetterNetherCompatItemTagProvider(output, registriesFuture, blockTagProvider));
        pack.addProvider(BetterNetherCompatEnglishLanguageProvider::new);
    }

    private static class BetterNetherCompatBlockTagProvider
    extends FabricTagProvider.BlockTagProvider {
        public BetterNetherCompatBlockTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            this.getOrCreateTagBuilder(ShutterBlockTags.WOODEN_SHUTTERS).add((Object[])new class_2248[]{BetterNetherCompat.WILLOW_SHUTTER, BetterNetherCompat.ANCHOR_TREE_SHUTTER, BetterNetherCompat.MUSHROOM_FIR_SHUTTER, BetterNetherCompat.NETHER_MUSHROOM_SHUTTER, BetterNetherCompat.NETHER_REED_SHUTTER, BetterNetherCompat.NETHER_SAKURA_SHUTTER, BetterNetherCompat.RUBEUS_SHUTTER, BetterNetherCompat.STALAGNATE_SHUTTER, BetterNetherCompat.WART_SHUTTER});
        }
    }

    private static class BetterNetherCompatItemTagProvider
    extends FabricTagProvider.ItemTagProvider {
        public BetterNetherCompatItemTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> completableFuture, @Nullable FabricTagProvider.BlockTagProvider blockTagProvider) {
            super(output, completableFuture, blockTagProvider);
        }

        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            this.copy(ShutterBlockTags.WOODEN_SHUTTERS, ShutterItemTags.WOODEN_SHUTTERS);
        }
    }

    private static class BetterNetherCompatEnglishLanguageProvider
    extends FabricLanguageProvider {
        protected BetterNetherCompatEnglishLanguageProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, "en_us", registryLookup);
        }

        public void generateTranslations(class_7225.class_7874 registryLookup, FabricLanguageProvider.TranslationBuilder builder) {
            builder.add(BetterNetherCompat.WILLOW_SHUTTER, "Willow Shutter");
            builder.add(BetterNetherCompat.ANCHOR_TREE_SHUTTER, "Anchor Tree Shutter");
            builder.add(BetterNetherCompat.MUSHROOM_FIR_SHUTTER, "Mushroom Fir Shutter");
            builder.add(BetterNetherCompat.NETHER_MUSHROOM_SHUTTER, "Mushroom Shutter");
            builder.add(BetterNetherCompat.NETHER_REED_SHUTTER, "Reeds Shutter");
            builder.add(BetterNetherCompat.NETHER_SAKURA_SHUTTER, "Nether Sakura Shutter");
            builder.add(BetterNetherCompat.RUBEUS_SHUTTER, "Rubeus Shutter");
            builder.add(BetterNetherCompat.STALAGNATE_SHUTTER, "Stalagnate Shutter");
            builder.add(BetterNetherCompat.WART_SHUTTER, "Wart Shutter");
        }
    }

    private static class BetterNetherCompatRecipeProvider
    extends FabricRecipeProvider {
        public BetterNetherCompatRecipeProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        public void method_10419(class_8790 exporter) {
            ShutterDataGenerator.ShutterRecipeProvider.offerBetterXShutterRecipe(exporter, (class_1935)BetterNetherCompat.WILLOW_SHUTTER, (class_1935)NetherBlocks.MAT_WILLOW.getPlanks());
            ShutterDataGenerator.ShutterRecipeProvider.offerBetterXShutterRecipe(exporter, (class_1935)BetterNetherCompat.ANCHOR_TREE_SHUTTER, (class_1935)NetherBlocks.MAT_ANCHOR_TREE.getPlanks());
            ShutterDataGenerator.ShutterRecipeProvider.offerBetterXShutterRecipe(exporter, (class_1935)BetterNetherCompat.MUSHROOM_FIR_SHUTTER, (class_1935)NetherBlocks.MAT_MUSHROOM_FIR.getPlanks());
            ShutterDataGenerator.ShutterRecipeProvider.offerBetterXShutterRecipe(exporter, (class_1935)BetterNetherCompat.NETHER_MUSHROOM_SHUTTER, (class_1935)NetherBlocks.MAT_NETHER_MUSHROOM.getPlanks());
            ShutterDataGenerator.ShutterRecipeProvider.offerBetterXShutterRecipe(exporter, (class_1935)BetterNetherCompat.NETHER_REED_SHUTTER, (class_1935)NetherBlocks.MAT_REED.getPlanks());
            ShutterDataGenerator.ShutterRecipeProvider.offerBetterXShutterRecipe(exporter, (class_1935)BetterNetherCompat.NETHER_SAKURA_SHUTTER, (class_1935)NetherBlocks.MAT_NETHER_SAKURA.getPlanks());
            ShutterDataGenerator.ShutterRecipeProvider.offerBetterXShutterRecipe(exporter, (class_1935)BetterNetherCompat.RUBEUS_SHUTTER, (class_1935)NetherBlocks.MAT_RUBEUS.getPlanks());
            ShutterDataGenerator.ShutterRecipeProvider.offerBetterXShutterRecipe(exporter, (class_1935)BetterNetherCompat.STALAGNATE_SHUTTER, (class_1935)NetherBlocks.MAT_STALAGNATE.getPlanks());
            ShutterDataGenerator.ShutterRecipeProvider.offerBetterXShutterRecipe(exporter, (class_1935)BetterNetherCompat.WART_SHUTTER, (class_1935)NetherBlocks.MAT_WART.getPlanks());
        }
    }

    private static class BetterNetherCompatBlockLootTableProvider
    extends FabricBlockLootTableProvider {
        protected BetterNetherCompatBlockLootTableProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void method_10379() {
            this.method_46025(BetterNetherCompat.WILLOW_SHUTTER);
            this.method_46025(BetterNetherCompat.ANCHOR_TREE_SHUTTER);
            this.method_46025(BetterNetherCompat.MUSHROOM_FIR_SHUTTER);
            this.method_46025(BetterNetherCompat.NETHER_MUSHROOM_SHUTTER);
            this.method_46025(BetterNetherCompat.NETHER_REED_SHUTTER);
            this.method_46025(BetterNetherCompat.NETHER_SAKURA_SHUTTER);
            this.method_46025(BetterNetherCompat.RUBEUS_SHUTTER);
            this.method_46025(BetterNetherCompat.STALAGNATE_SHUTTER);
            this.method_46025(BetterNetherCompat.WART_SHUTTER);
        }
    }

    private static class BetterNetherCompatModelProvider
    extends FabricModelProvider {
        public BetterNetherCompatModelProvider(FabricDataOutput output) {
            super(output);
        }

        public void generateBlockStateModels(class_4910 generator) {
            ShutterDataGenerator.ShutterModelProvider.registerShutter(generator, BetterNetherCompat.WILLOW_SHUTTER);
            ShutterDataGenerator.ShutterModelProvider.registerShutter(generator, BetterNetherCompat.ANCHOR_TREE_SHUTTER);
            ShutterDataGenerator.ShutterModelProvider.registerShutter(generator, BetterNetherCompat.MUSHROOM_FIR_SHUTTER);
            ShutterDataGenerator.ShutterModelProvider.registerShutter(generator, BetterNetherCompat.NETHER_MUSHROOM_SHUTTER);
            ShutterDataGenerator.ShutterModelProvider.registerShutter(generator, BetterNetherCompat.NETHER_REED_SHUTTER);
            ShutterDataGenerator.ShutterModelProvider.registerShutter(generator, BetterNetherCompat.NETHER_SAKURA_SHUTTER);
            ShutterDataGenerator.ShutterModelProvider.registerShutter(generator, BetterNetherCompat.RUBEUS_SHUTTER);
            ShutterDataGenerator.ShutterModelProvider.registerShutter(generator, BetterNetherCompat.STALAGNATE_SHUTTER);
            ShutterDataGenerator.ShutterModelProvider.registerShutter(generator, BetterNetherCompat.WART_SHUTTER);
        }

        public void generateItemModels(class_4915 generator) {
        }
    }
}

