/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.renderer.blockentity;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalNotification;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import li.cil.oc2.client.renderer.ModRenderType;
import li.cil.oc2.common.block.ComputerBlock;
import li.cil.oc2.common.blockentity.ComputerBlockEntity;
import li.cil.oc2.common.util.ChainableVertexConsumer;
import li.cil.oc2.common.vm.terminal.Terminal;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="oc2r", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ComputerRenderer
implements BlockEntityRenderer<ComputerBlockEntity> {
    public static final ResourceLocation OVERLAY_POWER_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"oc2r", (String)"block/computer/computer_overlay_power");
    public static final ResourceLocation OVERLAY_STATUS_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"oc2r", (String)"block/computer/computer_overlay_status");
    public static final ResourceLocation OVERLAY_TERMINAL_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"oc2r", (String)"block/computer/computer_overlay_terminal");
    private static final Material TEXTURE_POWER = new Material(InventoryMenu.f_39692_, OVERLAY_POWER_LOCATION);
    private static final Material TEXTURE_STATUS = new Material(InventoryMenu.f_39692_, OVERLAY_STATUS_LOCATION);
    private static final Material TEXTURE_TERMINAL = new Material(InventoryMenu.f_39692_, OVERLAY_TERMINAL_LOCATION);
    private static final Cache<Terminal, Terminal.RendererView> rendererViews = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofSeconds(5L)).removalListener(ComputerRenderer::handleNoLongerRendering).build();
    private final BlockEntityRenderDispatcher renderer;

    public ComputerRenderer(BlockEntityRendererProvider.Context context) {
        this.renderer = context.m_173581_();
    }

    public void render(ComputerBlockEntity computer, float partialTicks, PoseStack stack, MultiBufferSource bufferSource, int light, int overlay) {
        Direction blockFacing = (Direction)computer.m_58900_().m_61143_((Property)ComputerBlock.f_54117_);
        Vec3 cameraPosition = this.renderer.f_112249_.m_90592_().m_20299_(partialTicks);
        Vec3 relativeCameraPosition = cameraPosition.m_82546_(Vec3.m_82512_((Vec3i)computer.m_58899_()));
        double projectedCameraPosition = relativeCameraPosition.m_82526_(Vec3.m_82528_((Vec3i)blockFacing.m_122436_()));
        if (projectedCameraPosition <= 0.0) {
            return;
        }
        stack.m_85836_();
        stack.m_252880_(0.5f, 0.0f, 0.5f);
        stack.m_252781_(Axis.f_252392_.m_252977_(blockFacing.m_122435_() + 180.0f));
        stack.m_252880_(-0.5f, 0.0f, -0.5f);
        stack.m_252880_(1.0f, 1.0f, 0.0f);
        stack.m_85841_(-1.0f, -1.0f, -1.0f);
        float pixelScale = 0.0625f;
        stack.m_85841_(0.0625f, 0.0625f, 0.0625f);
        if (computer.getVirtualMachine().isRunning()) {
            this.renderTerminal(computer, stack, bufferSource, cameraPosition);
        } else {
            this.renderStatusText(computer, stack, cameraPosition);
        }
        stack.m_252880_(0.0f, 0.0f, -0.1f);
        Matrix4f matrix = stack.m_85850_().m_252922_();
        block0 : switch (computer.getVirtualMachine().getBusState()) {
            case SCAN_PENDING: 
            case INCOMPLETE: {
                this.renderStatus(matrix, bufferSource);
                break;
            }
            case TOO_COMPLEX: {
                this.renderStatus(matrix, bufferSource, 1000);
                break;
            }
            case MULTIPLE_CONTROLLERS: {
                this.renderStatus(matrix, bufferSource, 250);
                break;
            }
            case READY: {
                switch (computer.getVirtualMachine().getRunState()) {
                    case STOPPED: {
                        break block0;
                    }
                    case LOADING_DEVICES: {
                        this.renderStatus(matrix, bufferSource);
                        break block0;
                    }
                    case RUNNING: {
                        this.renderPower(matrix, bufferSource);
                    }
                }
            }
        }
        stack.m_85849_();
    }

    private void renderTerminal(ComputerBlockEntity computer, PoseStack stack, MultiBufferSource bufferSource, Vec3 cameraPosition) {
        if (Vec3.m_82512_((Vec3i)computer.m_58899_()).m_82509_((Position)cameraPosition, 6.0)) {
            stack.m_85836_();
            stack.m_252880_(2.0f, 2.0f, -0.9f);
            Terminal terminal = computer.getTerminal();
            float textScaleX = 12.0f / (float)terminal.getWidth();
            float textScaleY = 7.0f / (float)terminal.getHeight();
            float scale = Math.min(textScaleX, textScaleY) * 0.95f;
            float scaleDeltaX = textScaleX - scale;
            float scaleDeltaY = textScaleY - scale;
            stack.m_252880_((float)terminal.getWidth() * scaleDeltaX * 0.5f, (float)terminal.getHeight() * scaleDeltaY * 0.5f, 0.0f);
            stack.m_85841_(scale, scale, 1.0f);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            try {
                ((Terminal.RendererView)rendererViews.get((Object)terminal, terminal::getRenderer)).render(stack, RenderSystem.getProjectionMatrix());
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            stack.m_85849_();
            RenderSystem.disableDepthTest();
        } else {
            stack.m_85836_();
            stack.m_252880_(0.0f, 0.0f, -0.9f);
            Matrix4f matrix = stack.m_85850_().m_252922_();
            ComputerRenderer.renderQuad(matrix, TEXTURE_TERMINAL.m_119194_(bufferSource, ModRenderType::getUnlitBlock));
            stack.m_85849_();
        }
    }

    private void renderStatusText(ComputerBlockEntity computer, PoseStack stack, Vec3 cameraPosition) {
        if (!Vec3.m_82512_((Vec3i)computer.m_58899_()).m_82509_((Position)cameraPosition, 12.0)) {
            return;
        }
        Component bootError = computer.getVirtualMachine().getError();
        if (bootError == null) {
            return;
        }
        stack.m_85836_();
        stack.m_252880_(3.0f, 3.0f, -0.9f);
        this.drawText(stack, bootError);
        stack.m_85849_();
    }

    private void drawText(PoseStack stack, Component text) {
        int maxWidth = 100;
        stack.m_85836_();
        stack.m_85841_(0.1f, 0.1f, 0.1f);
        Font fontRenderer = this.renderer.f_112253_;
        List wrappedText = fontRenderer.m_92865_().m_92414_((FormattedText)text, 100, Style.f_131099_);
        if (wrappedText.size() == 1) {
            int textWidth = fontRenderer.m_92852_((FormattedText)text);
            this.draw(fontRenderer, stack, text, (float)(100 - textWidth) * 0.5f);
        } else {
            for (int i = 0; i < wrappedText.size(); ++i) {
                String string = ((FormattedText)wrappedText.get(i)).getString();
                Objects.requireNonNull(fontRenderer);
                this.draw(fontRenderer, stack, string, (float)(i * 9));
            }
        }
        stack.m_85849_();
    }

    private void draw(Font font, PoseStack stack, Component text, float x) {
        MultiBufferSource.BufferSource batch = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        font.m_272077_(text, x, 0.0f, 0xEE3322, false, stack.m_85850_().m_252922_(), (MultiBufferSource)batch, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        batch.m_109911_();
    }

    private void draw(Font font, PoseStack stack, String text, float y) {
        MultiBufferSource.BufferSource batch = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        font.m_272078_(text, 0.0f, y, 0xEE3322, false, stack.m_85850_().m_252922_(), (MultiBufferSource)batch, Font.DisplayMode.NORMAL, 0, 0xF000F0, false);
        batch.m_109911_();
    }

    private void renderStatus(Matrix4f matrix, MultiBufferSource bufferSource) {
        this.renderStatus(matrix, bufferSource, 0);
    }

    private void renderStatus(Matrix4f matrix, MultiBufferSource bufferSource, int frequency) {
        if (frequency <= 0 || (System.currentTimeMillis() + (long)this.hashCode()) / (long)frequency % 2L == 1L) {
            ComputerRenderer.renderQuad(matrix, TEXTURE_STATUS.m_119194_(bufferSource, ModRenderType::getUnlitBlock));
        }
    }

    private void renderPower(Matrix4f matrix, MultiBufferSource bufferSource) {
        ComputerRenderer.renderQuad(matrix, TEXTURE_POWER.m_119194_(bufferSource, ModRenderType::getUnlitBlock));
    }

    private static void renderQuad(Matrix4f matrix, VertexConsumer consumer) {
        ChainableVertexConsumer wrapper = new ChainableVertexConsumer(consumer);
        wrapper.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        wrapper.m_252986_(matrix, 0.0f, 16.0f, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        wrapper.m_252986_(matrix, 16.0f, 16.0f, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        wrapper.m_252986_(matrix, 16.0f, 0.0f, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
    }

    @SubscribeEvent
    public static void updateCache(TickEvent.ClientTickEvent event) {
        rendererViews.cleanUp();
    }

    private static void handleNoLongerRendering(RemovalNotification<Terminal, Terminal.RendererView> notification) {
        Terminal key = (Terminal)notification.getKey();
        Terminal.RendererView value = (Terminal.RendererView)notification.getValue();
        if (key != null && value != null) {
            key.releaseRenderer(value);
        }
    }
}

