/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.blockentity;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.DeviceBusElement;
import li.cil.oc2.api.bus.device.Device;
import li.cil.oc2.api.bus.device.DeviceTypes;
import li.cil.oc2.api.bus.device.provider.ItemDeviceQuery;
import li.cil.oc2.api.capabilities.TerminalUserProvider;
import li.cil.oc2.client.audio.LoopingSoundManager;
import li.cil.oc2.common.block.ComputerBlock;
import li.cil.oc2.common.blockentity.BlockEntities;
import li.cil.oc2.common.blockentity.ModBlockEntity;
import li.cil.oc2.common.blockentity.TickableBlockEntity;
import li.cil.oc2.common.bus.AbstractBlockDeviceBusElement;
import li.cil.oc2.common.bus.BlockDeviceBusController;
import li.cil.oc2.common.bus.CommonDeviceBusController;
import li.cil.oc2.common.bus.device.util.Devices;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.config.Config;
import li.cil.oc2.common.container.ComputerInventoryContainer;
import li.cil.oc2.common.container.ComputerTerminalContainer;
import li.cil.oc2.common.energy.FixedEnergyStorage;
import li.cil.oc2.common.ext.ICaptureInputStateStorage;
import li.cil.oc2.common.network.Network;
import li.cil.oc2.common.network.message.ComputerBootErrorMessage;
import li.cil.oc2.common.network.message.ComputerBusStateMessage;
import li.cil.oc2.common.network.message.ComputerRunStateMessage;
import li.cil.oc2.common.network.message.ComputerTerminalOutputMessage;
import li.cil.oc2.common.serialization.NBTSerialization;
import li.cil.oc2.common.util.ChunkUtils;
import li.cil.oc2.common.util.HorizontalBlockUtils;
import li.cil.oc2.common.util.NBTUtils;
import li.cil.oc2.common.util.SoundEvents;
import li.cil.oc2.common.util.TerminalUtils;
import li.cil.oc2.common.util.TickUtils;
import li.cil.oc2.common.vm.AbstractTerminalVMRunner;
import li.cil.oc2.common.vm.AbstractVMItemStackHandlers;
import li.cil.oc2.common.vm.AbstractVirtualMachine;
import li.cil.oc2.common.vm.BaseAddressProvider;
import li.cil.oc2.common.vm.VMItemStackHandlers;
import li.cil.oc2.common.vm.VMRunState;
import li.cil.oc2.common.vm.VirtualMachine;
import li.cil.oc2.common.vm.terminal.Terminal;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public final class ComputerBlockEntity
extends ModBlockEntity
implements TerminalUserProvider,
TickableBlockEntity,
ICaptureInputStateStorage {
    private static final String BUS_ELEMENT_TAG_NAME = "busElement";
    private static final String DEVICES_TAG_NAME = "devices";
    private static final String TERMINAL_TAG_NAME = "terminal";
    private static final String STATE_TAG_NAME = "state";
    private static final String ENERGY_TAG_NAME = "energy";
    private static final int MEMORY_SLOTS = 4;
    private static final int HARD_DRIVE_SLOTS = 4;
    private static final int FLASH_MEMORY_SLOTS = 1;
    private static final int CARD_SLOTS = 4;
    private static final int CPU_SLOTS = 1;
    private static final int MAX_RUNNING_SOUND_DELAY = TickUtils.toTicks(Duration.ofSeconds(2L));
    private boolean hasAddedOwnDevices;
    private boolean isNeighborUpdateScheduled;
    private LevelChunk chunk;
    private final Terminal terminal = new Terminal();
    private final ComputerBusElement busElement = new ComputerBusElement();
    private final ComputerItemStackHandlers deviceItems = new ComputerItemStackHandlers();
    private final FixedEnergyStorage energy = new FixedEnergyStorage(Config.computerEnergyStorage);
    private final ComputerVirtualMachine virtualMachine = new ComputerVirtualMachine(new BlockDeviceBusController(this.busElement, Config.computerEnergyPerTick, this), this.deviceItems::getDeviceAddressBase);
    private final Set<Player> terminalUsers = Collections.newSetFromMap(new WeakHashMap());
    private boolean captureInputState;

    public ComputerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntities.COMPUTER.get(), pos, state);
        this.setNeedsLevelUnloadEvent();
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public VirtualMachine getVirtualMachine() {
        return this.virtualMachine;
    }

    public VMItemStackHandlers getItemStackHandlers() {
        return this.deviceItems;
    }

    @Override
    public boolean getCaptureInputState() {
        return this.captureInputState;
    }

    @Override
    public void setCaptureInputState(boolean value) {
        this.captureInputState = value;
    }

    public void start() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.virtualMachine.start();
        }
    }

    public void stop() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.virtualMachine.stop();
        }
    }

    public void openTerminalScreen(ServerPlayer player) {
        ComputerTerminalContainer.createServer(this, (IEnergyStorage)this.energy, this.virtualMachine.busController, player);
    }

    public void openInventoryScreen(ServerPlayer player) {
        ComputerInventoryContainer.createServer(this, (IEnergyStorage)this.energy, this.virtualMachine.busController, player);
    }

    public void addTerminalUser(Player player) {
        this.terminalUsers.add(player);
    }

    public void removeTerminalUser(Player player) {
        this.terminalUsers.remove(player);
    }

    @Override
    public Iterable<Player> getTerminalUsers() {
        return this.terminalUsers;
    }

    public void handleNeighborChanged() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.virtualMachine.busController.scheduleBusScan();
        }
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
        if (!this.isValid()) {
            return LazyOptional.empty();
        }
        LazyOptional<T> optional = super.getCapability(capability, side);
        if (optional.isPresent()) {
            return optional;
        }
        Direction localSide = HorizontalBlockUtils.toLocal(this.m_58900_(), side);
        for (Device device : this.virtualMachine.busController.getDevices()) {
            ICapabilityProvider capabilityProvider;
            LazyOptional value;
            if (!(device instanceof ICapabilityProvider) || !(value = (capabilityProvider = (ICapabilityProvider)device).getCapability(capability, localSide)).isPresent()) continue;
            return value;
        }
        return LazyOptional.empty();
    }

    @Override
    public void clientTick() {
        this.terminal.clientTick();
    }

    @Override
    public void serverTick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.hasAddedOwnDevices) {
            this.hasAddedOwnDevices = true;
            this.busElement.addOwnDevices();
        }
        if (this.isNeighborUpdateScheduled) {
            this.isNeighborUpdateScheduled = false;
            this.f_58857_.m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
        }
        this.chunk = this.f_58857_.m_46745_(this.m_58899_());
        this.virtualMachine.tick();
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128365_(TERMINAL_TAG_NAME, (Tag)NBTSerialization.serialize(this.terminal));
        tag.m_128405_("busState", this.virtualMachine.getBusState().ordinal());
        tag.m_128405_("runState", this.virtualMachine.getRunState().ordinal());
        tag.m_128359_("bootError", Component.Serializer.m_130703_((Component)this.virtualMachine.getBootError()));
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        NBTSerialization.deserialize(tag.m_128469_(TERMINAL_TAG_NAME), this.terminal);
        this.virtualMachine.setBusStateClient(CommonDeviceBusController.BusState.values()[tag.m_128451_("busState")]);
        this.virtualMachine.setRunStateClient(VMRunState.values()[tag.m_128451_("runState")]);
        this.virtualMachine.setBootErrorClient((Component)Component.Serializer.m_130701_((String)tag.m_128461_("bootError")));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.virtualMachine.getRunState() != VMRunState.STOPPED) {
            tag.m_128365_(STATE_TAG_NAME, (Tag)this.virtualMachine.serialize());
            tag.m_128365_(TERMINAL_TAG_NAME, (Tag)NBTSerialization.serialize(this.terminal));
        }
        tag.m_128365_(ENERGY_TAG_NAME, (Tag)this.energy.serializeNBT());
        tag.m_128365_(BUS_ELEMENT_TAG_NAME, (Tag)this.busElement.save());
        tag.m_128365_("items", (Tag)this.deviceItems.saveItems());
        tag.m_128365_(DEVICES_TAG_NAME, (Tag)this.deviceItems.saveDevices());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.energy.deserializeNBT((Tag)tag.m_128469_(ENERGY_TAG_NAME));
        this.busElement.load(tag.m_128469_(BUS_ELEMENT_TAG_NAME));
        this.deviceItems.loadItems(tag.m_128469_("items"));
        this.deviceItems.loadDevices(tag.m_128469_(DEVICES_TAG_NAME));
        this.virtualMachine.deserialize(tag.m_128469_(STATE_TAG_NAME));
        NBTSerialization.deserialize(tag.m_128469_(TERMINAL_TAG_NAME), this.terminal);
    }

    public void exportToItemStack(ItemStack stack) {
        this.deviceItems.saveItems(NBTUtils.getOrCreateChildTag(stack.m_41784_(), "BlockEntityTag", "items"));
    }

    @Override
    protected void collectCapabilities(ModBlockEntity.CapabilityCollector collector, @Nullable Direction direction) {
        collector.offer(Capabilities.itemHandler(), this.deviceItems.combinedItemHandlers);
        collector.offer(Capabilities.deviceBusElement(), this.busElement);
        collector.offer(Capabilities.terminalUserProvider(), this);
        if (Config.computersUseEnergy()) {
            collector.offer(Capabilities.energyStorage(), this.energy);
        }
    }

    @Override
    protected void loadClient() {
        super.loadClient();
        this.terminal.setDisplayOnly(true);
    }

    @Override
    protected void loadServer() {
        super.loadServer();
        assert (this.f_58857_ != null);
        this.virtualMachine.state.builtinDevices.rtcMinecraft.setLevel(this.f_58857_);
    }

    @Override
    protected void unloadServer(boolean isRemove) {
        super.unloadServer(isRemove);
        if (isRemove) {
            this.virtualMachine.stop();
        } else {
            this.virtualMachine.suspend();
        }
        this.virtualMachine.dispose();
        this.busElement.scheduleScan();
    }

    private <T> void sendToClientsTrackingComputer(T message) {
        if (this.chunk != null) {
            Network.sendToClientsTrackingChunk(message, this.chunk);
        }
    }

    private final class ComputerBusElement
    extends AbstractBlockDeviceBusElement {
        private static final String DEVICE_ID_TAG_NAME = "device_id";
        private final HashSet<Device> devices = new HashSet();
        private UUID deviceId = UUID.randomUUID();

        private ComputerBusElement() {
        }

        @Override
        @Nullable
        public LevelAccessor getLevel() {
            return ComputerBlockEntity.this.m_58904_();
        }

        @Override
        public BlockPos getPosition() {
            return ComputerBlockEntity.this.m_58899_();
        }

        public void addOwnDevices() {
            assert (ComputerBlockEntity.this.f_58857_ != null);
            this.collectDevices((LevelAccessor)ComputerBlockEntity.this.f_58857_, this.getPosition(), null).ifPresent(result -> {
                for (AbstractBlockDeviceBusElement.BlockEntry info : result.getEntries()) {
                    this.devices.add(info.getDevice());
                    super.addDevice(info.getDevice());
                }
            });
        }

        @Override
        public Optional<Collection<LazyOptional<DeviceBusElement>>> getNeighbors() {
            return super.getNeighbors().map(neighbors -> {
                ArrayList<LazyOptional> list = new ArrayList<LazyOptional>((Collection<LazyOptional>)neighbors);
                list.add(LazyOptional.of(() -> ComputerBlockEntity.this.deviceItems.busElement));
                return list;
            });
        }

        @Override
        public boolean canScanContinueTowards(@Nullable Direction direction) {
            return ComputerBlockEntity.this.m_58900_().m_61143_((Property)ComputerBlock.f_54117_) != direction;
        }

        @Override
        protected boolean canDetectDevicesTowards(@Nullable Direction direction) {
            return direction == null;
        }

        @Override
        public Optional<UUID> getDeviceIdentifier(Device device) {
            if (this.devices.contains(device)) {
                return Optional.of(this.deviceId);
            }
            return super.getDeviceIdentifier(device);
        }

        @Override
        public CompoundTag save() {
            CompoundTag tag = super.save();
            tag.m_128362_(DEVICE_ID_TAG_NAME, this.deviceId);
            return tag;
        }

        @Override
        public void load(CompoundTag tag) {
            super.load(tag);
            if (tag.m_128403_(DEVICE_ID_TAG_NAME)) {
                this.deviceId = tag.m_128342_(DEVICE_ID_TAG_NAME);
            }
        }
    }

    private final class ComputerItemStackHandlers
    extends AbstractVMItemStackHandlers {
        public ComputerItemStackHandlers() {
            super(new AbstractVMItemStackHandlers.GroupDefinition(DeviceTypes.MEMORY, 4), new AbstractVMItemStackHandlers.GroupDefinition(DeviceTypes.HARD_DRIVE, 4), new AbstractVMItemStackHandlers.GroupDefinition(DeviceTypes.FLASH_MEMORY, 1), new AbstractVMItemStackHandlers.GroupDefinition(DeviceTypes.CARD, 4), new AbstractVMItemStackHandlers.GroupDefinition(DeviceTypes.CPU, 1));
        }

        @Override
        protected ItemDeviceQuery makeQuery(ItemStack stack) {
            return Devices.makeQuery((BlockEntity)ComputerBlockEntity.this, stack);
        }

        @Override
        protected void onChanged() {
            super.onChanged();
            if (ComputerBlockEntity.this.f_58857_ != null && !ComputerBlockEntity.this.f_58857_.m_5776_()) {
                ComputerBlockEntity.this.virtualMachine.busController.scheduleBusScan();
                ChunkUtils.setLazyUnsaved((LevelAccessor)ComputerBlockEntity.this.f_58857_, ComputerBlockEntity.this.m_58899_());
            }
            ComputerBlockEntity.this.isNeighborUpdateScheduled = true;
        }
    }

    private final class ComputerVirtualMachine
    extends AbstractVirtualMachine {
        private ComputerVirtualMachine(CommonDeviceBusController busController, BaseAddressProvider baseAddressProvider) {
            super(busController);
            this.state.vmAdapter.setBaseAddressProvider(baseAddressProvider);
        }

        @Override
        public void setRunStateClient(VMRunState value) {
            super.setRunStateClient(value);
            if (value == VMRunState.RUNNING) {
                if (!LoopingSoundManager.isPlaying(ComputerBlockEntity.this) && ComputerBlockEntity.this.f_58857_ != null) {
                    LoopingSoundManager.play(ComputerBlockEntity.this, (SoundEvent)SoundEvents.COMPUTER_RUNNING.get(), ComputerBlockEntity.this.f_58857_.m_213780_().m_188503_(MAX_RUNNING_SOUND_DELAY));
                }
            } else {
                LoopingSoundManager.stop(ComputerBlockEntity.this);
            }
        }

        @Override
        public void tick() {
            assert (ComputerBlockEntity.this.f_58857_ != null);
            if (this.isRunning()) {
                ChunkUtils.setLazyUnsaved((LevelAccessor)ComputerBlockEntity.this.f_58857_, ComputerBlockEntity.this.m_58899_());
                this.busController.setDeviceContainersChanged();
            }
            super.tick();
        }

        @Override
        protected boolean consumeEnergy(int amount, boolean simulate) {
            if (!Config.computersUseEnergy()) {
                return true;
            }
            if (amount > ComputerBlockEntity.this.energy.getEnergyStored()) {
                return false;
            }
            ComputerBlockEntity.this.energy.extractEnergy(amount, simulate);
            return true;
        }

        @Override
        protected void stopRunnerAndReset() {
            super.stopRunnerAndReset();
            TerminalUtils.resetTerminal(ComputerBlockEntity.this.terminal, output -> ComputerBlockEntity.this.sendToClientsTrackingComputer(new ComputerTerminalOutputMessage(ComputerBlockEntity.this, (ByteBuffer)output)));
        }

        @Override
        protected AbstractTerminalVMRunner createRunner() {
            return new ComputerVMRunner(this, ComputerBlockEntity.this.terminal);
        }

        @Override
        protected void handleBusStateChanged(CommonDeviceBusController.BusState value) {
            ComputerBlockEntity.this.sendToClientsTrackingComputer(new ComputerBusStateMessage(ComputerBlockEntity.this, value));
            if (value == CommonDeviceBusController.BusState.READY && ComputerBlockEntity.this.f_58857_ != null) {
                ComputerBlockEntity.this.f_58857_.m_46672_(ComputerBlockEntity.this.m_58899_(), ComputerBlockEntity.this.m_58900_().m_60734_());
            }
        }

        @Override
        protected void handleRunStateChanged(VMRunState value) {
            ComputerBlockEntity.this.sendToClientsTrackingComputer(new ComputerRunStateMessage(ComputerBlockEntity.this, value));
        }

        @Override
        protected void handleBootErrorChanged(@Nullable Component value) {
            ComputerBlockEntity.this.sendToClientsTrackingComputer(new ComputerBootErrorMessage(ComputerBlockEntity.this, value));
        }
    }

    private final class ComputerVMRunner
    extends AbstractTerminalVMRunner {
        public ComputerVMRunner(AbstractVirtualMachine virtualMachine, Terminal terminal) {
            super(virtualMachine, terminal);
        }

        @Override
        protected void sendTerminalUpdateToClient(ByteBuffer output) {
            ComputerBlockEntity.this.sendToClientsTrackingComputer(new ComputerTerminalOutputMessage(ComputerBlockEntity.this, output));
        }
    }
}

