/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.rpc.item;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.object.Callback;
import li.cil.oc2.api.bus.device.object.Parameter;
import li.cil.oc2.common.bus.device.rpc.item.AbstractItemRPCDevice;
import li.cil.oc2.common.config.Config;
import li.cil.oc2.common.util.BlockLocation;
import li.cil.oc2.common.util.TickUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public final class SoundCardItemDevice
extends AbstractItemRPCDevice {
    private final int COOLDOWN_IN_TICKS = TickUtils.toTicks(Duration.ofSeconds(Config.soundCardCoolDownSeconds));
    private static final int MAX_FIND_RESULTS = 25;
    private final Supplier<Optional<BlockLocation>> location;
    private long gameTimeCooldownExpiresAt;

    public SoundCardItemDevice(ItemStack identity, Supplier<Optional<BlockLocation>> location) {
        super(identity, "sound");
        this.location = location;
    }

    @Callback
    public void playSound(@Nullable @Parameter(value="name") String name) {
        this.playSound(name, 1.0f, 1.0f);
    }

    @Callback
    public void playSound(@Nullable @Parameter(value="name") String name, @Parameter(value="volume") float volume) {
        this.playSound(name, volume, 1.0f);
    }

    @Callback
    public void playSound(@Nullable @Parameter(value="name") String name, @Parameter(value="volume") float volume, @Parameter(value="pitch") float pitch) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (volume < 0.0f || volume > 1.0f) {
            throw new IllegalArgumentException("volume must be between >= 0 and <= 1");
        }
        if (pitch < 0.5f || pitch > 2.0f) {
            throw new IllegalArgumentException("pitch must be between >= 0.5 and <= 2");
        }
        if (volume == 0.0f) {
            return;
        }
        this.location.get().ifPresent(location -> location.tryGetLevel().ifPresent(level -> {
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            long gameTime = serverLevel.m_46467_();
            if (gameTime < this.gameTimeCooldownExpiresAt) {
                return;
            }
            this.gameTimeCooldownExpiresAt = gameTime + (long)this.COOLDOWN_IN_TICKS;
            SoundEvent soundEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)name));
            if (soundEvent == null) {
                throw new IllegalArgumentException("Sound not found.");
            }
            level.m_5594_(null, location.blockPos(), soundEvent, SoundSource.BLOCKS, volume, pitch);
        }));
    }

    @Callback
    public List<String> findSound(@Nullable @Parameter(value="name") String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> matches = new ArrayList<String>();
        for (ResourceLocation key : ForgeRegistries.SOUND_EVENTS.getKeys()) {
            String keyName = key.toString();
            if (!keyName.contains(name)) continue;
            matches.add(keyName);
            if (matches.size() < 25) continue;
            break;
        }
        return matches;
    }
}

