/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.inet;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.RegEx;
import li.cil.oc2.common.inet.InetUtils;
import li.cil.oc2.common.util.IntegerSpace;

public final class Ipv4Space
extends IntegerSpace {
    private static final String IPADDRESS_PATTERN = "(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)){3}";
    public static final Pattern ipAddressPattern = Ipv4Space.line(Ipv4Space.group("ip", "(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)){3}"));
    private static final Pattern ipRangePattern = Ipv4Space.line(Ipv4Space.group("start", "(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)){3}") + "-" + Ipv4Space.group("end", "(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)){3}"));
    private static final Pattern subnetPattern = Ipv4Space.line(Ipv4Space.group("ip", "(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)){3}") + "\\/" + Ipv4Space.group("prefix", "[1-9]\\d?"));
    private static final Pattern interfaceNamePattern = Ipv4Space.line("@" + Ipv4Space.group("name", "[a-zA-Z].*"));
    private static final Pattern interfaceIdPattern = Ipv4Space.line("@" + Ipv4Space.group("id", "\\d*"));
    private final boolean isAllowListMode;

    public Ipv4Space(Modes mode) {
        this.isAllowListMode = mode == Modes.ALLOWLIST;
    }

    private static Pattern line(@RegEx String pattern) {
        return Pattern.compile("^" + pattern + "$");
    }

    private static String group(String name, @RegEx String pattern) {
        return "(?<" + name + ">" + pattern + ")";
    }

    @Override
    protected void elementToString(StringBuilder builder, int element) {
        InetUtils.ipv4AddressToString(builder, element);
    }

    private boolean putSubnet(int ipAddress, int prefix) {
        int subnet = InetUtils.getSubnetByPrefix(prefix);
        int rangeStart = ipAddress & subnet;
        int rangeEnd = ipAddress | ~subnet;
        return this.put(rangeStart, rangeEnd);
    }

    private boolean putNetworkInterface(@Nullable NetworkInterface networkInterface) {
        if (networkInterface == null) {
            throw new IllegalArgumentException("Network interface not found");
        }
        boolean result = false;
        for (InterfaceAddress address : networkInterface.getInterfaceAddresses()) {
            InetAddress inetAddress = address.getAddress();
            if (!(inetAddress instanceof Inet4Address)) continue;
            int ipAddress = InetUtils.javaInetAddressToIpAddress((Inet4Address)inetAddress);
            result = this.putSubnet(ipAddress, address.getNetworkPrefixLength()) || result;
        }
        return result;
    }

    public boolean put(String string) {
        Matcher ipAddressMatch = ipAddressPattern.matcher(string);
        if (ipAddressMatch.matches()) {
            int ipAddress = InetUtils.surelyParseValidIpv4Address(ipAddressMatch.group("ip"));
            return this.put(ipAddress);
        }
        Matcher ipRangeMatch = ipRangePattern.matcher(string);
        if (ipRangeMatch.matches()) {
            int rangeStart = InetUtils.surelyParseValidIpv4Address(ipRangeMatch.group("start"));
            int rangeEnd = InetUtils.surelyParseValidIpv4Address(ipRangeMatch.group("end"));
            return this.put(rangeStart, rangeEnd);
        }
        Matcher subnetMatch = subnetPattern.matcher(string);
        if (subnetMatch.matches()) {
            int ipAddress = InetUtils.surelyParseValidIpv4Address(subnetMatch.group("ip"));
            int prefix = Integer.parseInt(subnetMatch.group("prefix"));
            return this.putSubnet(ipAddress, prefix);
        }
        Matcher interfaceNameMatch = interfaceNamePattern.matcher(string);
        if (interfaceNameMatch.matches()) {
            String interfaceName = interfaceNameMatch.group("name");
            try {
                NetworkInterface networkInterface = NetworkInterface.getByName(interfaceName);
                return this.putNetworkInterface(networkInterface);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to get a network interface by name");
            }
        }
        Matcher interfaceIdMatch = interfaceIdPattern.matcher(string);
        if (interfaceIdMatch.matches()) {
            int interfaceId = Integer.parseInt(interfaceIdMatch.group("id"));
            try {
                NetworkInterface networkInterface = NetworkInterface.getByIndex(interfaceId);
                return this.putNetworkInterface(networkInterface);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to get a network interface by index");
            }
        }
        try {
            InetAddress[] addresses = InetAddress.getAllByName(string);
            boolean result = false;
            for (InetAddress address : addresses) {
                if (!(address instanceof Inet4Address)) continue;
                int ipAddress = InetUtils.javaInetAddressToIpAddress((Inet4Address)address);
                result = this.put(ipAddress) || result;
            }
            return result;
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public boolean isAllowed(int ipAddress) {
        return this.isAllowListMode == this.contains(ipAddress);
    }

    public static enum Modes {
        ALLOWLIST,
        DENYLIST;

    }
}

