/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.inet;

import java.io.IOException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import li.cil.oc2.api.inet.InternetManager;
import li.cil.oc2.api.inet.session.DatagramSession;
import li.cil.oc2.api.inet.session.Session;
import li.cil.oc2.api.inet.session.StreamSession;
import li.cil.oc2.common.inet.ReadySessions;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SocketManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static int socketManagerUsesCount = 0;
    private static SocketManager socketManager = null;
    private final Selector selector;
    private final InternetManager.Task selectionTask;

    public static SocketManager attach(InternetManager internetManager) {
        if (socketManagerUsesCount++ == 0) {
            assert (socketManager == null);
            socketManager = new SocketManager(internetManager);
        }
        assert (socketManager != null);
        return socketManager;
    }

    private void selectionTaskFunction() {
        try {
            this.selector.selectNow(selectionKey -> {
                ChannelAttachment attachment = (ChannelAttachment)selectionKey.attachment();
                Session session = attachment.session;
                ReadySessions readySessions = attachment.readySessions;
                if (selectionKey.isReadable()) {
                    readySessions.getToRead().add(session);
                }
                if (selectionKey.isWritable()) {
                    readySessions.getToWrite().add(session);
                }
                if (selectionKey.isConnectable()) {
                    readySessions.getToConnect().add(session);
                }
            });
        }
        catch (IOException exception) {
            LOGGER.error("Exception while selecting", (Throwable)exception);
        }
    }

    private SocketManager(InternetManager internetManager) {
        try {
            this.selector = Selector.open();
        }
        catch (IOException exception) {
            throw new Error("Failed to open selector", exception);
        }
        this.selectionTask = internetManager.runOnInternetThreadTick(this::selectionTaskFunction);
        LOGGER.info("Started socket manager");
    }

    public DatagramChannel createDatagramChannel(DatagramSession session, ReadySessions readySessions) throws IOException {
        DatagramChannel datagramChannel = DatagramChannel.open();
        datagramChannel.configureBlocking(false);
        ChannelAttachment attachment = new ChannelAttachment(session, readySessions);
        int ops = 5;
        datagramChannel.register(this.selector, 5, attachment);
        return datagramChannel;
    }

    public SocketChannel createStreamChannel(StreamSession session, ReadySessions readySessions) throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(false);
        ChannelAttachment attachment = new ChannelAttachment(session, readySessions);
        int ops = 13;
        socketChannel.register(this.selector, 13, attachment);
        return socketChannel;
    }

    private void shutdown() {
        this.selectionTask.close();
        try {
            this.selector.close();
        }
        catch (IOException exception) {
            LOGGER.error("Exception during socket manager shutdown", (Throwable)exception);
        }
        LOGGER.info("Stopped socket manager");
    }

    public void detach() {
        if (--socketManagerUsesCount == 0) {
            this.shutdown();
            socketManager = null;
        }
    }

    private record ChannelAttachment(Session session, ReadySessions readySessions) {
    }
}

