/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.inet;

import java.nio.ByteBuffer;

public class TcpHeader {
    public static final int MIN_HEADER_SIZE_NO_PORTS = 16;
    private static final byte OPTION_END = 0;
    private static final byte OPTION_NOOP = 1;
    private static final byte OPTION_MAX_SEGMENT_SIZE = 2;
    public int sequenceNumber;
    public int acknowledgmentNumber;
    public boolean urg;
    public boolean ack;
    public boolean psh;
    public boolean rst;
    public boolean syn;
    public boolean fin;
    public int window;
    public int urgentPointer;
    public int maxSegmentSize;

    public boolean read(ByteBuffer data) {
        if (data.remaining() < 16) {
            return false;
        }
        int position = data.position();
        this.sequenceNumber = data.getInt();
        this.acknowledgmentNumber = data.getInt();
        int dataOffset = position + (data.get() >>> 2 & 0x3C) - 4;
        if (dataOffset > data.limit()) {
            return false;
        }
        int flags = Byte.toUnsignedInt(data.get());
        this.urg = (flags >>> 5 & 1) == 1;
        this.ack = (flags >>> 4 & 1) == 1;
        this.psh = (flags >>> 3 & 1) == 1;
        this.rst = (flags >>> 2 & 1) == 1;
        this.syn = (flags >>> 1 & 1) == 1;
        this.fin = (flags & 1) == 1;
        this.window = Short.toUnsignedInt(data.getShort());
        data.getShort();
        this.urgentPointer = Short.toUnsignedInt(data.getShort());
        this.maxSegmentSize = -1;
        block4: while (dataOffset > data.position()) {
            byte type = data.get();
            switch (type) {
                case 0: {
                    data.position(dataOffset);
                    return true;
                }
                case 1: {
                    continue block4;
                }
            }
            int size = Byte.toUnsignedInt(data.get());
            if (type == 2) {
                if (size != 4) {
                    data.position(position);
                    return false;
                }
                this.maxSegmentSize = Short.toUnsignedInt(data.getShort());
                continue;
            }
            data.position(data.position() + size - 2);
        }
        data.position(dataOffset);
        return true;
    }

    private int bool2int(boolean value) {
        return value ? 1 : 0;
    }

    public void write(ByteBuffer data) {
        data.putInt(this.sequenceNumber);
        data.putInt(this.acknowledgmentNumber);
        int headerLength = 20 + (this.maxSegmentSize == -1 ? 0 : 4);
        data.put((byte)(headerLength << 2));
        int flags = this.bool2int(this.urg) << 5 | this.bool2int(this.ack) << 4 | this.bool2int(this.psh) << 3 | this.bool2int(this.rst) << 2 | this.bool2int(this.syn) << 1 | this.bool2int(this.fin);
        data.put((byte)flags);
        data.putShort((short)this.window);
        data.putShort((short)0);
        data.putShort((short)this.urgentPointer);
        if (this.maxSegmentSize != -1) {
            data.put((byte)2);
            data.put((byte)4);
            data.putShort((short)this.maxSegmentSize);
        }
    }

    public boolean isConnectionInitiation() {
        return this.syn && !this.urg && !this.ack && !this.psh && !this.rst && !this.fin;
    }

    public void acceptConnection(int sequence, int acknowledgment, int window) {
        this.sequenceNumber = sequence;
        this.acknowledgmentNumber = acknowledgment;
        this.urg = false;
        this.ack = true;
        this.psh = false;
        this.rst = false;
        this.syn = true;
        this.fin = false;
        this.window = window;
        this.urgentPointer = 0;
        this.maxSegmentSize = -1;
    }

    public boolean isAcceptanceOrRejectionAcknowledged() {
        return !this.syn && !this.urg && this.ack && !this.psh && !this.rst && !this.fin;
    }

    public void rejectConnection(int sequence, int acknowledgment) {
        this.sequenceNumber = sequence;
        this.acknowledgmentNumber = acknowledgment;
        this.urg = false;
        this.ack = true;
        this.psh = false;
        this.rst = true;
        this.syn = false;
        this.fin = false;
        this.window = 0;
        this.urgentPointer = 0;
        this.maxSegmentSize = -1;
    }

    public String toString() {
        return "TcpHeader{sequenceNumber=" + this.sequenceNumber + ", acknowledgmentNumber=" + this.acknowledgmentNumber + ", urg=" + this.urg + ", ack=" + this.ack + ", psh=" + this.psh + ", rst=" + this.rst + ", syn=" + this.syn + ", fin=" + this.fin + ", window=" + this.window + ", urgentPointer=" + this.urgentPointer + ", maxSegmentSize=" + this.maxSegmentSize + "}";
    }
}

