/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.item;

import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.data.BlockDeviceData;
import li.cil.oc2.common.bus.device.data.BlockDeviceDataRegistry;
import li.cil.oc2.common.item.ModItem;
import li.cil.oc2.common.util.ItemStackUtils;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public abstract class AbstractBlockDeviceItem
extends ModItem {
    public static final String DATA_TAG_NAME = "data";
    private final ResourceLocation defaultData;

    protected AbstractBlockDeviceItem(Item.Properties properties, ResourceLocation defaultData) {
        super(properties.m_41487_(1));
        this.defaultData = defaultData;
    }

    protected AbstractBlockDeviceItem(ResourceLocation defaultData) {
        this(AbstractBlockDeviceItem.createProperties(), defaultData);
    }

    @Nullable
    public BlockDeviceData getData(ItemStack stack) {
        if (stack.m_41619_() || stack.m_41720_() != this) {
            return null;
        }
        String registryName = ItemStackUtils.getModDataTag(stack).m_128461_(DATA_TAG_NAME);
        ResourceLocation location = this.defaultData;
        if (!StringUtil.m_14408_((String)registryName)) {
            try {
                location = ResourceLocation.parse((String)registryName);
            }
            catch (ResourceLocationException resourceLocationException) {
                // empty catch block
            }
        }
        return BlockDeviceDataRegistry.getValue(location);
    }

    public ItemStack withData(ItemStack stack, BlockDeviceData data) {
        if (stack.m_41619_() || stack.m_41720_() != this) {
            return ItemStack.f_41583_;
        }
        ResourceLocation key = BlockDeviceDataRegistry.getKey(data);
        if (key == null) {
            return ItemStack.f_41583_;
        }
        ItemStackUtils.getOrCreateModDataTag(stack).m_128359_(DATA_TAG_NAME, key.toString());
        return stack;
    }

    public ItemStack withData(BlockDeviceData data) {
        return this.withData(new ItemStack((ItemLike)this), data);
    }

    public Component m_7626_(ItemStack stack) {
        BlockDeviceData data = this.getData(stack);
        if (data != null) {
            return Component.m_237113_((String)"").m_7220_(super.m_7626_(stack)).m_130946_(" (").m_7220_(data.getDisplayName()).m_130946_(")");
        }
        return super.m_7626_(stack);
    }

    protected ResourceLocation getDefaultData() {
        return this.defaultData;
    }
}

