/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.serialization.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import li.cil.oc2.api.bus.device.rpc.RPCMethod;
import li.cil.oc2.api.bus.device.rpc.RPCParameter;

public final class RPCMethodJsonSerializer
implements JsonSerializer<RPCMethod> {
    public JsonElement serialize(RPCMethod method, Type typeOfMethod, JsonSerializationContext context) {
        RPCParameter[] parameters;
        JsonObject methodJson = new JsonObject();
        methodJson.addProperty("name", method.getName());
        methodJson.addProperty("returnType", method.getReturnType().getSimpleName());
        method.getDescription().ifPresent(s -> methodJson.addProperty("description", s));
        method.getReturnValueDescription().ifPresent(s -> methodJson.addProperty("returnValueDescription", s));
        JsonArray parametersJson = new JsonArray();
        methodJson.add("parameters", (JsonElement)parametersJson);
        for (RPCParameter parameter : parameters = method.getParameters()) {
            JsonObject parameterJson = new JsonObject();
            parameter.getName().ifPresent(s -> parameterJson.addProperty("name", s));
            parameter.getDescription().ifPresent(s -> parameterJson.addProperty("description", s));
            Class<?> type = parameter.getType();
            parameterJson.addProperty("type", type.getSimpleName());
            parametersJson.add((JsonElement)parameterJson);
        }
        return methodJson;
    }
}

