/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.vm.terminal.escapes.csi;

import java.util.Arrays;
import li.cil.oc2.common.vm.terminal.Terminal;
import li.cil.oc2.common.vm.terminal.escapes.csi.CSISequenceHandler;
import li.cil.oc2.common.vm.terminal.escapes.csi.CSIState;

public class ECH
extends CSISequenceHandler {
    public ECH(Terminal terminal) {
        super(terminal);
    }

    @Override
    public void execute(int[] args, int argCount, CSIState state) {
        int chars = args[0];
        Terminal.ColorData c = switch (this.terminal.currentBackgroundColorMode) {
            case Terminal.ColorMode.SIXTEEN_COLOR -> this.terminal.sixteenColor;
            case Terminal.ColorMode.TWO_FIFTY_SIX_COLOR -> this.terminal.twoFiftySixColor;
            case Terminal.ColorMode.TRUE_COLOR -> this.terminal.backgroundColor;
            case Terminal.ColorMode.SIXTEEN_COLOR_BRIGHT -> this.terminal.sixteenColorBright;
            default -> Terminal.DEFAULT_BACKGROUND_COLOR;
        };
        if (this.terminal.currentPrivateModeState.isAltBufferEnabled()) {
            int fromIndex = this.terminal.x + this.terminal.y * 80;
            int toIndex = fromIndex + Math.max(Math.min(Math.max(chars, 1), 80 - this.terminal.x), 1);
            Arrays.fill(this.terminal.altBuffer, fromIndex, toIndex, 32);
            Arrays.fill(this.terminal.altColors, fromIndex, toIndex, Terminal.DEFAULT_COLORS.Copy());
            Arrays.fill(this.terminal.altColorsBackground, fromIndex, toIndex, c.Copy());
            Arrays.fill(this.terminal.altStyles, fromIndex, toIndex, (byte)0);
        } else {
            int fromIndex = this.terminal.x + (this.terminal.y + (this.terminal.lastRowToDisplayMax - 24)) * 80;
            int toIndex = fromIndex + Math.max(Math.min(Math.max(chars, 1), 80 - this.terminal.x), 1);
            Arrays.fill(this.terminal.buffer, fromIndex, toIndex, 32);
            Arrays.fill(this.terminal.colors, fromIndex, toIndex, Terminal.DEFAULT_COLORS.Copy());
            Arrays.fill(this.terminal.colorsBackground, fromIndex, toIndex, c.Copy());
            Arrays.fill(this.terminal.styles, fromIndex, toIndex, (byte)0);
        }
        this.terminal.renderers.forEach(model -> model.getDirtyMask().accumulateAndGet(1 << this.terminal.y, (left, right) -> left | right));
    }
}

