/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.jcodec.codecs.h264.decode;

import li.cil.oc2.jcodec.codecs.h264.H264Utils;
import li.cil.oc2.jcodec.codecs.h264.io.model.Frame;
import li.cil.oc2.jcodec.codecs.h264.io.model.MBType;
import li.cil.oc2.jcodec.codecs.h264.io.model.SeqParameterSet;
import li.cil.oc2.jcodec.codecs.h264.io.model.SliceHeader;

public final class DeblockerInput {
    public final int[][] nCoeff;
    public final H264Utils.MvList2D mvs;
    public final MBType[] mbTypes;
    public final int[][] mbQps;
    public final boolean[] tr8x8Used;
    public final Frame[][][] refsUsed;
    public final SliceHeader[] shs;

    public DeblockerInput(SeqParameterSet activeSps) {
        int picWidthInMbs = activeSps.picWidthInMbsMinus1 + 1;
        int picHeightInMbs = SeqParameterSet.getPicHeightInMbs(activeSps);
        this.nCoeff = new int[picHeightInMbs << 2][picWidthInMbs << 2];
        this.mvs = new H264Utils.MvList2D(picWidthInMbs << 2, picHeightInMbs << 2);
        this.mbTypes = new MBType[picHeightInMbs * picWidthInMbs];
        this.tr8x8Used = new boolean[picHeightInMbs * picWidthInMbs];
        this.mbQps = new int[3][picHeightInMbs * picWidthInMbs];
        this.shs = new SliceHeader[picHeightInMbs * picWidthInMbs];
        this.refsUsed = new Frame[picHeightInMbs * picWidthInMbs][][];
    }
}

