/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.block.tile;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.common.CyberwareConfig;
import flaxbeard.cyberware.common.item.ItemBlueprint;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityScanner
extends TileEntity
implements ITickable {
    public ItemStackHandlerScanner slots = new ItemStackHandlerScanner(this, 3);
    private final RangedWrapper slotsTopSides = new RangedWrapper((IItemHandlerModifiable)this.slots, 0, 2);
    private final RangedWrapper slotsBottom = new RangedWrapper((IItemHandlerModifiable)this.slots, 2, 3);
    private final RangedWrapper slotsBottom2 = new RangedWrapper((IItemHandlerModifiable)this.slots, 0, 1);
    public final GuiWrapper guiSlots = new GuiWrapper(this.slots);
    public String customName = null;
    public int ticks = 0;
    public int ticksMove = 0;
    public int lastX = 0;
    public int x = 0;
    public int lastZ = 0;
    public int z = 0;

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                if (this.slots.getStackInSlot(2) != null && this.slots.getStackInSlot(0) != null) {
                    return (T)this.slotsBottom2;
                }
                return (T)this.slotsBottom;
            }
            return (T)this.slotsTopSides;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.slots.deserializeNBT(compound.func_74775_l("inv"));
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
        this.ticks = compound.func_74762_e("ticks");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74782_a("inv", (NBTBase)this.slots.serializeNBT());
        if (this.hasCustomName()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        compound.func_74768_a("ticks", this.ticks);
        return compound;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound data = pkt.func_148857_g();
        this.func_145839_a(data);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound data = new NBTTagCompound();
        this.func_189515_b(data);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, data);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public String getName() {
        return this.hasCustomName() ? this.customName : "cyberware.container.scanner";
    }

    public boolean hasCustomName() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomInventoryName(String p_145951_1_) {
        this.customName = p_145951_1_;
    }

    public ITextComponent getDisplayName() {
        return this.hasCustomName() ? new TextComponentString(this.getName()) : new TextComponentTranslation(this.getName(), new Object[0]);
    }

    public void func_73660_a() {
        ItemStack toDestroy = this.slots.getStackInSlot(0);
        if (CyberwareAPI.canDeconstruct(toDestroy) && toDestroy.field_77994_a > 0 && (this.slots.getStackInSlot(2) == null || this.slots.getStackInSlot((int)2).field_77994_a == 0)) {
            ++this.ticks;
            if (this.ticksMove > this.ticks || this.ticks - this.ticksMove > Math.max(Math.abs(this.lastX - this.x) * 3, Math.abs(this.lastZ - this.z) * 3) + 10) {
                this.ticksMove = this.ticks;
                this.lastX = this.x;
                this.lastZ = this.z;
                while (this.x == this.lastX) {
                    this.x = this.field_145850_b.field_73012_v.nextInt(11);
                }
                while (this.z == this.lastZ) {
                    this.z = this.field_145850_b.field_73012_v.nextInt(11);
                }
            }
            if (this.ticks > CyberwareConfig.SCANNER_TIME) {
                this.ticks = 0;
                this.ticksMove = 0;
                if (!this.field_145850_b.field_72995_K && this.slots.getStackInSlot(1) != null && this.slots.getStackInSlot((int)1).field_77994_a > 0) {
                    float chance = CyberwareConfig.SCANNER_CHANCE + CyberwareConfig.SCANNER_CHANCE_ADDL * (float)(this.slots.getStackInSlot((int)0).field_77994_a - 1);
                    if (this.slots.getStackInSlot(0).func_77984_f()) {
                        chance = 50.0f * (1.0f - (float)this.slots.getStackInSlot(0).func_77952_i() * 1.0f / (float)this.slots.getStackInSlot(0).func_77958_k());
                    }
                    chance = Math.min(chance, 50.0f);
                    if (this.field_145850_b.field_73012_v.nextFloat() < chance / 100.0f) {
                        ItemStack blue = ItemBlueprint.getBlueprintForItem(toDestroy);
                        this.slots.setStackInSlot(2, blue);
                        ItemStack current = this.slots.getStackInSlot(1);
                        --current.field_77994_a;
                        if (current.field_77994_a <= 0) {
                            current = null;
                        }
                        this.slots.setStackInSlot(1, current);
                        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.func_174877_v()), this.field_145850_b.func_180495_p(this.func_174877_v()), 2);
                    }
                }
            }
            this.func_70296_d();
        } else {
            this.lastZ = 0;
            this.z = 0;
            this.lastX = 0;
            this.x = 0;
            if (this.ticks != 0) {
                this.ticks = 0;
                this.func_70296_d();
            }
        }
    }

    public float getProgress() {
        return (float)this.ticks * 1.0f / (float)CyberwareConfig.SCANNER_TIME;
    }

    public class GuiWrapper
    implements IItemHandlerModifiable {
        private ItemStackHandlerScanner slots;

        public GuiWrapper(ItemStackHandlerScanner slots) {
            this.slots = slots;
        }

        public int getSlots() {
            return this.slots.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.slots.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.slots.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            this.slots.overrideExtract = true;
            ItemStack ret = this.slots.extractItem(slot, amount, simulate);
            this.slots.overrideExtract = false;
            return ret;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            this.slots.setStackInSlot(slot, stack);
        }
    }

    public class ItemStackHandlerScanner
    extends ItemStackHandler {
        public boolean overrideExtract;
        private TileEntityScanner table;

        public ItemStackHandlerScanner(TileEntityScanner table, int i) {
            super(i);
            this.overrideExtract = false;
            this.table = table;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            super.setStackInSlot(slot, stack);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!this.isItemValidForSlot(slot, stack)) {
                return stack;
            }
            ItemStack result = super.insertItem(slot, stack, simulate);
            return result;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!this.canRemoveItem(slot)) {
                return null;
            }
            ItemStack result = super.extractItem(slot, amount, simulate);
            return result;
        }

        public boolean canRemoveItem(int slot) {
            if (this.overrideExtract) {
                return true;
            }
            return true;
        }

        public boolean isItemValidForSlot(int slot, ItemStack stack) {
            switch (slot) {
                case 0: {
                    return CyberwareAPI.canDeconstruct(stack);
                }
                case 1: {
                    int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
                    int paperId = OreDictionary.getOreID((String)"paper");
                    for (int id : ids) {
                        if (id != paperId) continue;
                        return true;
                    }
                    return false;
                }
                case 2: {
                    return false;
                }
            }
            return true;
        }
    }
}

