/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.handler;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.CyberwareUserDataImpl;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.common.CyberwareConfig;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.block.tile.TileEntityBeacon;
import flaxbeard.cyberware.common.entity.EntityCyberZombie;
import flaxbeard.cyberware.common.handler.EssentialsMissingHandler;
import flaxbeard.cyberware.common.network.CyberwarePacketHandler;
import flaxbeard.cyberware.common.network.CyberwareSyncPacket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.GameRules;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CyberwareDataHandler {
    public static final CyberwareDataHandler INSTANCE = new CyberwareDataHandler();
    public static final String KEEP_WARE_GAMERULE = "cyberware_keepCyberware";
    public static final String DROP_WARE_GAMERULE = "cyberware_dropCyberware";

    @SubscribeEvent
    public void onEntityConstructed(EntityEvent.EntityConstructing event) {
        if (event.getEntity() instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)event.getEntity();
            living.func_110140_aT().func_111150_b(CyberwareAPI.TOLERANCE_ATTR);
        }
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load event) {
        GameRules rules = event.getWorld().func_82736_K();
        if (!rules.func_82765_e(KEEP_WARE_GAMERULE)) {
            rules.func_180262_a(KEEP_WARE_GAMERULE, Boolean.toString(CyberwareConfig.DEFAULT_KEEP), GameRules.ValueType.BOOLEAN_VALUE);
        }
        if (!rules.func_82765_e(DROP_WARE_GAMERULE)) {
            rules.func_180262_a(DROP_WARE_GAMERULE, Boolean.toString(CyberwareConfig.DEFAULT_DROP), GameRules.ValueType.BOOLEAN_VALUE);
        }
    }

    @SubscribeEvent
    public void attachCyberwareData(AttachCapabilitiesEvent.Entity event) {
        if (event.getEntity() instanceof EntityPlayer) {
            event.addCapability(CyberwareUserDataImpl.Provider.NAME, (ICapabilityProvider)new CyberwareUserDataImpl.Provider());
        }
    }

    @SubscribeEvent
    public void playerDeathEvent(PlayerEvent.Clone event) {
        EntityPlayer p = event.getEntityPlayer();
        EntityPlayer o = event.getOriginal();
        if (event.isWasDeath()) {
            if (p.field_70170_p.func_72912_H().func_82574_x().func_82766_b(KEEP_WARE_GAMERULE) && CyberwareAPI.hasCapability((Entity)o) && CyberwareAPI.hasCapability((Entity)o)) {
                CyberwareAPI.getCapability((Entity)p).deserializeNBT(CyberwareAPI.getCapability((Entity)o).serializeNBT());
            }
        } else if (CyberwareAPI.hasCapability((Entity)o) && CyberwareAPI.hasCapability((Entity)o)) {
            CyberwareAPI.getCapability((Entity)p).deserializeNBT(CyberwareAPI.getCapability((Entity)o).serializeNBT());
        }
    }

    @SubscribeEvent
    public void handleCyberzombieDrops(LivingDropsEvent event) {
        EntityLivingBase e = event.getEntityLiving();
        if (e instanceof EntityPlayer && !e.field_70170_p.field_72995_K) {
            EntityPlayer p = (EntityPlayer)e;
            if ((p.field_70170_p.func_72912_H().func_82574_x().func_82766_b(DROP_WARE_GAMERULE) && !p.field_70170_p.func_72912_H().func_82574_x().func_82766_b(KEEP_WARE_GAMERULE) || p.field_70170_p.func_72912_H().func_82574_x().func_82766_b(KEEP_WARE_GAMERULE) && this.shouldDropWare(event.getSource())) && CyberwareAPI.hasCapability((Entity)p)) {
                ICyberwareUserData data = CyberwareAPI.getCapability((Entity)p);
                for (ICyberware.EnumSlot slot : ICyberware.EnumSlot.values()) {
                    ItemStack[] stacks = data.getInstalledCyberware(slot);
                    ItemStack[] defaults = (ItemStack[])CyberwareConfig.getStartingItems(ICyberware.EnumSlot.values()[slot.ordinal()]).clone();
                    for (ItemStack stack : stacks) {
                        if (stack == null) continue;
                        ItemStack toDrop = stack.func_77946_l();
                        boolean found = false;
                        for (ItemStack def : defaults) {
                            if (!CyberwareAPI.areCyberwareStacksEqual(def, toDrop)) continue;
                            if (toDrop.field_77994_a > def.field_77994_a) {
                                toDrop.field_77994_a -= def.field_77994_a;
                                continue;
                            }
                            found = true;
                        }
                        if (found || !(p.field_70170_p.field_73012_v.nextFloat() < CyberwareConfig.DROP_CHANCE / 100.0f)) continue;
                        EntityItem item = new EntityItem(p.field_70170_p, p.field_70165_t, p.field_70163_u, p.field_70161_v, toDrop);
                        p.field_70170_p.func_72838_d((Entity)item);
                    }
                }
                data.resetWare((EntityLivingBase)p);
            }
        }
        if (CyberwareConfig.NO_ZOMBIES || !(e instanceof EntityCyberZombie) || !((EntityCyberZombie)e).hasWare || !e.field_70170_p.field_72995_K) {
            // empty if block
        }
    }

    private boolean shouldDropWare(DamageSource source) {
        if (source == EssentialsMissingHandler.noessence) {
            return true;
        }
        if (source == EssentialsMissingHandler.heartless) {
            return true;
        }
        if (source == EssentialsMissingHandler.brainless) {
            return true;
        }
        if (source == EssentialsMissingHandler.nomuscles) {
            return true;
        }
        return source == EssentialsMissingHandler.spineless;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleCZSpawn(LivingSpawnEvent.SpecialSpawn event) {
        if (event.getEntityLiving() instanceof EntityZombie && !(event.getEntityLiving() instanceof EntityCyberZombie) && !(event.getEntityLiving() instanceof EntityPigZombie)) {
            EntityZombie zombie = (EntityZombie)event.getEntityLiving();
            int tier = TileEntityBeacon.isInRange(zombie.field_70170_p, zombie.field_70165_t, zombie.field_70163_u, zombie.field_70161_v);
            if (tier > 0) {
                float chance;
                float f = tier == 2 ? 10.0f : (chance = tier == 1 ? 5.0f : 20.0f);
                if (CyberwareConfig.NO_ZOMBIES || !(event.getWorld().field_73012_v.nextFloat() < chance / 100.0f)) {
                    return;
                }
                EntityCyberZombie cyberZombie = new EntityCyberZombie(event.getWorld());
                if (event.getWorld().field_73012_v.nextFloat() < 0.5f) {
                    boolean works = cyberZombie.setBrute();
                }
                cyberZombie.func_70012_b(zombie.field_70165_t, zombie.field_70163_u, zombie.field_70161_v, zombie.field_70177_z, zombie.field_70125_A);
                for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                    cyberZombie.func_184201_a(slot, zombie.func_184582_a(slot));
                }
                event.getWorld().func_72838_d((Entity)cyberZombie);
                zombie.field_70725_aQ = 19;
                zombie.func_70606_j(0.0f);
                return;
            }
        }
        if (event.getEntityLiving() instanceof EntityZombie && CyberwareConfig.CLOTHES && !CyberwareConfig.NO_CLOTHES && !(event.getEntityLiving() instanceof EntityPigZombie)) {
            EntityZombie zom = (EntityZombie)event.getEntityLiving();
            if (!zom.field_70170_p.field_72995_K && zom.func_184582_a(EntityEquipmentSlot.HEAD) == null && zom.field_70170_p.field_73012_v.nextFloat() < 0.04f) {
                if (zom.field_70170_p.field_73012_v.nextBoolean()) {
                    zom.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(CyberwareContent.shades));
                } else {
                    zom.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(CyberwareContent.shades2));
                }
                zom.func_184642_a(EntityEquipmentSlot.HEAD, 0.5f);
            }
            float chestRand = zom.field_70170_p.field_73012_v.nextFloat();
            if (!zom.field_70170_p.field_72995_K && zom.func_184582_a(EntityEquipmentSlot.CHEST) == null && chestRand < 0.04f) {
                ItemStack stack = new ItemStack((Item)CyberwareContent.trenchcoat);
                int rand = zom.field_70170_p.field_73012_v.nextInt(3);
                if (rand == 0) {
                    CyberwareContent.trenchcoat.func_82813_b(stack, 6701096);
                } else if (rand == 1) {
                    CyberwareContent.trenchcoat.func_82813_b(stack, 0xEAEAEA);
                }
                zom.func_184201_a(EntityEquipmentSlot.CHEST, stack);
                zom.func_184642_a(EntityEquipmentSlot.CHEST, 0.5f);
            } else if (!zom.field_70170_p.field_72995_K && zom.func_184582_a(EntityEquipmentSlot.CHEST) == null && chestRand - 0.04f < 0.04f) {
                ItemStack stack = new ItemStack(CyberwareContent.jacket);
                zom.func_184201_a(EntityEquipmentSlot.CHEST, stack);
                zom.func_184642_a(EntityEquipmentSlot.CHEST, 0.5f);
            }
        }
    }

    public static void addRandomCyberware(EntityCyberZombie cyberZombie, boolean brute) {
        ICyberwareUserData data = CyberwareAPI.getCapability((Entity)cyberZombie);
        ArrayList<ArrayList<ItemStack>> wares = new ArrayList<ArrayList<ItemStack>>();
        for (ICyberware.EnumSlot slot : ICyberware.EnumSlot.values()) {
            ArrayList<ItemStack> toAdd = new ArrayList<ItemStack>(Arrays.asList(data.getInstalledCyberware(slot)));
            toAdd.removeAll(Collections.singleton(null));
            wares.add(toAdd);
        }
        ItemStack battery = new ItemStack((Item)CyberwareContent.creativeBattery);
        ((List)wares.get(CyberwareContent.creativeBattery.getSlot(battery).ordinal())).add(battery);
        int numberOfItemsToInstall = ((CyberwareContent.NumItems)WeightedRandom.func_76271_a((Random)cyberZombie.field_70170_p.field_73012_v, CyberwareContent.numItems)).num;
        if (brute) {
            numberOfItemsToInstall += 2;
        }
        ArrayList<ItemStack> installed = new ArrayList<ItemStack>();
        ArrayList<CyberwareContent.ZombieItem> items = new ArrayList<CyberwareContent.ZombieItem>(CyberwareContent.zombieItems);
        for (int i = 0; i < numberOfItemsToInstall; ++i) {
            ItemStack[][] required;
            int tries = 0;
            ItemStack randomItem = null;
            ICyberware randomWare = null;
            do {
                randomItem = ItemStack.func_77944_b((ItemStack)((CyberwareContent.ZombieItem)WeightedRandom.func_76271_a((Random)cyberZombie.field_70170_p.field_73012_v, items)).stack);
                randomWare = CyberwareAPI.getCyberware(randomItem);
                randomItem.field_77994_a = randomWare.installedStackSize(randomItem);
            } while (CyberwareDataHandler.contains((List)wares.get(randomWare.getSlot(randomItem).ordinal()), randomItem) && ++tries < 10);
            if (tries >= 10) continue;
            for (ItemStack[] requiredCategory : required = (ItemStack[][])randomWare.required(randomItem).clone()) {
                boolean found = false;
                for (ItemStack option : requiredCategory) {
                    ICyberware optionWare = CyberwareAPI.getCyberware(option);
                    option.field_77994_a = optionWare.installedStackSize(option);
                    if (!CyberwareDataHandler.contains((List)wares.get(optionWare.getSlot(option).ordinal()), option)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                ItemStack req = requiredCategory[cyberZombie.field_70170_p.field_73012_v.nextInt(requiredCategory.length)].func_77946_l();
                ICyberware reqWare = CyberwareAPI.getCyberware(req);
                req.field_77994_a = reqWare.installedStackSize(req);
                ((List)wares.get(reqWare.getSlot(req).ordinal())).add(req);
                installed.add(req);
                ++i;
            }
            ((List)wares.get(randomWare.getSlot(randomItem).ordinal())).add(randomItem);
            installed.add(randomItem);
        }
        for (ICyberware.EnumSlot slot : ICyberware.EnumSlot.values()) {
            data.setInstalledCyberware((EntityLivingBase)cyberZombie, slot, (List)wares.get(slot.ordinal()));
        }
        data.updateCapacity();
        cyberZombie.func_70606_j(cyberZombie.func_110138_aP());
        cyberZombie.hasWare = true;
        CyberwareAPI.updateData((Entity)cyberZombie);
    }

    public static boolean contains(List<ItemStack> items, ItemStack item) {
        for (ItemStack check : items) {
            if (check == null || item == null || check.func_77973_b() != item.func_77973_b() || check.func_77952_i() != item.func_77952_i()) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void syncCyberwareData(EntityJoinWorldEvent event) {
        Entity e;
        if (!event.getWorld().field_72995_K && CyberwareAPI.hasCapability(e = event.getEntity()) && e instanceof EntityPlayer) {
            NBTTagCompound nbt = CyberwareAPI.getCapability(e).serializeNBT();
            CyberwarePacketHandler.INSTANCE.sendTo((IMessage)new CyberwareSyncPacket(nbt, e.func_145782_y()), (EntityPlayerMP)e);
        }
    }

    @SubscribeEvent
    public void startTrackingEvent(PlayerEvent.StartTracking event) {
        EntityPlayer tracker = event.getEntityPlayer();
        Entity target = event.getTarget();
        if (!target.field_70170_p.field_72995_K && CyberwareAPI.hasCapability(target)) {
            if (target instanceof EntityPlayer) {
                // empty if block
            }
            NBTTagCompound nbt = CyberwareAPI.getCapability(target).serializeNBT();
            CyberwarePacketHandler.INSTANCE.sendTo((IMessage)new CyberwareSyncPacket(nbt, target.func_145782_y()), (EntityPlayerMP)tracker);
        }
    }
}

