/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.handler;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.CyberwareUpdateEvent;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.client.ClientUtils;
import flaxbeard.cyberware.common.CyberwareConfig;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.block.tile.TileEntitySurgery;
import flaxbeard.cyberware.common.item.ItemCyberlimb;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class EssentialsMissingHandler {
    public static final DamageSource brainless = new DamageSource("cyberware.brainless").func_76348_h().func_151518_m();
    public static final DamageSource heartless = new DamageSource("cyberware.heartless").func_76348_h().func_151518_m();
    public static final DamageSource surgery = new DamageSource("cyberware.surgery").func_76348_h();
    public static final DamageSource spineless = new DamageSource("cyberware.spineless").func_76348_h().func_151518_m();
    public static final DamageSource nomuscles = new DamageSource("cyberware.nomuscles").func_76348_h().func_151518_m();
    public static final DamageSource noessence = new DamageSource("cyberware.noessence").func_76348_h().func_151518_m();
    public static final DamageSource lowessence = new DamageSource("cyberware.lowessence").func_76348_h().func_151518_m();
    public static final EssentialsMissingHandler INSTANCE = new EssentialsMissingHandler();
    private static Map<Integer, Integer> timesLungs = new HashMap<Integer, Integer>();
    private static final UUID speedId = UUID.fromString("fe00fdea-5044-11e6-beb8-9e71128cae77");
    private Map<Integer, Boolean> last = new HashMap<Integer, Boolean>();
    private Map<Integer, Boolean> lastClient = new HashMap<Integer, Boolean>();
    private static Map<Integer, Integer> hunger = new HashMap<Integer, Integer>();
    private static Map<Integer, Float> saturation = new HashMap<Integer, Float>();
    public static final ResourceLocation BLACK_PX = new ResourceLocation("cyberware:textures/gui/blackpx.png");
    private boolean removedMove = false;

    @SubscribeEvent
    public void triggerCyberwareEvent(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase e = event.getEntityLiving();
        if (CyberwareAPI.hasCapability((Entity)e)) {
            CyberwareUpdateEvent event2 = new CyberwareUpdateEvent(e);
            MinecraftForge.EVENT_BUS.post((Event)event2);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleMissingEssentials(CyberwareUpdateEvent event) {
        HashMultimap multimap;
        ItemStack legRight;
        ItemStack legLeft;
        EntityLivingBase e = event.getEntityLiving();
        ICyberwareUserData cyberware = CyberwareAPI.getCapability((Entity)e);
        if (e.field_70173_aa % 20 == 0) {
            cyberware.resetBuffer();
        }
        if (!cyberware.hasEssential(ICyberware.EnumSlot.CRANIUM)) {
            e.func_70097_a(brainless, 2.1474836E9f);
        }
        if (cyberware.getTolerance(e) < CyberwareConfig.CRITICAL_ESSENCE && e instanceof EntityPlayer && e.field_70173_aa % 100 == 0 && !e.func_70644_a(CyberwareContent.neuropozyneEffect)) {
            e.func_70690_d(new PotionEffect(CyberwareContent.rejectionEffect, 110, 0, true, false));
            e.func_70097_a(lowessence, 2.0f);
        }
        int numMissingLegs = 0;
        int numMissingLegsVisible = 0;
        if (cyberware.getTolerance(e) <= 0) {
            e.func_70097_a(noessence, 2.1474836E9f);
        }
        if (!cyberware.hasEssential(ICyberware.EnumSlot.LEG, ICyberware.ISidedLimb.EnumSide.LEFT)) {
            ++numMissingLegs;
            ++numMissingLegsVisible;
        }
        if (!cyberware.hasEssential(ICyberware.EnumSlot.LEG, ICyberware.ISidedLimb.EnumSide.RIGHT)) {
            ++numMissingLegs;
            ++numMissingLegsVisible;
        }
        if ((legLeft = cyberware.getCyberware(new ItemStack((Item)CyberwareContent.cyberlimbs, 1, 2))) != null && !ItemCyberlimb.isPowered(legLeft)) {
            ++numMissingLegs;
        }
        if ((legRight = cyberware.getCyberware(new ItemStack((Item)CyberwareContent.cyberlimbs, 1, 3))) != null && !ItemCyberlimb.isPowered(legRight)) {
            ++numMissingLegs;
        }
        if (e instanceof EntityPlayer) {
            AxisAlignedBB axisalignedbb;
            if (numMissingLegsVisible == 2) {
                e.field_70131_O = 1.175f;
                ((EntityPlayer)e).eyeHeight = ((EntityPlayer)e).getDefaultEyeHeight() - 0.625f;
                axisalignedbb = e.func_174813_aQ();
                e.func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + (double)e.field_70130_N, axisalignedbb.field_72338_b + (double)e.field_70131_O, axisalignedbb.field_72339_c + (double)e.field_70130_N));
                if (e.field_70170_p.field_72995_K) {
                    this.lastClient.put(e.func_145782_y(), true);
                } else {
                    this.last.put(e.func_145782_y(), true);
                }
            } else if (this.last(e.field_70170_p.field_72995_K, e)) {
                e.field_70131_O = 1.8f;
                ((EntityPlayer)e).eyeHeight = ((EntityPlayer)e).getDefaultEyeHeight();
                axisalignedbb = e.func_174813_aQ();
                e.func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + (double)e.field_70130_N, axisalignedbb.field_72338_b + (double)e.field_70131_O, axisalignedbb.field_72339_c + (double)e.field_70130_N));
                if (e.field_70170_p.field_72995_K) {
                    this.lastClient.put(e.func_145782_y(), false);
                } else {
                    this.last.put(e.func_145782_y(), false);
                }
            }
        }
        if (numMissingLegs >= 1 && e.field_70122_E) {
            multimap = HashMultimap.create();
            multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(speedId, "Missing leg speed", -100.0, 0));
            e.func_110140_aT().func_111147_b((Multimap)multimap);
        } else {
            multimap = HashMultimap.create();
            multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(speedId, "Missing leg speed", -100.0, 0));
            e.func_110140_aT().func_111148_a((Multimap)multimap);
        }
        if (!cyberware.hasEssential(ICyberware.EnumSlot.HEART)) {
            e.func_70097_a(heartless, 2.1474836E9f);
        }
        if (!cyberware.hasEssential(ICyberware.EnumSlot.BONE)) {
            e.func_70097_a(spineless, 2.1474836E9f);
        }
        if (!cyberware.hasEssential(ICyberware.EnumSlot.MUSCLE)) {
            e.func_70097_a(nomuscles, 2.1474836E9f);
        }
        if (!cyberware.hasEssential(ICyberware.EnumSlot.LUNGS)) {
            if (this.getLungsTime(e) >= 20) {
                timesLungs.put(e.func_145782_y(), e.field_70173_aa);
                e.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        } else {
            timesLungs.remove(e.func_145782_y());
        }
    }

    private boolean last(boolean remote, EntityLivingBase e) {
        if (remote) {
            if (!this.lastClient.containsKey(e.func_145782_y())) {
                this.lastClient.put(e.func_145782_y(), false);
            }
            return this.lastClient.get(e.func_145782_y());
        }
        if (!this.last.containsKey(e.func_145782_y())) {
            this.last.put(e.func_145782_y(), false);
        }
        return this.last.get(e.func_145782_y());
    }

    @SubscribeEvent
    public void handleJump(LivingEvent.LivingJumpEvent event) {
        EntityLivingBase e = event.getEntityLiving();
        if (CyberwareAPI.hasCapability((Entity)e)) {
            ItemStack legRight;
            ItemStack legLeft;
            ICyberwareUserData cyberware = CyberwareAPI.getCapability((Entity)e);
            int numMissingLegs = 0;
            if (!cyberware.hasEssential(ICyberware.EnumSlot.LEG, ICyberware.ISidedLimb.EnumSide.LEFT)) {
                ++numMissingLegs;
            }
            if (!cyberware.hasEssential(ICyberware.EnumSlot.LEG, ICyberware.ISidedLimb.EnumSide.RIGHT)) {
                ++numMissingLegs;
            }
            if ((legLeft = cyberware.getCyberware(new ItemStack((Item)CyberwareContent.cyberlimbs, 1, 2))) != null && !ItemCyberlimb.isPowered(legLeft)) {
                ++numMissingLegs;
            }
            if ((legRight = cyberware.getCyberware(new ItemStack((Item)CyberwareContent.cyberlimbs, 1, 3))) != null && !ItemCyberlimb.isPowered(legRight)) {
                ++numMissingLegs;
            }
            if (numMissingLegs == 2) {
                e.field_70181_x = 0.2f;
            }
        }
    }

    private int getLungsTime(EntityLivingBase e) {
        if (!timesLungs.containsKey(e.func_145782_y())) {
            timesLungs.put(e.func_145782_y(), e.field_70173_aa);
        }
        return e.field_70173_aa - timesLungs.get(e.func_145782_y());
    }

    @SubscribeEvent
    public void handleEatFoodTick(LivingEntityUseItemEvent.Tick event) {
        EntityLivingBase e = event.getEntityLiving();
        ItemStack stack = event.getItem();
        if (e instanceof EntityPlayer && CyberwareAPI.hasCapability((Entity)e) && stack != null && stack.func_77973_b().func_77661_b(stack) == EnumAction.EAT) {
            EntityPlayer p = (EntityPlayer)e;
            ICyberwareUserData cyberware = CyberwareAPI.getCapability((Entity)e);
            if (!cyberware.hasEssential(ICyberware.EnumSlot.LOWER_ORGANS)) {
                hunger.put(p.func_145782_y(), p.func_71024_bL().func_75116_a());
                saturation.put(p.func_145782_y(), Float.valueOf(p.func_71024_bL().func_75115_e()));
            }
        } else {
            hunger.remove(e.func_145782_y());
            saturation.remove(e.func_145782_y());
        }
    }

    @SubscribeEvent
    public void handleEatFoodEnd(LivingEntityUseItemEvent.Finish event) {
        EntityLivingBase e = event.getEntityLiving();
        ItemStack stack = event.getItem();
        if (e instanceof EntityPlayer && CyberwareAPI.hasCapability((Entity)e) && stack != null && stack.func_77973_b().func_77661_b(stack) == EnumAction.EAT) {
            EntityPlayer p = (EntityPlayer)e;
            ICyberwareUserData cyberware = CyberwareAPI.getCapability((Entity)e);
            if (!cyberware.hasEssential(ICyberware.EnumSlot.LOWER_ORGANS)) {
                int hungerVal = hunger.keySet().contains(p) ? hunger.get(p).intValue() : p.func_71024_bL().func_75116_a();
                float satVal = saturation.keySet().contains(p) ? saturation.get(p).floatValue() : p.func_71024_bL().func_75115_e();
                p.func_71024_bL().func_75114_a(hungerVal);
                p.func_71024_bL().func_75119_b(satVal);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void overlayPre(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71439_g != null) {
            EntityPlayerSP e = Minecraft.func_71410_x().field_71439_g;
            HashMultimap multimap = HashMultimap.create();
            multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(speedId, "Missing leg speed", -100.0, 0));
            e.func_110140_aT().func_111148_a((Multimap)multimap);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void overlayPre(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            ICyberwareUserData cyberware;
            EntityPlayerSP e = Minecraft.func_71410_x().field_71439_g;
            HashMultimap multimap = HashMultimap.create();
            multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(speedId, "Missing leg speed", -100.0, 0));
            if (CyberwareAPI.hasCapability((Entity)e) && !(cyberware = CyberwareAPI.getCapability((Entity)e)).hasEssential(ICyberware.EnumSlot.EYES) && !e.func_184812_l_()) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179147_l();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(BLACK_PX);
                ClientUtils.drawTexturedModalRect(0, 0, 0, 0, Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
                GlStateManager.func_179121_F();
            }
            if (TileEntitySurgery.workingOnPlayer) {
                float trans = 1.0f;
                float ticks = (float)TileEntitySurgery.playerProgressTicks + event.getPartialTicks();
                if (ticks < 20.0f) {
                    trans = ticks / 20.0f;
                } else if (ticks > 60.0f) {
                    trans = (80.0f - ticks) / 20.0f;
                }
                GL11.glEnable((int)3042);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)trans);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(BLACK_PX);
                ClientUtils.drawTexturedModalRect(0, 0, 0, 0, Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)3042);
            }
        }
    }

    @SubscribeEvent
    public void handleMissingSkin(LivingHurtEvent event) {
        ICyberwareUserData cyberware;
        EntityLivingBase e = event.getEntityLiving();
        if (!(!CyberwareAPI.hasCapability((Entity)e) || (cyberware = CyberwareAPI.getCapability((Entity)e)).hasEssential(ICyberware.EnumSlot.SKIN) || event.getSource().func_76363_c() && event.getSource() != DamageSource.field_76379_h)) {
            event.setAmount(event.getAmount() * 3.0f);
        }
    }

    @SubscribeEvent
    public void handleEntityInteract(PlayerInteractEvent.EntityInteract event) {
        EntityLivingBase e = event.getEntityLiving();
        if (CyberwareAPI.hasCapability((Entity)e)) {
            ICyberwareUserData cyberware = CyberwareAPI.getCapability((Entity)e);
            this.processEvent((Event)event, event.getHand(), event.getEntityPlayer(), cyberware);
        }
    }

    @SubscribeEvent
    public void handleLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        EntityLivingBase e = event.getEntityLiving();
        if (CyberwareAPI.hasCapability((Entity)e)) {
            ICyberwareUserData cyberware = CyberwareAPI.getCapability((Entity)e);
            this.processEvent((Event)event, event.getHand(), event.getEntityPlayer(), cyberware);
        }
    }

    @SubscribeEvent
    public void handleRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        EntityLivingBase e = event.getEntityLiving();
        if (CyberwareAPI.hasCapability((Entity)e)) {
            ICyberwareUserData cyberware = CyberwareAPI.getCapability((Entity)e);
            this.processEvent((Event)event, event.getHand(), event.getEntityPlayer(), cyberware);
        }
    }

    @SubscribeEvent
    public void handleRightClickItem(PlayerInteractEvent.RightClickItem event) {
        EntityLivingBase e = event.getEntityLiving();
        if (CyberwareAPI.hasCapability((Entity)e)) {
            ICyberwareUserData cyberware = CyberwareAPI.getCapability((Entity)e);
            this.processEvent((Event)event, event.getHand(), event.getEntityPlayer(), cyberware);
        }
    }

    private void processEvent(Event event, EnumHand hand, EntityPlayer p, ICyberwareUserData cyberware) {
        EnumHandSide mainHand = p.func_184591_cq();
        EnumHandSide offHand = mainHand == EnumHandSide.LEFT ? EnumHandSide.RIGHT : EnumHandSide.LEFT;
        ICyberware.ISidedLimb.EnumSide correspondingMainHand = mainHand == EnumHandSide.RIGHT ? ICyberware.ISidedLimb.EnumSide.RIGHT : ICyberware.ISidedLimb.EnumSide.LEFT;
        ICyberware.ISidedLimb.EnumSide correspondingOffHand = offHand == EnumHandSide.RIGHT ? ICyberware.ISidedLimb.EnumSide.RIGHT : ICyberware.ISidedLimb.EnumSide.LEFT;
        boolean leftUnpowered = false;
        ItemStack armLeft = cyberware.getCyberware(new ItemStack((Item)CyberwareContent.cyberlimbs, 1, 0));
        if (armLeft != null && !ItemCyberlimb.isPowered(armLeft)) {
            leftUnpowered = true;
        }
        boolean rightUnpowered = false;
        ItemStack armRight = cyberware.getCyberware(new ItemStack((Item)CyberwareContent.cyberlimbs, 1, 1));
        if (armRight != null && !ItemCyberlimb.isPowered(armRight)) {
            rightUnpowered = true;
        }
        if (hand == EnumHand.MAIN_HAND && (!cyberware.hasEssential(ICyberware.EnumSlot.ARM, correspondingMainHand) || leftUnpowered)) {
            event.setCanceled(true);
        } else if (hand == EnumHand.OFF_HAND && (!cyberware.hasEssential(ICyberware.EnumSlot.ARM, correspondingOffHand) || rightUnpowered)) {
            event.setCanceled(true);
        }
    }
}

