/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.item;

import com.mojang.realmsclient.gui.ChatFormatting;
import flaxbeard.cyberware.Cyberware;
import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.item.IBlueprint;
import flaxbeard.cyberware.common.CyberwareContent;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlueprint
extends Item
implements IBlueprint {
    public ItemBlueprint(String name) {
        this.setRegistryName(name);
        GameRegistry.register((IForgeRegistryEntry)this);
        this.func_77655_b("cyberware." + name);
        this.func_77637_a(Cyberware.creativeTab);
        this.func_77627_a(true);
        this.func_77625_d(1);
        CyberwareContent.items.add(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        NBTTagCompound comp;
        if (stack.func_77942_o() && (comp = stack.func_77978_p()).func_74764_b("blueprintItem")) {
            GameSettings settings = Minecraft.func_71410_x().field_71474_y;
            if (GameSettings.func_100015_a((KeyBinding)settings.field_74311_E)) {
                ItemStack blueprintItem = ItemStack.func_77949_a((NBTTagCompound)comp.func_74775_l("blueprintItem"));
                if (blueprintItem != null && CyberwareAPI.canDeconstruct(blueprintItem)) {
                    ItemStack[] items = (ItemStack[])CyberwareAPI.getComponents(blueprintItem).clone();
                    tooltip.add(I18n.func_135052_a((String)"cyberware.tooltip.blueprint", (Object[])new Object[]{blueprintItem.func_82833_r()}));
                    for (ItemStack item : items) {
                        if (item == null) continue;
                        tooltip.add(item.field_77994_a + " x " + item.func_82833_r());
                    }
                    return;
                }
            } else {
                tooltip.add(ChatFormatting.DARK_GRAY + I18n.func_135052_a((String)"cyberware.tooltip.shiftPrompt", (Object[])new Object[]{Minecraft.func_71410_x().field_71474_y.field_74311_E.getDisplayName()}));
                return;
            }
        }
        tooltip.add(ChatFormatting.DARK_GRAY + I18n.func_135052_a((String)"cyberware.tooltip.craftBlueprint", (Object[])new Object[0]));
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack((Item)this, 1, 1));
    }

    public static ItemStack getBlueprintForItem(ItemStack stack) {
        if (stack != null && CyberwareAPI.canDeconstruct(stack)) {
            ItemStack toBlue = stack.func_77946_l();
            toBlue.field_77994_a = 1;
            if (toBlue.func_77984_f()) {
                toBlue.func_77964_b(0);
            }
            toBlue.func_77982_d(null);
            ItemStack ret = new ItemStack(CyberwareContent.blueprint);
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound itemTag = new NBTTagCompound();
            toBlue.func_77955_b(itemTag);
            tag.func_74782_a("blueprintItem", (NBTBase)itemTag);
            ret.func_77982_d(tag);
            return ret;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        ItemStack blueprintItem;
        NBTTagCompound comp;
        if (stack.func_77942_o() && (comp = stack.func_77978_p()).func_74764_b("blueprintItem") && (blueprintItem = ItemStack.func_77949_a((NBTTagCompound)comp.func_74775_l("blueprintItem"))) != null) {
            return I18n.func_135052_a((String)"item.cyberware.blueprint.notBlank.name", (Object[])new Object[]{blueprintItem.func_82833_r()}).trim();
        }
        return ("" + I18n.func_135052_a((String)(this.func_77657_g(stack) + ".name"), (Object[])new Object[0])).trim();
    }

    @Override
    public ItemStack getResult(ItemStack stack, ItemStack[] craftingItems) {
        ItemStack blueprintItem;
        NBTTagCompound comp;
        if (stack.func_77942_o() && (comp = stack.func_77978_p()).func_74764_b("blueprintItem") && (blueprintItem = ItemStack.func_77949_a((NBTTagCompound)comp.func_74775_l("blueprintItem"))) != null && CyberwareAPI.canDeconstruct(blueprintItem)) {
            ItemStack[] requiredItems = (ItemStack[])CyberwareAPI.getComponents(blueprintItem).clone();
            for (int i = 0; i < requiredItems.length; ++i) {
                ItemStack required = requiredItems[i].func_77946_l();
                boolean satisfied = false;
                for (ItemStack crafting : craftingItems) {
                    if (crafting == null || required == null) continue;
                    if (crafting.func_77973_b() == required.func_77973_b() && crafting.func_77952_i() == required.func_77952_i() && (!required.func_77942_o() || ItemStack.func_77970_a((ItemStack)required, (ItemStack)crafting))) {
                        required.field_77994_a -= crafting.field_77994_a;
                    }
                    if (required.field_77994_a > 0) continue;
                    satisfied = true;
                    break;
                }
                if (satisfied) continue;
                return null;
            }
            return blueprintItem;
        }
        return null;
    }

    @Override
    public ItemStack[] consumeItems(ItemStack stack, ItemStack[] craftingItems) {
        ItemStack blueprintItem;
        NBTTagCompound comp;
        if (stack.func_77942_o() && (comp = stack.func_77978_p()).func_74764_b("blueprintItem") && (blueprintItem = ItemStack.func_77949_a((NBTTagCompound)comp.func_74775_l("blueprintItem"))) != null && CyberwareAPI.canDeconstruct(blueprintItem)) {
            ItemStack[] requiredItems = (ItemStack[])CyberwareAPI.getComponents(blueprintItem).clone();
            ItemStack[] newCrafting = new ItemStack[6];
            for (int c = 0; c < craftingItems.length; ++c) {
                newCrafting[c] = craftingItems[c];
            }
            block1: for (int i = 0; i < requiredItems.length; ++i) {
                ItemStack required = requiredItems[i].func_77946_l();
                boolean satisfied = false;
                for (int c = 0; c < newCrafting.length; ++c) {
                    ItemStack crafting = newCrafting[c];
                    if (crafting == null || required == null) continue;
                    if (crafting.func_77973_b() == required.func_77973_b() && crafting.func_77952_i() == required.func_77952_i() && (!required.func_77942_o() || ItemStack.func_77970_a((ItemStack)required, (ItemStack)crafting))) {
                        int toSubtract = Math.min(required.field_77994_a, crafting.field_77994_a);
                        required.field_77994_a -= toSubtract;
                        crafting.field_77994_a -= toSubtract;
                        if (crafting.field_77994_a <= 0) {
                            crafting = null;
                        }
                        newCrafting[c] = crafting;
                    }
                    if (required.field_77994_a <= 0) continue block1;
                }
            }
            return newCrafting;
        }
        throw new IllegalStateException("Consuming items when items shouldn't be consumed!");
    }

    @Override
    public ItemStack[] getRequirementsForDisplay(ItemStack stack) {
        ItemStack blueprintItem;
        NBTTagCompound comp;
        if (stack.func_77942_o() && (comp = stack.func_77978_p()).func_74764_b("blueprintItem") && (blueprintItem = ItemStack.func_77949_a((NBTTagCompound)comp.func_74775_l("blueprintItem"))) != null && CyberwareAPI.canDeconstruct(blueprintItem)) {
            return (ItemStack[])CyberwareAPI.getComponents(blueprintItem).clone();
        }
        return null;
    }

    @Override
    public ItemStack getIconForDisplay(ItemStack stack) {
        NBTTagCompound comp;
        if (stack.func_77942_o() && (comp = stack.func_77978_p()).func_74764_b("blueprintItem")) {
            return ItemStack.func_77949_a((NBTTagCompound)comp.func_74775_l("blueprintItem"));
        }
        return null;
    }
}

