/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.item;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.CyberwareUpdateEvent;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.client.ClientUtils;
import flaxbeard.cyberware.common.item.ItemCyberware;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class ItemLungsUpgrade
extends ItemCyberware {
    private Map<Integer, Boolean> lastOxygen = new HashMap<Integer, Boolean>();

    public ItemLungsUpgrade(String name, ICyberware.EnumSlot slot, String[] subnames) {
        super(name, slot, subnames);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onDrawScreenPost(RenderGameOverlayEvent.Post event) {
        EntityPlayerSP p;
        if (event.getType() == RenderGameOverlayEvent.ElementType.AIR && CyberwareAPI.isCyberwareInstalled((Entity)(p = Minecraft.func_71410_x().field_71439_g), new ItemStack((Item)this, 1, 0)) && !p.func_184812_l_()) {
            GL11.glPushMatrix();
            ItemStack stack = CyberwareAPI.getCyberware((Entity)p, new ItemStack((Item)this, 1, 0));
            int air = this.getAir(stack);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
            ScaledResolution res = event.getResolution();
            GlStateManager.func_179147_l();
            int left = res.func_78326_a() / 2 + 91;
            int top = res.func_78328_b() - 49 - 8;
            float r = 1.0f;
            float b = 1.0f;
            float g = 1.0f;
            if (p.func_70055_a(Material.field_151586_h)) {
                while (air > 0) {
                    GL11.glColor3f((float)(r += 1.0f), (float)(g += 0.25f), (float)(b -= 0.25f));
                    int drawAir = Math.min(300, air);
                    int full = MathHelper.func_76143_f((double)((double)(drawAir - 2) * 10.0 / 300.0));
                    int partial = MathHelper.func_76143_f((double)((double)drawAir * 10.0 / 300.0)) - full;
                    for (int i = 0; i < full + partial; ++i) {
                        ClientUtils.drawTexturedModalRect(left - i * 8 - 9, top, i < full ? 16 : 25, 18, 9, 9);
                    }
                    air -= 300;
                    top -= 8;
                }
            }
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }

    @SubscribeEvent
    public void handleLivingUpdate(CyberwareUpdateEvent event) {
        EntityLivingBase e = event.getEntityLiving();
        if (CyberwareAPI.isCyberwareInstalled((Entity)e, new ItemStack((Item)this, 1, 0))) {
            ItemStack stack = CyberwareAPI.getCyberware((Entity)e, new ItemStack((Item)this, 1, 0));
            int air = this.getAir(stack);
            if (e.func_70086_ai() < 300 && air > 0) {
                int toAdd = Math.min(300 - e.func_70086_ai(), air);
                e.func_70050_g(e.func_70086_ai() + toAdd);
                CyberwareAPI.getCyberwareNBT(stack).func_74768_a("air", air - toAdd);
            } else if (e.func_70086_ai() == 300 && air < 900) {
                CyberwareAPI.getCyberwareNBT(stack).func_74768_a("air", air + 1);
            }
        }
        ItemStack test = new ItemStack((Item)this, 1, 1);
        if (CyberwareAPI.isCyberwareInstalled((Entity)e, new ItemStack((Item)this, 1, 1)) && (e.func_70051_ag() || e instanceof EntityMob) && !e.func_70090_H() && e.field_70122_E) {
            boolean powerUsed;
            int ranks;
            boolean last = this.getLastOxygen(e);
            test.field_77994_a = ranks = CyberwareAPI.getCyberwareRank((Entity)e, test);
            boolean bl = powerUsed = e.field_70173_aa % 20 == 0 ? CyberwareAPI.getCapability((Entity)e).usePower(test, this.getPowerConsumption(test)) : last;
            if (powerUsed) {
                e.func_70060_a(0.0f, 0.2f * (float)ranks, 0.075f);
            }
            this.lastOxygen.put(e.func_145782_y(), powerUsed);
        }
    }

    private boolean getLastOxygen(EntityLivingBase e) {
        if (!this.lastOxygen.containsKey(e.func_145782_y())) {
            this.lastOxygen.put(e.func_145782_y(), true);
        }
        return this.lastOxygen.get(e.func_145782_y());
    }

    @Override
    public int installedStackSize(ItemStack stack) {
        return stack.func_77952_i() == 1 ? 3 : 1;
    }

    private int getAir(ItemStack stack) {
        NBTTagCompound data = CyberwareAPI.getCyberwareNBT(stack);
        if (!data.func_74764_b("air")) {
            data.func_74768_a("air", 900);
        }
        return data.func_74762_e("air");
    }

    @Override
    public int getPowerConsumption(ItemStack stack) {
        return stack.func_77952_i() == 1 ? 1 * stack.field_77994_a : 0;
    }

    @Override
    protected int getUnmodifiedEssenceCost(ItemStack stack) {
        if (stack.func_77952_i() == 1) {
            switch (stack.field_77994_a) {
                case 1: {
                    return 2;
                }
                case 2: {
                    return 4;
                }
                case 3: {
                    return 5;
                }
            }
        }
        return super.getUnmodifiedEssenceCost(stack);
    }
}

