/*
 * Decompiled with CFR 0.152.
 */
package net.pedroricardo.chiseledenchanting;

import com.mojang.datafixers.util.Function3;
import io.wispforest.owo.config.annotation.Config;
import io.wispforest.owo.config.annotation.RangeConstraint;

@Config(name="chiseledenchanting", wrapperName="ChiseledEnchantingConfig")
public class ChiseledEnchantingConfigModel {
    public boolean allowBookEnchanting = true;
    public ProbabilityType probabilityType = ProbabilityType.EXPONENTIAL;
    @RangeConstraint(min=0.0, max=1.0)
    public float firstBookProbability = 0.25f;
    @RangeConstraint(min=0.0, max=1.0)
    public float tenthBookProbability = 0.01f;
    public boolean chiseledBookshelvesProvidePower = false;
    @RangeConstraint(min=0.0, max=6.0)
    public int booksNecessaryForPower = 0;
    @RangeConstraint(min=0.0, max=1.0)
    public float substituteEnchantmentChance = 0.0f;

    public static enum ProbabilityType {
        LINEAR((Function3<Float, Float, Integer, Float>)((Function3)(zero, ten, i) -> Float.valueOf(zero.floatValue() + (ten.floatValue() - zero.floatValue()) * ((float)i.intValue() / 10.0f)))),
        EXPONENTIAL((Function3<Float, Float, Integer, Float>)((Function3)(zero, ten, i) -> Float.valueOf(zero.floatValue() * (float)Math.pow(ten.floatValue() / zero.floatValue(), (float)i.intValue() / 10.0f)))),
        QUADRATIC((Function3<Float, Float, Integer, Float>)((Function3)(zero, ten, i) -> Float.valueOf(zero.floatValue() + (ten.floatValue() - zero.floatValue()) * (float)Math.pow((float)i.intValue() / 10.0f, 2.0))));

        private Function3<Float, Float, Integer, Float> function;

        private ProbabilityType(Function3<Float, Float, Integer, Float> function) {
            this.function = function;
        }

        public float getProbability(float zero, float ten, int index) {
            return Math.min(((Float)this.function.apply((Object)Float.valueOf(zero), (Object)Float.valueOf(ten), (Object)index)).floatValue(), 1.0f);
        }
    }
}

