/*
 * Decompiled with CFR 0.152.
 */
package net.pedroricardo.chiseledenchanting.mixin;

import com.google.common.collect.Lists;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_156;
import net.minecraft.class_1718;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2331;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2499;
import net.minecraft.class_2586;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_6011;
import net.minecraft.class_7716;
import net.minecraft.class_7923;
import net.pedroricardo.chiseledenchanting.ChiseledEnchanting;
import net.pedroricardo.chiseledenchanting.ChiseledEnchantingTags;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1718.class})
public class EnchantmentScreenHandlerMixin {
    @Shadow
    @Final
    private class_5819 field_7811;
    @Unique
    private final List<class_1889> possibleEnchantments = new ArrayList<class_1889>();
    @Unique
    private int bookAmount = 0;

    @Inject(method={"method_17411"}, at={@At(value="HEAD")})
    private void chiseledenchanting$getEnchantments(class_1799 itemStack, class_1937 world, class_2338 tablePos, CallbackInfo ci) {
        this.possibleEnchantments.clear();
        this.bookAmount = 0;
        for (class_2338 blockPos : class_2331.field_36535) {
            class_2586 class_25862 = world.method_8321(tablePos.method_10081((class_2382)blockPos));
            if (!(class_25862 instanceof class_7716)) continue;
            class_7716 bookshelf = (class_7716)class_25862;
            for (int i = 0; i < bookshelf.method_5439(); ++i) {
                if (!bookshelf.method_5438(i).method_31574(class_1802.field_8598)) continue;
                ++this.bookAmount;
                Set possibleEnchantments = class_1890.method_22445((class_2499)class_1772.method_7806((class_1799)bookshelf.method_5438(i))).entrySet().stream().map(entry -> new class_1889((class_1887)entry.getKey(), ((Integer)entry.getValue()).intValue())).collect(Collectors.toSet());
                possibleEnchantments.removeIf(entry -> class_7923.field_41176.method_47983((Object)entry.field_9093).method_40220(ChiseledEnchantingTags.NOT_OBTAINABLE_FROM_CHISELED_BOOKSHELF));
                this.possibleEnchantments.addAll(possibleEnchantments);
            }
        }
    }

    @WrapOperation(method={"method_17411"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/EnchantingTableBlock;canAccessBookshelf(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;)Z")})
    private boolean chiseledenchanting$chiseledBookshelfProvidesPower(class_1937 world, class_2338 tablePos, class_2338 providerOffset, Operation<Boolean> original) {
        class_2586 class_25862 = world.method_8321(tablePos.method_10081((class_2382)providerOffset));
        if (!(class_25862 instanceof class_7716)) {
            return (Boolean)original.call(new Object[]{world, tablePos, providerOffset});
        }
        class_7716 bookshelf = (class_7716)class_25862;
        if (!ChiseledEnchanting.CONFIG.chiseledBookshelvesProvidePower()) {
            return false;
        }
        if (!world.method_22347(tablePos.method_10069(providerOffset.method_10263() / 2, providerOffset.method_10264(), providerOffset.method_10260() / 2))) {
            return false;
        }
        int bookCount = 0;
        for (int i = 0; i < bookshelf.method_5439(); ++i) {
            class_1799 itemStack = bookshelf.method_5438(i);
            if (itemStack.method_7960()) continue;
            ++bookCount;
        }
        return bookCount >= ChiseledEnchanting.CONFIG.booksNecessaryForPower();
    }

    @ModifyReturnValue(method={"generateEnchantments"}, at={@At(value="RETURN")})
    private List<class_1889> chiseledenchanting$addEnchantments(List<class_1889> list, @Local(ordinal=0, argsOnly=true) class_1799 stack, @Local(ordinal=1, argsOnly=true) int level) {
        List<class_1889> possibleEnchantments = this.possibleEnchantments.stream().filter(e -> !list.contains(e) && (e.field_9093.method_8192(stack) || stack.method_31574(class_1802.field_8529) && ChiseledEnchanting.CONFIG.allowBookEnchanting()) && class_1890.method_8201(class_1890.method_22445((class_2499)stack.method_7921()).keySet(), (class_1887)e.field_9093)).toList();
        if (possibleEnchantments.isEmpty()) {
            return list;
        }
        for (int i = 0; i < this.bookAmount; ++i) {
            float probability = this.getProbability(i);
            if (this.field_7811.method_43057() >= probability) continue;
            Map maxLevelEnchantments = possibleEnchantments.stream().collect(Collectors.toMap(e -> e.field_9093, Function.identity(), (entry1, entry2) -> entry1.field_9094 > entry2.field_9094 ? entry1 : entry2));
            List entries = EnchantmentScreenHandlerMixin.generateEnchantments(this.field_7811, stack, level / (int)Math.pow(2.0, list.size() - 1), possibleEnchantments.stream().map(e -> e.field_9093));
            if (entries.isEmpty()) {
                return list;
            }
            entries = entries.stream().map(e -> {
                for (int j = ((class_1889)maxLevelEnchantments.get((Object)e.field_9093)).field_9094; j >= Math.min(e.field_9093.method_8187(), ((class_1889)maxLevelEnchantments.get((Object)e.field_9093)).field_9094); --j) {
                    if (level < 1 + 11 * (j - 1) || level > 21 + 11 * (j - 1)) continue;
                    return new class_1889(e.field_9093, j);
                }
                return new class_1889(e.field_9093, e.field_9093.method_8187());
            }).collect(Collectors.toCollection(ArrayList::new));
            if (stack.method_31574(class_1802.field_8529)) {
                if (!list.isEmpty()) {
                    list.remove(this.field_7811.method_43048(list.size()));
                }
                if (entries.size() > 1) {
                    entries.remove(this.field_7811.method_43048(entries.size()));
                }
            }
            if (this.field_7811.method_43057() < ChiseledEnchanting.CONFIG.substituteEnchantmentChance()) {
                for (int j = 0; j < entries.size() && !list.isEmpty(); ++j) {
                    list.remove(this.field_7811.method_43048(list.size()));
                }
            }
            list.addAll(entries);
            break;
        }
        return list;
    }

    @Unique
    private float getProbability(int index) {
        return ChiseledEnchanting.CONFIG.probabilityType().getProbability(ChiseledEnchanting.CONFIG.firstBookProbability(), ChiseledEnchanting.CONFIG.tenthBookProbability(), index);
    }

    @Unique
    private static List<class_1889> generateEnchantments(class_5819 random, class_1799 stack, int level, Stream<class_1887> possibleEnchantments) {
        ArrayList list = Lists.newArrayList();
        class_1792 item = stack.method_7909();
        int i = item.method_7837();
        if (i > 0) {
            level += 1 + random.method_43048(i / 4 + 1) + random.method_43048(i / 4 + 1);
            float f = (random.method_43057() + random.method_43057() - 1.0f) * 0.15f;
            List<class_1889> list2 = EnchantmentScreenHandlerMixin.getPossibleEntries(level = class_3532.method_15340((int)Math.round((float)level + (float)level * f), (int)1, (int)Integer.MAX_VALUE), possibleEnchantments);
            if (!list2.isEmpty()) {
                Optional var10000 = class_6011.method_34986((class_5819)random, list2);
                Objects.requireNonNull(list);
                var10000.ifPresent(list::add);
                while (random.method_43048(50) <= level) {
                    if (!list.isEmpty()) {
                        EnchantmentScreenHandlerMixin.removeConflicts(list2, (class_1889)class_156.method_20793((List)list));
                    }
                    if (list2.isEmpty()) break;
                    var10000 = class_6011.method_34986((class_5819)random, list2);
                    Objects.requireNonNull(list);
                    var10000.ifPresent(list::add);
                    level /= 2;
                }
            }
        }
        return list;
    }

    @Unique
    private static void removeConflicts(List<class_1889> possibleEntries, class_1889 pickedEntry) {
        possibleEntries.removeIf(enchantmentLevelEntry -> !pickedEntry.field_9093.method_8188(enchantmentLevelEntry.field_9093));
    }

    @Unique
    private static List<class_1889> getPossibleEntries(int level, Stream<class_1887> possibleEnchantments) {
        ArrayList list = Lists.newArrayList();
        possibleEnchantments.forEach(enchantmentx -> {
            for (int j = enchantmentx.method_8183(); j >= enchantmentx.method_8187(); --j) {
                if (level < 1 + 11 * (j - 1) || level > 21 + 11 * (j - 1)) continue;
                list.add(new class_1889(enchantmentx, j));
                break;
            }
        });
        return list;
    }
}

