/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thedeepvoid.network;

import java.util.function.Supplier;
import net.mcreator.thedeepvoid.TheDeepVoidMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TheDeepVoidModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        TheDeepVoidMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        TheDeepVoidMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.StalkerCount = message.data.StalkerCount;
                    variables.ForgottenValleyAmbientSound = message.data.ForgottenValleyAmbientSound;
                    variables.StalkerSpawn = message.data.StalkerSpawn;
                    variables.StalkerCountFinish = message.data.StalkerCountFinish;
                    variables.playerX = message.data.playerX;
                    variables.playerY = message.data.playerY;
                    variables.playerZ = message.data.playerZ;
                    variables.RottenArmorAbility = message.data.RottenArmorAbility;
                    variables.hallucinate = message.data.hallucinate;
                    variables.StalkerStalkCount = message.data.StalkerStalkCount;
                    variables.crateX = message.data.crateX;
                    variables.crateY = message.data.crateY;
                    variables.crateZ = message.data.crateZ;
                    variables.VoidCaveAmbientSound = message.data.VoidCaveAmbientSound;
                    variables.NightmareCount = message.data.NightmareCount;
                    variables.VoidCloakAbility = message.data.VoidCloakAbility;
                    variables.inCreative = message.data.inCreative;
                    variables.InAdventure = message.data.InAdventure;
                    variables.cave_tremble = message.data.cave_tremble;
                    variables.darkness_absorption = message.data.darkness_absorption;
                    variables.seek_light = message.data.seek_light;
                    variables.playerCallOfTheVoid = message.data.playerCallOfTheVoid;
                    variables.CallOfTheVoidEnd = message.data.CallOfTheVoidEnd;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double StalkerCount = 0.0;
        public double ForgottenValleyAmbientSound = 0.0;
        public boolean StalkerSpawn = false;
        public boolean StalkerCountFinish = false;
        public double playerX = 0.0;
        public double playerY = 0.0;
        public double playerZ = 0.0;
        public double RottenArmorAbility = 0.0;
        public double hallucinate = 0.0;
        public double StalkerStalkCount = 0.0;
        public double crateX = 0.0;
        public double crateY = 0.0;
        public double crateZ = 0.0;
        public double VoidCaveAmbientSound = 0.0;
        public double NightmareCount = 0.0;
        public double VoidCloakAbility = 0.0;
        public boolean inCreative = false;
        public boolean InAdventure = false;
        public double cave_tremble = 0.0;
        public double darkness_absorption = 0.0;
        public boolean seek_light = false;
        public boolean playerCallOfTheVoid = false;
        public boolean CallOfTheVoidEnd = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                TheDeepVoidMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("StalkerCount", this.StalkerCount);
            nbt.m_128347_("ForgottenValleyAmbientSound", this.ForgottenValleyAmbientSound);
            nbt.m_128379_("StalkerSpawn", this.StalkerSpawn);
            nbt.m_128379_("StalkerCountFinish", this.StalkerCountFinish);
            nbt.m_128347_("playerX", this.playerX);
            nbt.m_128347_("playerY", this.playerY);
            nbt.m_128347_("playerZ", this.playerZ);
            nbt.m_128347_("RottenArmorAbility", this.RottenArmorAbility);
            nbt.m_128347_("hallucinate", this.hallucinate);
            nbt.m_128347_("StalkerStalkCount", this.StalkerStalkCount);
            nbt.m_128347_("crateX", this.crateX);
            nbt.m_128347_("crateY", this.crateY);
            nbt.m_128347_("crateZ", this.crateZ);
            nbt.m_128347_("VoidCaveAmbientSound", this.VoidCaveAmbientSound);
            nbt.m_128347_("NightmareCount", this.NightmareCount);
            nbt.m_128347_("VoidCloakAbility", this.VoidCloakAbility);
            nbt.m_128379_("inCreative", this.inCreative);
            nbt.m_128379_("InAdventure", this.InAdventure);
            nbt.m_128347_("cave_tremble", this.cave_tremble);
            nbt.m_128347_("darkness_absorption", this.darkness_absorption);
            nbt.m_128379_("seek_light", this.seek_light);
            nbt.m_128379_("playerCallOfTheVoid", this.playerCallOfTheVoid);
            nbt.m_128379_("CallOfTheVoidEnd", this.CallOfTheVoidEnd);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.StalkerCount = nbt.m_128459_("StalkerCount");
            this.ForgottenValleyAmbientSound = nbt.m_128459_("ForgottenValleyAmbientSound");
            this.StalkerSpawn = nbt.m_128471_("StalkerSpawn");
            this.StalkerCountFinish = nbt.m_128471_("StalkerCountFinish");
            this.playerX = nbt.m_128459_("playerX");
            this.playerY = nbt.m_128459_("playerY");
            this.playerZ = nbt.m_128459_("playerZ");
            this.RottenArmorAbility = nbt.m_128459_("RottenArmorAbility");
            this.hallucinate = nbt.m_128459_("hallucinate");
            this.StalkerStalkCount = nbt.m_128459_("StalkerStalkCount");
            this.crateX = nbt.m_128459_("crateX");
            this.crateY = nbt.m_128459_("crateY");
            this.crateZ = nbt.m_128459_("crateZ");
            this.VoidCaveAmbientSound = nbt.m_128459_("VoidCaveAmbientSound");
            this.NightmareCount = nbt.m_128459_("NightmareCount");
            this.VoidCloakAbility = nbt.m_128459_("VoidCloakAbility");
            this.inCreative = nbt.m_128471_("inCreative");
            this.InAdventure = nbt.m_128471_("InAdventure");
            this.cave_tremble = nbt.m_128459_("cave_tremble");
            this.darkness_absorption = nbt.m_128459_("darkness_absorption");
            this.seek_light = nbt.m_128471_("seek_light");
            this.playerCallOfTheVoid = nbt.m_128471_("playerCallOfTheVoid");
            this.CallOfTheVoidEnd = nbt.m_128471_("CallOfTheVoidEnd");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("the_deep_void", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "the_deep_void_mapvars";
        public boolean CultTemplePlaced = false;
        public boolean StalkerDespawned = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.CultTemplePlaced = nbt.m_128471_("CultTemplePlaced");
            this.StalkerDespawned = nbt.m_128471_("StalkerDespawned");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("CultTemplePlaced", this.CultTemplePlaced);
            nbt.m_128379_("StalkerDespawned", this.StalkerDespawned);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                TheDeepVoidMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "the_deep_void_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                TheDeepVoidMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.StalkerCount = original.StalkerCount;
            clone.ForgottenValleyAmbientSound = original.ForgottenValleyAmbientSound;
            clone.StalkerSpawn = original.StalkerSpawn;
            clone.StalkerCountFinish = original.StalkerCountFinish;
            clone.hallucinate = original.hallucinate;
            clone.StalkerStalkCount = original.StalkerStalkCount;
            clone.crateX = original.crateX;
            clone.crateY = original.crateY;
            clone.crateZ = original.crateZ;
            clone.VoidCaveAmbientSound = original.VoidCaveAmbientSound;
            clone.cave_tremble = original.cave_tremble;
            clone.seek_light = original.seek_light;
            clone.playerCallOfTheVoid = original.playerCallOfTheVoid;
            clone.CallOfTheVoidEnd = original.CallOfTheVoidEnd;
            if (!event.isWasDeath()) {
                clone.playerX = original.playerX;
                clone.playerY = original.playerY;
                clone.playerZ = original.playerZ;
                clone.RottenArmorAbility = original.RottenArmorAbility;
                clone.NightmareCount = original.NightmareCount;
                clone.VoidCloakAbility = original.VoidCloakAbility;
                clone.inCreative = original.inCreative;
                clone.InAdventure = original.InAdventure;
                clone.darkness_absorption = original.darkness_absorption;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().f_19853_);
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().f_19853_);
                if (mapdata != null) {
                    TheDeepVoidMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    TheDeepVoidMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().f_19853_.m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().f_19853_)) != null) {
                TheDeepVoidMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

