/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarycreatures.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import sfiomn.legendarycreatures.entities.AnimatedCreatureEntity;
import sfiomn.legendarycreatures.entities.goals.BaseMeleeAttackGoal;
import sfiomn.legendarycreatures.registry.ParticleTypeRegistry;
import sfiomn.legendarycreatures.registry.SoundRegistry;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class ScarecrowEntity
extends AnimatedCreatureEntity {
    private final int baseAttackDuration = 10;
    private final int baseAttackActionPoint = 5;
    private int movingStep = 0;
    private final RawAnimation ATTACK_ANIM = RawAnimation.begin().thenPlay("attack");

    public ScarecrowEntity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.f_21364_ = 12;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(5, (Goal)new BaseMeleeAttackGoal(this, 10, 5, 5, 1.0, true){

            @Override
            protected boolean executeAttack(LivingEntity target) {
                this.mob.m_5496_((SoundEvent)SoundRegistry.SCARECROW_BASE_ATTACK_HIT.get(), 1.0f, 1.0f);
                return super.executeAttack(target);
            }
        });
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    @Override
    public <E extends GeoAnimatable> PlayState attackingPredicate(AnimationState<E> state) {
        if (this.hasSpawnEffect() && this.f_19797_ < this.getSpawnAnimationTicks()) {
            return PlayState.CONTINUE;
        }
        if (this.getAttackAnimation() == 1) {
            return state.setAndContinue(this.ATTACK_ANIM);
        }
        state.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.SCARECROW_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        ++this.movingStep;
        if (this.movingStep % 2 == 0) {
            this.m_5496_((SoundEvent)SoundRegistry.SCARECROW_STEP.get(), 1.0f, 1.0f);
        }
    }

    @Override
    public int getSpawnAnimationTicks() {
        return 35;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.hasSpawnEffect() && this.f_19797_ == 1) {
            this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.SCARECROW_SPAWN.get(), SoundSource.HOSTILE, 10.0f, 1.0f);
        }
        if (this.hasSpawnEffect() && this.f_19797_ < 10) {
            for (int i = 0; i < 6; ++i) {
                double offsetX = (2.0f * this.m_9236_().m_213780_().m_188501_() - 1.0f) * 0.7f;
                double offsetY = 0.1 + (double)(this.m_9236_().m_213780_().m_188501_() * 0.2f);
                double offsetZ = (2.0f * this.m_9236_().m_213780_().m_188501_() - 1.0f) * 0.7f;
                double x = this.m_20182_().f_82479_ + offsetX;
                double y = this.m_20182_().f_82480_ + offsetY;
                double z = this.m_20182_().f_82481_ + offsetZ;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypeRegistry.CROWS_PARTICLE.get(), x, y, z, offsetX / 6.0, 0.23, offsetZ / 6.0);
            }
        }
    }

    protected void m_6153_() {
        super.m_6153_();
        if (this.m_9236_().f_46443_ && this.f_20919_ > 3 && this.f_20919_ <= 8 && !this.m_213877_()) {
            for (int i = 0; i < 5; ++i) {
                double offsetX = (2.0f * this.m_9236_().m_213780_().m_188501_() - 1.0f) * 0.4f;
                double offsetY = 0.5 + (double)(this.m_9236_().m_213780_().m_188501_() * 0.5f);
                double offsetZ = (2.0f * this.m_9236_().m_213780_().m_188501_() - 1.0f) * 0.4f;
                double x = this.m_20182_().f_82479_ + offsetX;
                double y = this.m_20182_().f_82480_ + offsetY;
                double z = this.m_20182_().f_82481_ + offsetZ;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypeRegistry.CROWS_PARTICLE.get(), x, y, z, offsetX / 6.0, 0.23, offsetZ / 6.0);
            }
        }
    }
}

