/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarycreatures.entities;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class AnimatedCreatureEntity
extends PathfinderMob
implements GeoEntity,
Enemy {
    protected static final UUID MAX_HEALTH_UUID = UUID.fromString("4133085c-5129-4018-9ea1-de2b2190ecc1");
    protected static final UUID ATTACK_DAMAGE_UUID = UUID.fromString("1d16a9ed-6ef2-4547-b14c-f3e3e7ec273e");
    private final AnimatableInstanceCache instanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(AnimatedCreatureEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_ANIMATION = SynchedEntityData.m_135353_(AnimatedCreatureEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SPAWN_EFFECT = SynchedEntityData.m_135353_(AnimatedCreatureEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final RawAnimation WALK_ANIM = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation IDLE_ANIM = RawAnimation.begin().thenPlay("idle");
    public static final int NO_ANIMATION = 0;
    public static final int BASE_ATTACK = 1;
    public static final int CHARGE_ATTACK = 2;
    public static final int CHARGING = 3;
    public static final int ROOT_ATTACK = 4;
    public static final int EFFECT_ATTACK = 5;
    public static final int DELAY_ATTACK = 6;
    public static final int DISTANCE_ATTACK = 7;

    protected AnimatedCreatureEntity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.m_274367_(1.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(ATTACK_ANIMATION, (Object)0);
        this.f_19804_.m_135372_(SPAWN_EFFECT, (Object)Boolean.FALSE);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag tag) {
        if (spawnType.equals((Object)MobSpawnType.SPAWN_EGG)) {
            this.setSpawnEffect(true);
        }
        return super.m_6518_(level, difficultyInstance, spawnType, spawnGroupData, tag);
    }

    public int getAttackAnimation() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_ANIMATION);
    }

    public void setAttackAnimation(int animation) {
        this.f_19804_.m_135381_(ATTACK_ANIMATION, (Object)animation);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public void setSpawnEffect(boolean spawnEffect) {
        this.f_19804_.m_135381_(SPAWN_EFFECT, (Object)spawnEffect);
    }

    public boolean hasSpawnEffect() {
        return (Boolean)this.f_19804_.m_135370_(SPAWN_EFFECT);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("variant", this.getVariant());
        nbt.m_128379_("spawn_effect", this.hasSpawnEffect());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setVariant(nbt.m_128451_("variant"));
        this.setSpawnEffect(nbt.m_128471_("spawn_effect"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268585_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268612_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268469_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268526_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268482_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public <E extends GeoAnimatable> PlayState movementPredicate(AnimationState<E> state) {
        if (this.hasSpawnEffect() && this.f_19797_ < this.getSpawnAnimationTicks()) {
            return PlayState.CONTINUE;
        }
        if (this.getDeathAnimation() != null && this.m_21224_()) {
            return state.setAndContinue(this.getDeathAnimation());
        }
        if (state.isMoving() || this.f_19790_ != this.m_20185_() || this.f_19792_ != this.m_20189_()) {
            if (this.m_20072_()) {
                if (this.getSwimAnimation() != null) {
                    return state.setAndContinue(this.getSwimAnimation());
                }
                if (this.getWalkAnimation() != null) {
                    return state.setAndContinue(this.getWalkAnimation());
                }
            } else {
                if (this.getSprintAnimation() != null && this.m_20142_()) {
                    return state.setAndContinue(this.getSprintAnimation());
                }
                if (this.getWalkAnimation() != null) {
                    return state.setAndContinue(this.getWalkAnimation());
                }
            }
        }
        return state.setAndContinue(this.getIdleAnimation());
    }

    public <E extends GeoAnimatable> PlayState attackingPredicate(AnimationState<E> state) {
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        if (this.getSpawnAnimationTicks() > 0 && this.hasSpawnEffect()) {
            controllerRegistrar.add(new AnimationController[]{DefaultAnimations.getSpawnController((GeoAnimatable)this, animationState -> this, (int)(this.hasSpawnEffect() ? this.getSpawnAnimationTicks() : 0))});
        }
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Movement", 6, this::movementPredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Attack", 6, this::attackingPredicate)});
    }

    public void m_8119_() {
        if (this.hasSpawnEffect() && (double)this.f_19797_ < (double)this.getSpawnAnimationTicks() * 0.6) {
            RandomSource random = this.m_217043_();
            for (int i = 0; i < 6; ++i) {
                double x = this.m_20185_() + 0.5 + ((double)(random.m_188501_() * 0.5f) - 1.0);
                double y = this.m_20186_() + 0.1;
                double z = this.m_20189_() + 0.5 + ((double)(random.m_188501_() * 0.5f) - 1.0);
                BlockState blockstate = this.m_9236_().m_8055_(new BlockPos((int)x, (int)y, (int)z).m_7495_());
                if (blockstate.m_60799_() == RenderShape.INVISIBLE || !this.m_9236_().f_46443_) continue;
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate), x, y, z, 0.0, 0.0, 0.0);
            }
        }
        if (this.hasSpawnEffect() && this.f_19797_ > this.getSpawnAnimationTicks() + 5) {
            this.setSpawnEffect(false);
        }
        super.m_8119_();
    }

    public static boolean checkHostileCreatureOnSurfaceSpawnRules(EntityType<? extends Mob> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, pos.m_123341_(), pos.m_123343_()) >= pos.m_123342_() && level.m_46791_() != Difficulty.PEACEFUL;
    }

    public static boolean checkHostileCreatureNoSpawnRules(EntityType<? extends Mob> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.m_46791_() != Difficulty.PEACEFUL;
    }

    public static boolean checkPeacefulCreatureOnSurfaceSpawnRules(EntityType<? extends Mob> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, pos.m_123341_(), pos.m_123343_()) >= pos.m_123342_();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return SoundEvents.f_12039_;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.instanceCache;
    }

    public int getSpawnAnimationTicks() {
        return 0;
    }

    public RawAnimation getWalkAnimation() {
        return this.WALK_ANIM;
    }

    public RawAnimation getIdleAnimation() {
        return this.IDLE_ANIM;
    }

    public RawAnimation getDeathAnimation() {
        return null;
    }

    public RawAnimation getSwimAnimation() {
        return null;
    }

    public RawAnimation getSprintAnimation() {
        return null;
    }

    protected void m_8024_() {
        if (this.m_20142_() != this.m_5912_()) {
            this.m_6858_(this.m_5912_());
        }
        super.m_8024_();
    }
}

