/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarycreatures.entities;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarycreatures.blocks.DoomFireBlock;
import sfiomn.legendarycreatures.entities.AnimatedCreatureEntity;
import sfiomn.legendarycreatures.entities.goals.BaseMeleeAttackGoal;
import sfiomn.legendarycreatures.registry.BlockRegistry;
import sfiomn.legendarycreatures.registry.ParticleTypeRegistry;
import sfiomn.legendarycreatures.registry.SoundRegistry;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class CorpseEaterEntity
extends AnimatedCreatureEntity {
    private final int baseAttackDuration = 15;
    private final int baseAttackActionPoint = 7;
    private final RawAnimation RUN_ANIM = RawAnimation.begin().thenPlay("run");
    private final RawAnimation ATTACK_ANIM = RawAnimation.begin().thenPlay("attack");

    public CorpseEaterEntity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.f_21364_ = 5;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22278_, 0.5);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.f_21345_.m_25352_(4, (Goal)new BaseMeleeAttackGoal(this, 15, 7, 5, 1.6, true){

            @Override
            protected boolean executeAttack(LivingEntity target) {
                this.mob.m_5496_((SoundEvent)SoundRegistry.CORPSE_EATER_ATTACK_HIT.get(), 1.0f, 1.0f);
                return super.executeAttack(target);
            }
        });
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.9, 20));
    }

    @Override
    public <E extends GeoAnimatable> PlayState attackingPredicate(AnimationState<E> state) {
        if (this.hasSpawnEffect() && this.f_19797_ < this.getSpawnAnimationTicks()) {
            return PlayState.CONTINUE;
        }
        if (this.getAttackAnimation() == 1) {
            this.m_5496_((SoundEvent)SoundRegistry.CORPSE_EATER_ATTACK.get(), 1.0f, 1.0f);
            return state.setAndContinue(this.ATTACK_ANIM);
        }
        state.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.hasSpawnEffect() && this.f_19797_ == 1) {
            this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.CORPSE_EATER_SPAWN.get(), SoundSource.HOSTILE, 10.0f, 1.0f);
        }
        if (this.hasSpawnEffect() && this.f_19797_ < 2) {
            for (int i = 0; i < 30; ++i) {
                double offsetX = (2.0f * this.m_9236_().m_213780_().m_188501_() - 1.0f) * 0.2f;
                double offsetZ = (2.0f * this.m_9236_().m_213780_().m_188501_() - 1.0f) * 0.2f;
                double x = this.m_20182_().f_82479_ + offsetX;
                double y = this.m_20182_().f_82480_ + 0.1 + (double)(this.m_9236_().m_213780_().m_188501_() * 0.2f);
                double z = this.m_20182_().f_82481_ + offsetZ;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypeRegistry.CORPSE_SPLATTER.get(), x, y, z, offsetX / 2.0, 0.23, offsetZ / 2.0);
            }
        }
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.CORPSE_EATER_IDLE.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.CORPSE_EATER_DEATH.get();
    }

    @Override
    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return (SoundEvent)SoundRegistry.CORPSE_EATER_HURT.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)SoundRegistry.CORPSE_EATER_STEP.get(), 1.0f, 1.0f);
    }

    @Override
    public RawAnimation getSprintAnimation() {
        return this.RUN_ANIM;
    }

    @Override
    public int getSpawnAnimationTicks() {
        return 25;
    }

    public void m_142687_(@NotNull Entity.RemovalReason reason) {
        if (!this.m_9236_().f_46443_ && this.m_21224_() && !this.m_213877_()) {
            for (int i = -2; i < 3; ++i) {
                for (int j = -2; j < 3; ++j) {
                    if (!((double)this.f_19796_.m_188501_() < 0.5)) continue;
                    BlockPos pos = this.m_20183_().m_121955_(new Vec3i(i, 0, j));
                    BlockPos posUp = this.m_20183_().m_7494_().m_121955_(new Vec3i(i, 0, j));
                    BlockPos posDown = this.m_20183_().m_7495_().m_121955_(new Vec3i(i, 0, j));
                    if (!this.applyFireAtPos(this.m_9236_(), pos) && !this.applyFireAtPos(this.m_9236_(), posDown) && !this.applyFireAtPos(this.m_9236_(), posUp)) continue;
                }
            }
        }
        super.m_142687_(reason);
    }

    private boolean applyFireAtPos(Level level, BlockPos pos) {
        if (DoomFireBlock.checkDoomFireSurvive(level.m_8055_(pos.m_7495_()), (LevelReader)level, pos.m_7495_()) && level.m_8055_(pos).m_60800_((BlockGetter)level, pos) == 0.0f) {
            level.m_46597_(pos, ((Block)BlockRegistry.DOOM_FIRE_BLOCK.get()).m_49966_());
            return true;
        }
        return false;
    }
}

