/*
 * Decompiled with CFR 0.152.
 */
package net.thevaliantsquidward.rainbowreef.client.models.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.thevaliantsquidward.rainbowreef.client.animations.ButterfishAnimations;
import net.thevaliantsquidward.rainbowreef.client.models.entity.base.ReefModel;
import net.thevaliantsquidward.rainbowreef.entity.ButterfishEntity;

@OnlyIn(value=Dist.CLIENT)
public class ButterfishModel<T extends ButterfishEntity>
extends ReefModel<T> {
    private final ModelPart root;
    private final ModelPart core;
    private final ModelPart body;
    private final ModelPart LowerFinTip;
    private final ModelPart TopFinTip;
    private final ModelPart l_bottom_fin;
    private final ModelPart r_bottom_fin;
    private final ModelPart l_fin;
    private final ModelPart r_fin;
    private final ModelPart Tail;

    public ButterfishModel(ModelPart root) {
        this.root = root.m_171324_("root");
        this.core = this.root.m_171324_("core");
        this.body = this.core.m_171324_("body");
        this.LowerFinTip = this.body.m_171324_("LowerFinTip");
        this.TopFinTip = this.body.m_171324_("TopFinTip");
        this.l_bottom_fin = this.body.m_171324_("l_bottom_fin");
        this.r_bottom_fin = this.body.m_171324_("r_bottom_fin");
        this.l_fin = this.body.m_171324_("l_fin");
        this.r_fin = this.body.m_171324_("r_fin");
        this.Tail = this.body.m_171324_("Tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.5f, (float)21.5f, (float)0.5f));
        PartDefinition core = root.m_171599_("core", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)-1.5f));
        PartDefinition body = core.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(24, 14).m_171488_(-1.0f, -3.5f, -3.5f, 1.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(24, 0).m_171488_(-1.0f, -4.5f, -3.5f, 1.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(23, 38).m_171488_(-1.0f, -0.5f, -4.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(11, 38).m_171488_(-1.0f, -0.5f, -5.5f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(16, 24).m_171488_(-1.0f, -2.5f, -4.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(30, 37).m_171488_(-1.0f, -0.5f, -6.5f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-0.5f, -8.5f, -5.5f, 0.0f, 13.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)1.5f));
        PartDefinition LowerFinTip = body.m_171599_("LowerFinTip", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171488_(-0.5f, -0.0033f, -0.0808f, 0.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-4.5f, (float)5.5f));
        PartDefinition TopFinTip = body.m_171599_("TopFinTip", CubeListBuilder.m_171558_().m_171514_(15, 27).m_171488_(-0.5f, 0.0f, 0.0f, 0.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.5f, (float)5.5f));
        PartDefinition l_bottom_fin = body.m_171599_("l_bottom_fin", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)2.5f, (float)-1.5f));
        PartDefinition l_bottom_fin_r1 = l_bottom_fin.m_171599_("l_bottom_fin_r1", CubeListBuilder.m_171558_().m_171514_(0, 35).m_171488_(0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.3927f, (float)0.0f));
        PartDefinition r_bottom_fin = body.m_171599_("r_bottom_fin", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.0f, (float)2.5f, (float)-1.5f));
        PartDefinition r_bottom_fin_r1 = r_bottom_fin.m_171599_("r_bottom_fin_r1", CubeListBuilder.m_171558_().m_171514_(0, 35).m_171480_().m_171488_(0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)-0.3927f, (float)0.0f));
        PartDefinition l_fin = body.m_171599_("l_fin", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)-1.5f));
        PartDefinition l_fin_r1 = l_fin.m_171599_("l_fin_r1", CubeListBuilder.m_171558_().m_171514_(18, 38).m_171488_(0.0f, -1.0f, 0.0f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition r_fin = body.m_171599_("r_fin", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.0f, (float)0.5f, (float)-1.5f));
        PartDefinition r_fin_r1 = r_fin.m_171599_("r_fin_r1", CubeListBuilder.m_171558_().m_171514_(18, 38).m_171480_().m_171488_(0.0f, -1.0f, 0.0f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition Tail = body.m_171599_("Tail", CubeListBuilder.m_171558_().m_171514_(30, 27).m_171488_(0.0f, -2.5f, 0.0f, 0.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)-1.0f, (float)2.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(ButterfishEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.body.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.m_233385_(entity.swimAnimationState, ButterfishAnimations.SWIM, ageInTicks, (float)(0.5 + (double)(limbSwingAmount * 4.0f)));
        this.m_233385_(entity.landAnimationState, ButterfishAnimations.FLOP, ageInTicks, 1.0f);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public List<ModelPart> getAllParts() {
        return ImmutableList.of((Object)this.root, (Object)this.core, (Object)this.body, (Object)this.LowerFinTip, (Object)this.TopFinTip, (Object)this.l_bottom_fin, (Object)this.r_bottom_fin, (Object)this.l_fin, (Object)this.r_fin, (Object)this.Tail);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

