/*
 * Decompiled with CFR 0.152.
 */
package net.thevaliantsquidward.rainbowreef.client.models.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.thevaliantsquidward.rainbowreef.client.animations.EagleRayAnimations;
import net.thevaliantsquidward.rainbowreef.client.models.entity.base.ReefModel;
import net.thevaliantsquidward.rainbowreef.entity.RayEntity;
import net.thevaliantsquidward.rainbowreef.util.MathHelpers;

@OnlyIn(value=Dist.CLIENT)
public class EagleRayModel<T extends RayEntity>
extends ReefModel<T> {
    private final ModelPart root;
    private final ModelPart core;
    private final ModelPart body;
    private final ModelPart onlyBody;
    private final ModelPart r_fin;
    private final ModelPart r_tip;
    private final ModelPart l_fin;
    private final ModelPart l_tip;
    private final ModelPart tail;
    private final ModelPart l_tail_fin;
    private final ModelPart r_tail_fin;
    private final ModelPart tail_tip;
    private final ModelPart tail_tip2;
    private final ModelPart tail_tip3;
    private final ModelPart tail_tip4;

    public EagleRayModel(ModelPart root) {
        this.root = root.m_171324_("root");
        this.core = this.root.m_171324_("core");
        this.body = this.core.m_171324_("body");
        this.onlyBody = this.body.m_171324_("onlyBody");
        this.r_fin = this.onlyBody.m_171324_("r_fin");
        this.r_tip = this.r_fin.m_171324_("r_tip");
        this.l_fin = this.onlyBody.m_171324_("l_fin");
        this.l_tip = this.l_fin.m_171324_("l_tip");
        this.tail = this.body.m_171324_("tail");
        this.l_tail_fin = this.tail.m_171324_("l_tail_fin");
        this.r_tail_fin = this.tail.m_171324_("r_tail_fin");
        this.tail_tip = this.tail.m_171324_("tail_tip");
        this.tail_tip2 = this.tail_tip.m_171324_("tail_tip2");
        this.tail_tip3 = this.tail_tip2.m_171324_("tail_tip3");
        this.tail_tip4 = this.tail_tip3.m_171324_("tail_tip4");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)22.5f, (float)0.0f));
        PartDefinition core = root.m_171599_("core", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)-7.0f));
        PartDefinition body = core.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)4.0f));
        PartDefinition onlyBody = body.m_171599_("onlyBody", CubeListBuilder.m_171558_().m_171514_(34, 16).m_171488_(-3.5f, -1.0f, -10.0f, 7.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-5.5f, -2.0f, -7.0f, 11.0f, 3.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)3.0f));
        PartDefinition r_fin = onlyBody.m_171599_("r_fin", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-11.0f, -0.5f, -6.0f, 11.0f, 1.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.5f, (float)0.5f, (float)0.0f));
        PartDefinition r_tip = r_fin.m_171599_("r_tip", CubeListBuilder.m_171558_().m_171514_(29, 29).m_171488_(-7.0f, -0.5f, -3.5f, 7.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-11.0f, (float)0.0f, (float)-2.5f));
        PartDefinition l_fin = onlyBody.m_171599_("l_fin", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(0.0f, -0.5f, -6.0f, 11.0f, 1.0f, 12.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)5.5f, (float)0.5f, (float)0.0f));
        PartDefinition l_tip = l_fin.m_171599_("l_tip", CubeListBuilder.m_171558_().m_171514_(29, 29).m_171480_().m_171488_(0.0f, -0.5f, -3.5f, 7.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)11.0f, (float)0.0f, (float)-2.5f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(7, 26).m_171488_(0.0f, -3.0f, 0.0f, 0.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)9.0f));
        PartDefinition l_tail_fin = tail.m_171599_("l_tail_fin", CubeListBuilder.m_171558_().m_171514_(30, 21).m_171488_(0.0f, 0.0f, -1.0f, 5.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)1.0f));
        PartDefinition r_tail_fin = tail.m_171599_("r_tail_fin", CubeListBuilder.m_171558_().m_171514_(30, 21).m_171480_().m_171488_(-5.0f, 0.0f, -1.0f, 5.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)1.0f));
        PartDefinition tail_tip = tail.m_171599_("tail_tip", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171488_(0.0f, -3.0f, 0.0f, 0.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)7.0f));
        PartDefinition tail_tip2 = tail_tip.m_171599_("tail_tip2", CubeListBuilder.m_171558_().m_171514_(10, 21).m_171488_(0.0f, -2.0f, 0.0f, 0.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)7.0f));
        PartDefinition tail_tip3 = tail_tip2.m_171599_("tail_tip3", CubeListBuilder.m_171558_().m_171514_(1, 41).m_171488_(0.0f, -1.5f, 0.0f, 0.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)8.0f));
        PartDefinition tail_tip4 = tail_tip3.m_171599_("tail_tip4", CubeListBuilder.m_171558_().m_171514_(1, 46).m_171488_(0.0f, -2.5f, 0.0f, 0.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)8.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(RayEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_233385_(entity.swimAnimationState, EagleRayAnimations.SWIM, ageInTicks, limbSwingAmount * 4.0f);
        this.animateIdle(entity.idleAnimationState, EagleRayAnimations.IDLE, ageInTicks, 1.0f, 1.0f - Math.abs(limbSwingAmount));
        this.m_233385_(entity.flopAnimationState, EagleRayAnimations.FLOP, ageInTicks, 1.0f);
        if (entity.m_20072_()) {
            this.tail.f_104204_ -= (float)MathHelpers.LerpDegrees(entity.tailKinematics.getCurrentTailYaws()[0], entity.tailKinematics.getTailYaws()[0], 0.1);
            this.tail_tip.f_104204_ -= (float)MathHelpers.LerpDegrees(entity.tailKinematics.getCurrentTailYaws()[1], entity.tailKinematics.getTailYaws()[1], 0.1);
            this.tail_tip2.f_104204_ -= (float)MathHelpers.LerpDegrees(entity.tailKinematics.getCurrentTailYaws()[2], entity.tailKinematics.getTailYaws()[2], 0.1);
            this.tail_tip3.f_104204_ -= (float)MathHelpers.LerpDegrees(entity.tailKinematics.getCurrentTailYaws()[3], entity.tailKinematics.getTailYaws()[3], 0.1);
            this.tail_tip4.f_104204_ -= (float)MathHelpers.LerpDegrees(entity.tailKinematics.getCurrentTailYaws()[4], entity.tailKinematics.getTailYaws()[4], 0.1);
            entity.tailKinematics.getCurrentTailYaws()[0] = (float)MathHelpers.LerpDegrees(entity.tailKinematics.getCurrentTailYaws()[0], entity.tailKinematics.getTailYaws()[0], 0.1);
            entity.tailKinematics.getCurrentTailYaws()[1] = (float)MathHelpers.LerpDegrees(entity.tailKinematics.getCurrentTailYaws()[1], entity.tailKinematics.getTailYaws()[1], 0.1);
            entity.tailKinematics.getCurrentTailYaws()[2] = (float)MathHelpers.LerpDegrees(entity.tailKinematics.getCurrentTailYaws()[2], entity.tailKinematics.getTailYaws()[2], 0.1);
            entity.tailKinematics.getCurrentTailYaws()[3] = (float)MathHelpers.LerpDegrees(entity.tailKinematics.getCurrentTailYaws()[3], entity.tailKinematics.getTailYaws()[3], 0.1);
            entity.tailKinematics.getCurrentTailYaws()[4] = (float)MathHelpers.LerpDegrees(entity.tailKinematics.getCurrentTailYaws()[4], entity.tailKinematics.getTailYaws()[4], 0.1);
            this.body.f_104203_ = headPitch * ((float)Math.PI / 180);
            this.tail.f_104203_ = -((float)((double)this.tail.f_104203_ + MathHelpers.LerpDegrees((float)entity.tailKinematics.getCurrentTailPitches()[0], (float)entity.tailKinematics.getTailPitches()[0], 0.1)));
            this.tail_tip.f_104203_ = -((float)((double)this.tail_tip.f_104203_ + MathHelpers.LerpDegrees((float)entity.tailKinematics.getCurrentTailPitches()[1], (float)entity.tailKinematics.getTailPitches()[1], 0.1)));
            this.tail_tip2.f_104203_ = -((float)((double)this.tail_tip2.f_104203_ + MathHelpers.LerpDegrees((float)entity.tailKinematics.getCurrentTailPitches()[2], (float)entity.tailKinematics.getTailPitches()[2], 0.1)));
            this.tail_tip3.f_104203_ = -((float)((double)this.tail_tip3.f_104203_ + MathHelpers.LerpDegrees((float)entity.tailKinematics.getCurrentTailPitches()[3], (float)entity.tailKinematics.getTailPitches()[3], 0.1)));
            this.tail_tip4.f_104203_ = -((float)((double)this.tail_tip4.f_104203_ + MathHelpers.LerpDegrees((float)entity.tailKinematics.getCurrentTailPitches()[4], (float)entity.tailKinematics.getTailPitches()[4], 0.1)));
            entity.tailKinematics.getCurrentTailPitches()[0] = (float)MathHelpers.LerpDegrees((float)entity.tailKinematics.getCurrentTailPitches()[0], (float)entity.tailKinematics.getTailPitches()[0], 0.1);
            entity.tailKinematics.getCurrentTailPitches()[1] = (float)MathHelpers.LerpDegrees((float)entity.tailKinematics.getCurrentTailPitches()[1], (float)entity.tailKinematics.getTailPitches()[1], 0.1);
            entity.tailKinematics.getCurrentTailPitches()[2] = (float)MathHelpers.LerpDegrees((float)entity.tailKinematics.getCurrentTailPitches()[2], (float)entity.tailKinematics.getTailPitches()[2], 0.1);
            entity.tailKinematics.getCurrentTailPitches()[3] = (float)MathHelpers.LerpDegrees((float)entity.tailKinematics.getCurrentTailPitches()[3], (float)entity.tailKinematics.getTailPitches()[3], 0.1);
            entity.tailKinematics.getCurrentTailPitches()[4] = (float)MathHelpers.LerpDegrees((float)entity.tailKinematics.getCurrentTailPitches()[4], (float)entity.tailKinematics.getTailPitches()[4], 0.1);
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

