/*
 * Decompiled with CFR 0.152.
 */
package net.thevaliantsquidward.rainbowreef.client.models.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.thevaliantsquidward.rainbowreef.client.animations.EelAnimations;
import net.thevaliantsquidward.rainbowreef.client.models.entity.base.ReefModel;
import net.thevaliantsquidward.rainbowreef.entity.EelEntity;
import net.thevaliantsquidward.rainbowreef.util.MathHelpers;

public class EelModel<T extends EelEntity>
extends ReefModel<T> {
    private final ModelPart root;
    private final ModelPart core;
    private final ModelPart body;
    private final ModelPart gills;
    private final ModelPart tailyawhinge;
    private final ModelPart tail;
    private final ModelPart tailyawhinge2;
    private final ModelPart tail2;
    private final ModelPart tailyawhinge3;
    private final ModelPart tail3;
    private final ModelPart tailyawhinge4;
    private final ModelPart tail4;
    private final ModelPart head;
    private final ModelPart cranium;
    private final ModelPart nose;
    private final ModelPart jaw;

    public EelModel(ModelPart root) {
        this.root = root.m_171324_("root");
        this.core = this.root.m_171324_("core");
        this.body = this.core.m_171324_("body");
        this.gills = this.body.m_171324_("gills");
        this.tailyawhinge = this.body.m_171324_("tailyawhinge");
        this.tail = this.tailyawhinge.m_171324_("tail");
        this.tailyawhinge2 = this.tail.m_171324_("tailyawhinge2");
        this.tail2 = this.tailyawhinge2.m_171324_("tail2");
        this.tailyawhinge3 = this.tail2.m_171324_("tailyawhinge3");
        this.tail3 = this.tailyawhinge3.m_171324_("tail3");
        this.tailyawhinge4 = this.tail3.m_171324_("tailyawhinge4");
        this.tail4 = this.tailyawhinge4.m_171324_("tail4");
        this.head = this.body.m_171324_("head");
        this.cranium = this.head.m_171324_("cranium");
        this.nose = this.cranium.m_171324_("nose");
        this.jaw = this.head.m_171324_("jaw");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition core = root.m_171599_("core", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)21.0f, (float)0.0f));
        PartDefinition body = core.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(3, 3).m_171488_(0.0f, -5.0f, -3.0f, 0.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition gills = body.m_171599_("gills", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(-1.0f, -2.0f, 0.0f, 3.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)0.0f, (float)-3.0f));
        PartDefinition tailyawhinge = body.m_171599_("tailyawhinge", CubeListBuilder.m_171558_().m_171514_(0, -2).m_171488_(0.0f, -6.0f, 0.0f, 0.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)5.0f));
        PartDefinition tail = tailyawhinge.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(25, 3).m_171488_(0.0f, -5.0f, 1.0f, 0.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 28).m_171488_(-1.0f, -2.0f, 0.0f, 2.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)0.0f));
        PartDefinition tailyawhinge2 = tail.m_171599_("tailyawhinge2", CubeListBuilder.m_171558_().m_171514_(4, -2).m_171488_(0.0f, -5.0f, 0.0f, 0.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)6.0f));
        PartDefinition tail2 = tailyawhinge2.m_171599_("tail2", CubeListBuilder.m_171558_().m_171514_(26, 21).m_171488_(0.0f, -5.0f, 1.0f, 0.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(38, 7).m_171488_(-1.0f, -2.0f, 0.0f, 2.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tailyawhinge3 = tail2.m_171599_("tailyawhinge3", CubeListBuilder.m_171558_().m_171514_(8, -2).m_171488_(0.0f, -4.0f, 0.0f, 0.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)5.0f));
        PartDefinition tail3 = tailyawhinge3.m_171599_("tail3", CubeListBuilder.m_171558_().m_171514_(34, 36).m_171488_(0.0f, -4.5f, 1.0f, 0.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(38, 16).m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)0.0f));
        PartDefinition tailyawhinge4 = tail3.m_171599_("tailyawhinge4", CubeListBuilder.m_171558_().m_171514_(12, -2).m_171488_(0.0f, -4.5f, 0.0f, 0.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)4.0f));
        PartDefinition tail4 = tailyawhinge4.m_171599_("tail4", CubeListBuilder.m_171558_().m_171514_(0, 38).m_171488_(0.0f, -4.5f, 0.0f, 0.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-3.0f));
        PartDefinition cranium = head.m_171599_("cranium", CubeListBuilder.m_171558_().m_171514_(17, 35).m_171488_(-1.0f, -2.0f, -5.0f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(16, 0).m_171488_(-1.0f, -1.5f, -5.0f, 2.0f, 2.0f, 5.0f, new CubeDeformation(-0.1f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition nose = cranium.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(14, 28).m_171488_(-2.5f, 0.0f, 0.0f, 5.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)-5.0f));
        PartDefinition jaw = head.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(39, 1).m_171488_(-1.0f, 0.0f, -5.0f, 2.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(16, 0).m_171488_(-1.0f, -1.5f, -5.0f, 2.0f, 2.0f, 5.0f, new CubeDeformation(-0.1f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(EelEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_233385_(entity.swimAnimationState, EelAnimations.SWIM, ageInTicks, limbSwingAmount * 4.0f);
        this.m_233385_(entity.landAnimationState, EelAnimations.LAND, ageInTicks, limbSwingAmount * 4.0f);
        this.m_233385_(entity.breathAnimationState, EelAnimations.BREATH, ageInTicks, (float)(1.0 + 0.5 * Math.toRadians(entity.m_146909_())));
        this.tailyawhinge.f_104204_ -= (float)MathHelpers.LerpDegrees(entity.tailKinematics.getCurrentTailYaws()[0], entity.tailKinematics.getTailYaws()[0], 0.1);
        this.tailyawhinge2.f_104204_ -= (float)MathHelpers.LerpDegrees(entity.tailKinematics.getCurrentTailYaws()[1], entity.tailKinematics.getTailYaws()[1], 0.1);
        this.tailyawhinge3.f_104204_ -= (float)MathHelpers.LerpDegrees(entity.tailKinematics.getCurrentTailYaws()[2], entity.tailKinematics.getTailYaws()[2], 0.1);
        this.tailyawhinge4.f_104204_ -= (float)MathHelpers.LerpDegrees(entity.tailKinematics.getCurrentTailYaws()[3], entity.tailKinematics.getTailYaws()[3], 0.1);
        entity.tailKinematics.getCurrentTailYaws()[0] = (float)MathHelpers.LerpDegrees(entity.tailKinematics.getCurrentTailYaws()[0], entity.tailKinematics.getTailYaws()[0], 0.1);
        entity.tailKinematics.getCurrentTailYaws()[1] = (float)MathHelpers.LerpDegrees(entity.tailKinematics.getCurrentTailYaws()[1], entity.tailKinematics.getTailYaws()[1], 0.1);
        entity.tailKinematics.getCurrentTailYaws()[2] = (float)MathHelpers.LerpDegrees(entity.tailKinematics.getCurrentTailYaws()[2], entity.tailKinematics.getTailYaws()[2], 0.1);
        entity.tailKinematics.getCurrentTailYaws()[3] = (float)MathHelpers.LerpDegrees(entity.tailKinematics.getCurrentTailYaws()[3], entity.tailKinematics.getTailYaws()[3], 0.1);
        if (entity.m_20072_()) {
            this.body.f_104203_ = headPitch * ((float)Math.PI / 180);
            this.tail.f_104203_ = -((float)((double)this.tail.f_104203_ + MathHelpers.LerpDegrees((float)entity.tailKinematics.getCurrentTailPitches()[0], (float)entity.tailKinematics.getTailPitches()[0], 0.1)));
            this.tail2.f_104203_ = -((float)((double)this.tail2.f_104203_ + MathHelpers.LerpDegrees((float)entity.tailKinematics.getCurrentTailPitches()[1], (float)entity.tailKinematics.getTailPitches()[1], 0.1)));
            this.tail3.f_104203_ = -((float)((double)this.tail3.f_104203_ + MathHelpers.LerpDegrees((float)entity.tailKinematics.getCurrentTailPitches()[2], (float)entity.tailKinematics.getTailPitches()[2], 0.1)));
            this.tail4.f_104203_ = -((float)((double)this.tail4.f_104203_ + MathHelpers.LerpDegrees((float)entity.tailKinematics.getCurrentTailPitches()[3], (float)entity.tailKinematics.getTailPitches()[3], 0.1)));
            entity.tailKinematics.getCurrentTailPitches()[0] = (float)MathHelpers.LerpDegrees((float)entity.tailKinematics.getCurrentTailPitches()[0], (float)entity.tailKinematics.getTailPitches()[0], 0.1);
            entity.tailKinematics.getCurrentTailPitches()[1] = (float)MathHelpers.LerpDegrees((float)entity.tailKinematics.getCurrentTailPitches()[1], (float)entity.tailKinematics.getTailPitches()[1], 0.1);
            entity.tailKinematics.getCurrentTailPitches()[2] = (float)MathHelpers.LerpDegrees((float)entity.tailKinematics.getCurrentTailPitches()[2], (float)entity.tailKinematics.getTailPitches()[2], 0.1);
            entity.tailKinematics.getCurrentTailPitches()[3] = (float)MathHelpers.LerpDegrees((float)entity.tailKinematics.getCurrentTailPitches()[3], (float)entity.tailKinematics.getTailPitches()[3], 0.1);
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public List<ModelPart> getAllParts() {
        return ImmutableList.of((Object)this.root, (Object)this.core, (Object)this.gills, (Object)this.tailyawhinge, (Object)this.tail, (Object)this.tailyawhinge2, (Object)this.tail2, (Object)this.tailyawhinge3, (Object)this.tail3, (Object)this.tailyawhinge4, (Object)this.tail4, (Object)this.head, (Object[])new ModelPart[]{this.cranium, this.nose, this.jaw});
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

