/*
 * Decompiled with CFR 0.152.
 */
package net.thevaliantsquidward.rainbowreef.client.models.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.thevaliantsquidward.rainbowreef.client.animations.PipefishAnimations;
import net.thevaliantsquidward.rainbowreef.entity.PipefishEntity;

@OnlyIn(value=Dist.CLIENT)
public class PipefishModel<T extends PipefishEntity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart core;
    private final ModelPart body;
    private final ModelPart l_fin;
    private final ModelPart r_fin;
    private final ModelPart tail_base;
    private final ModelPart tail_end;

    public PipefishModel(ModelPart root) {
        this.root = root.m_171324_("root");
        this.core = this.root.m_171324_("core");
        this.body = this.core.m_171324_("body");
        this.l_fin = this.body.m_171324_("l_fin");
        this.r_fin = this.body.m_171324_("r_fin");
        this.tail_base = this.core.m_171324_("tail_base");
        this.tail_end = this.tail_base.m_171324_("tail_end");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)22.5f, (float)0.0f));
        PartDefinition core = root.m_171599_("core", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-3.0f));
        PartDefinition body = core.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(9, 3).m_171488_(-0.5f, -1.0f, -8.0f, 1.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-1.0f, -2.0f, -3.0f, 2.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)3.0f));
        PartDefinition l_fin = body.m_171599_("l_fin", CubeListBuilder.m_171558_().m_171514_(7, 2).m_171488_(0.0f, 0.0f, -1.0f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)1.0f, (float)-1.0f));
        PartDefinition r_fin = body.m_171599_("r_fin", CubeListBuilder.m_171558_().m_171514_(7, 2).m_171480_().m_171488_(-2.0f, 0.0f, -1.0f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.0f, (float)1.0f, (float)-1.0f));
        PartDefinition tail_base = core.m_171599_("tail_base", CubeListBuilder.m_171558_().m_171514_(0, 4).m_171488_(0.0f, -1.0f, 0.0f, 0.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)5.0f));
        PartDefinition tail_end = tail_base.m_171599_("tail_end", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, -2.5f, 0.0f, 0.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)4.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(PipefishEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_233385_(entity.swimAnimationState, PipefishAnimations.SWIM, ageInTicks, 1.25f * (limbSwingAmount * 4.0f + 0.8f));
        this.m_233385_(entity.flopAnimationState, PipefishAnimations.FLOP, ageInTicks, 1.0f);
        this.root.f_104203_ = headPitch * ((float)Math.PI / 180);
    }

    public List<ModelPart> getAllParts() {
        return ImmutableList.of((Object)this.root, (Object)this.core, (Object)this.body, (Object)this.l_fin, (Object)this.r_fin, (Object)this.tail_base, (Object)this.tail_end);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

