/*
 * Decompiled with CFR 0.152.
 */
package net.thevaliantsquidward.rainbowreef.client.models.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.thevaliantsquidward.rainbowreef.client.animations.SeahorseAnimations;
import net.thevaliantsquidward.rainbowreef.client.models.entity.base.ReefModel;
import net.thevaliantsquidward.rainbowreef.entity.SeahorseEntity;

@OnlyIn(value=Dist.CLIENT)
public class SeahorseModel<T extends SeahorseEntity>
extends ReefModel<T> {
    private final ModelPart root;
    private final ModelPart core;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart back_fin;
    private final ModelPart tail;

    public SeahorseModel(ModelPart root) {
        this.root = root.m_171324_("root");
        this.core = this.root.m_171324_("core");
        this.head = this.core.m_171324_("head");
        this.body = this.core.m_171324_("body");
        this.back_fin = this.body.m_171324_("back_fin");
        this.tail = this.body.m_171324_("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)22.0f, (float)0.0f));
        PartDefinition core = root.m_171599_("core", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition head = core.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)1.0f));
        PartDefinition head_r1 = head.m_171599_("head_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, -3.5f, -2.0f, 3.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(10, 0).m_171488_(-1.5f, -2.5f, -2.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 13).m_171488_(-0.5f, -1.5f, -5.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.5f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition body = core.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(6, 8).m_171488_(-1.0f, -2.0f, -2.0f, 2.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition back_fin = body.m_171599_("back_fin", CubeListBuilder.m_171558_().m_171514_(14, 4).m_171488_(0.0f, -2.0f, 0.0f, 0.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)2.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, -2.0f, -4.0f, 0.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(8, 16).m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(SeahorseEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_233385_(entity.swimAnimationState, SeahorseAnimations.SWIM, ageInTicks, 0.7f + (limbSwingAmount * 4.0f + 0.4f));
        this.m_233385_(entity.flopAnimationState, SeahorseAnimations.FLOP, ageInTicks, 1.0f);
        this.root.f_104203_ = headPitch * ((float)Math.PI / 180);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

