/*
 * Decompiled with CFR 0.152.
 */
package net.thevaliantsquidward.rainbowreef.client.models.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.thevaliantsquidward.rainbowreef.client.animations.SmallSharkAnimations;
import net.thevaliantsquidward.rainbowreef.client.models.entity.base.ReefModel;
import net.thevaliantsquidward.rainbowreef.entity.SmallSharkEntity;
import net.thevaliantsquidward.rainbowreef.util.MathHelpers;

@OnlyIn(value=Dist.CLIENT)
public class SmallSharkModel<T extends SmallSharkEntity>
extends ReefModel<T> {
    private final ModelPart root;
    private final ModelPart core;
    private final ModelPart body;
    private final ModelPart top_fin;
    private final ModelPart l_fin;
    private final ModelPart r_fin;
    private final ModelPart tailRot;
    private final ModelPart tail;
    private final ModelPart tail_l_fin;
    private final ModelPart tail_r_fin;
    private final ModelPart tailFinRot;
    private final ModelPart tail_fin;

    public SmallSharkModel(ModelPart root) {
        this.root = root.m_171324_("root");
        this.core = this.root.m_171324_("core");
        this.body = this.core.m_171324_("body");
        this.top_fin = this.body.m_171324_("top_fin");
        this.l_fin = this.core.m_171324_("l_fin");
        this.r_fin = this.core.m_171324_("r_fin");
        this.tailRot = this.core.m_171324_("tailRot");
        this.tail = this.tailRot.m_171324_("tail");
        this.tail_l_fin = this.tail.m_171324_("tail_l_fin");
        this.tail_r_fin = this.tail.m_171324_("tail_r_fin");
        this.tailFinRot = this.tail.m_171324_("tailFinRot");
        this.tail_fin = this.tailFinRot.m_171324_("tail_fin");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)22.0f, (float)-4.5f));
        PartDefinition core = root.m_171599_("core", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)4.0f));
        PartDefinition body = core.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -2.0f, -1.0f, 4.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(22, 25).m_171488_(2.0f, -3.0f, 0.0f, 0.0f, 1.0f, 3.0f, new CubeDeformation(0.001f)).m_171514_(22, 25).m_171480_().m_171488_(-2.0f, -3.0f, 0.0f, 0.0f, 1.0f, 3.0f, new CubeDeformation(0.001f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-6.0f));
        PartDefinition top_fin = body.m_171599_("top_fin", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(0.0f, -3.0f, -1.0f, 0.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)5.0f));
        PartDefinition l_fin = core.m_171599_("l_fin", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.0f, (float)2.0f, (float)-3.0f));
        PartDefinition l_fin_r1 = l_fin.m_171599_("l_fin_r1", CubeListBuilder.m_171558_().m_171514_(14, 4).m_171488_(0.0f, 0.0f, -1.0f, 4.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f));
        PartDefinition r_fin = core.m_171599_("r_fin", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-2.0f, (float)2.0f, (float)-3.0f));
        PartDefinition r_fin_r1 = r_fin.m_171599_("r_fin_r1", CubeListBuilder.m_171558_().m_171514_(14, 4).m_171480_().m_171488_(-4.0f, 0.0f, -1.0f, 4.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f));
        PartDefinition tailRot = core.m_171599_("tailRot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)3.0f));
        PartDefinition tail = tailRot.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171488_(0.0f, -3.0f, 0.0f, 0.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail_l_fin = tail.m_171599_("tail_l_fin", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)1.0f));
        PartDefinition tail_l_fin_r1 = tail_l_fin.m_171599_("tail_l_fin_r1", CubeListBuilder.m_171558_().m_171514_(13, 20).m_171488_(0.0f, 0.0f, -1.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f));
        PartDefinition tail_r_fin = tail.m_171599_("tail_r_fin", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)1.0f));
        PartDefinition tail_r_fin_r1 = tail_r_fin.m_171599_("tail_r_fin_r1", CubeListBuilder.m_171558_().m_171514_(13, 20).m_171480_().m_171488_(-3.0f, 0.0f, -1.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f));
        PartDefinition tailFinRot = tail.m_171599_("tailFinRot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)8.0f));
        PartDefinition tail_fin = tailFinRot.m_171599_("tail_fin", CubeListBuilder.m_171558_().m_171514_(0, 4).m_171488_(0.0f, -5.0f, 0.0f, 0.0f, 6.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(SmallSharkEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.core.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.m_233385_(entity.swimAnimationState, SmallSharkAnimations.SWIM, ageInTicks, limbSwingAmount * 8.0f);
        this.animateIdle(entity.idleAnimationState, SmallSharkAnimations.IDLE, ageInTicks, 1.0f, 1.0f - Math.abs(limbSwingAmount));
        if (entity.m_20072_()) {
            this.tail.f_104204_ -= (float)MathHelpers.LerpDegrees(entity.tailKinematics.getCurrentTailYaws()[0], entity.tailKinematics.getTailYaws()[0], 0.1);
            this.tail_fin.f_104204_ = this.tail.f_104204_ - (float)MathHelpers.LerpDegrees(entity.tailKinematics.getCurrentTailYaws()[1], entity.tailKinematics.getTailYaws()[1], 0.1);
            entity.tailKinematics.getCurrentTailYaws()[0] = (float)MathHelpers.LerpDegrees(entity.tailKinematics.getCurrentTailYaws()[0], entity.tailKinematics.getTailYaws()[0], 0.1);
            entity.tailKinematics.getCurrentTailYaws()[1] = (float)MathHelpers.LerpDegrees(entity.tailKinematics.getCurrentTailYaws()[1], entity.tailKinematics.getTailYaws()[1], 0.1);
            this.tail.f_104203_ -= (float)MathHelpers.LerpDegrees(entity.tailKinematics.getCurrentTailPitches()[0], entity.tailKinematics.getTailPitches()[0], 0.1);
            this.tail_fin.f_104203_ -= (float)MathHelpers.LerpDegrees(entity.tailKinematics.getCurrentTailPitches()[1], entity.tailKinematics.getTailPitches()[1], 0.1);
            entity.tailKinematics.getCurrentTailPitches()[0] = (float)MathHelpers.LerpDegrees(entity.tailKinematics.getCurrentTailPitches()[0], entity.tailKinematics.getTailPitches()[0], 0.1);
            entity.tailKinematics.getCurrentTailPitches()[1] = (float)MathHelpers.LerpDegrees(entity.tailKinematics.getCurrentTailPitches()[1], entity.tailKinematics.getTailPitches()[1], 0.1);
        }
    }

    public List<ModelPart> getAllParts() {
        return ImmutableList.of((Object)this.root, (Object)this.core, (Object)this.body, (Object)this.top_fin, (Object)this.l_fin, (Object)this.r_fin, (Object)this.tailRot, (Object)this.tail, (Object)this.tail_l_fin, (Object)this.tail_r_fin, (Object)this.tailFinRot, (Object)this.tail_fin, (Object[])new ModelPart[0]);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

