/*
 * Decompiled with CFR 0.152.
 */
package net.thevaliantsquidward.rainbowreef.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.phys.Vec3;
import net.thevaliantsquidward.rainbowreef.entity.TangEntity;
import net.thevaliantsquidward.rainbowreef.entity.ai.goalz.CustomizableRandomSwimGoal;
import net.thevaliantsquidward.rainbowreef.entity.ai.goalz.FishDigGoal;
import net.thevaliantsquidward.rainbowreef.entity.base.VariantSchoolingFish;
import net.thevaliantsquidward.rainbowreef.entity.interfaces.VariantEntity;
import net.thevaliantsquidward.rainbowreef.registry.ReefEntities;
import net.thevaliantsquidward.rainbowreef.registry.ReefItems;
import net.thevaliantsquidward.rainbowreef.util.RRTags;

public class ButterfishEntity
extends VariantSchoolingFish
implements Bucketable,
VariantEntity {
    public final AnimationState swimAnimationState = new AnimationState();
    public final AnimationState landAnimationState = new AnimationState();
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(ButterfishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(ButterfishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public static String getVariantName(int variant) {
        return switch (variant) {
            case 1 -> "easterisland";
            case 2 -> "threadfin";
            case 3 -> "banner";
            case 4 -> "bluecheek";
            case 5 -> "longnose";
            case 6 -> "spotfin";
            case 7 -> "hooded";
            case 8 -> "arabic";
            case 9 -> "pyramid";
            case 10 -> "redsea";
            case 11 -> "sixspined";
            case 12 -> "darklongnose";
            case 13 -> "saddleback";
            case 14 -> "african";
            case 15 -> "eritrean";
            case 16 -> "marginated";
            case 17 -> "thompson";
            case 18 -> "mullers";
            case 19 -> "wroughtiron";
            case 20 -> "foureye";
            default -> "copperbanded";
        };
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return !this.m_27487_() && !this.m_8077_();
    }

    @Override
    public int getMaxSchoolSize() {
        return 10;
    }

    @Override
    public void m_8119_() {
        if (!this.m_20069_() && this.m_20096_() && this.f_19863_) {
            this.m_20334_(0.0, 0.0, 0.0);
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f)));
            this.m_6853_(false);
            this.f_19812_ = true;
            this.m_5496_(SoundEvents.f_11760_, this.m_6121_(), this.m_6100_());
        }
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        this.swimAnimationState.m_246184_(this.m_20072_(), this.f_19797_);
        this.landAnimationState.m_246184_(!this.m_20072_(), this.f_19797_);
    }

    @Override
    public int variant() {
        return this.getVariant();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    @Nonnull
    public ItemStack m_28282_() {
        ItemStack stack = new ItemStack((ItemLike)ReefItems.BUTTERFISH_BUCKET.get());
        if (this.m_8077_()) {
            stack.m_41714_(this.m_7770_());
        }
        return stack;
    }

    public void m_6872_(@Nonnull ItemStack bucket) {
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
        Bucketable.m_148822_((Mob)this, (ItemStack)bucket);
        CompoundTag compoundnbt = bucket.m_41784_();
        compoundnbt.m_128405_("BucketVariantTag", this.getVariant());
    }

    public void m_142278_(@Nonnull CompoundTag compound) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)compound);
        if (compound.m_128425_("BucketVariantTag", 3)) {
            this.setVariant(compound.m_128451_("BucketVariantTag"));
        }
    }

    @Nonnull
    protected InteractionResult m_6071_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        return Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.m_6071_(player, hand));
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
        compound.m_128379_("FromBucket", this.m_27487_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        this.m_27497_(compound.m_128471_("FromBucket"));
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean p_203706_1_) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)p_203706_1_);
    }

    @Nonnull
    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    public static <T extends Mob> boolean canSpawn(EntityType<ButterfishEntity> p_223364_0_, LevelAccessor p_223364_1_, MobSpawnType reason, BlockPos p_223364_3_, RandomSource p_223364_4_) {
        return WaterAnimal.m_218282_(p_223364_0_, (LevelAccessor)p_223364_1_, (MobSpawnType)reason, (BlockPos)p_223364_3_, (RandomSource)p_223364_4_);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        float variantChange = this.m_217043_().m_188501_();
        float rare = this.m_217043_().m_188501_();
        float rareVariantChange = this.m_217043_().m_188501_();
        Holder holder = worldIn.m_204166_(this.m_20183_());
        if (holder.m_203565_(Biomes.f_220595_)) {
            if ((double)variantChange <= 0.5) {
                this.setVariant(11);
            } else {
                this.setVariant(20);
            }
        } else if ((double)rare <= 0.1) {
            if (rareVariantChange <= 0.5f) {
                this.setVariant(1);
            } else {
                this.setVariant(12);
            }
        } else if (variantChange <= 0.05f) {
            this.setVariant(2);
        } else if (variantChange <= 0.1f) {
            this.setVariant(3);
        } else if (variantChange <= 0.15f) {
            this.setVariant(4);
        } else if (variantChange <= 0.2f) {
            this.setVariant(5);
        } else if (variantChange <= 0.25f) {
            this.setVariant(6);
        } else if (variantChange <= 0.3f) {
            this.setVariant(7);
        } else if (variantChange <= 0.35f) {
            this.setVariant(8);
        } else if (variantChange <= 0.4f) {
            this.setVariant(9);
        } else if (variantChange <= 0.45f) {
            this.setVariant(10);
        } else if (variantChange <= 0.5f) {
            this.setVariant(13);
        } else if (variantChange <= 0.55f) {
            this.setVariant(14);
        } else if (variantChange <= 0.6f) {
            this.setVariant(15);
        } else if (variantChange <= 0.65f) {
            this.setVariant(16);
        } else if (variantChange <= 0.7f) {
            this.setVariant(17);
        } else if (variantChange <= 0.75f) {
            this.setVariant(18);
        } else if (variantChange <= 0.8f) {
            this.setVariant(19);
        } else if (variantChange <= 0.85f) {
            this.setVariant(20);
        } else {
            this.setVariant(0);
        }
        if ((double)this.m_217043_().m_188501_() >= 0.8 && (reason == MobSpawnType.CHUNK_GENERATION || reason == MobSpawnType.NATURAL)) {
            float schoolsize = this.m_217043_().m_188501_();
            int schoolcount = (int)((float)this.getMaxSchoolSize() * schoolsize);
            if (schoolcount > 0 && !this.m_9236_().m_5776_()) {
                for (int i = 0; i < schoolcount; ++i) {
                    TangEntity urine = new TangEntity((EntityType<? extends VariantSchoolingFish>)((EntityType)ReefEntities.BUTTERFISH.get()), this.m_9236_());
                    urine.setVariant(this.getVariant());
                    urine.m_6027_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    urine.startFollowing(this);
                    this.m_9236_().m_7967_((Entity)urine);
                }
            }
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public ButterfishEntity(EntityType<? extends VariantSchoolingFish> pEntityType, Level pLevel) {
        super(pEntityType, pLevel, 600);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 1000, 30, 0.02f, 0.1f, false);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 15);
    }

    public boolean m_20068_() {
        return this.m_20069_();
    }

    protected PathNavigation m_6037_(Level p_27480_) {
        return new WaterBoundPathNavigation((Mob)this, p_27480_);
    }

    public static AttributeSupplier setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 1.0).m_22265_();
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FishDigGoal(this, 15, RRTags.BUTTERFLY_DIET));
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(0, (Goal)new CustomizableRandomSwimGoal((PathfinderMob)this, 0.9, 1, 20, 20, 3, false));
    }

    @Override
    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_204029_(FluidTags.f_13131_) && this.m_21691_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.001, 0.0));
        }
        super.m_7023_(pTravelVector);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12526_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12527_;
    }

    protected SoundEvent m_7975_(DamageSource p_28281_) {
        return SoundEvents.f_12529_;
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.f_12528_;
    }
}

