/*
 * Decompiled with CFR 0.152.
 */
package net.thevaliantsquidward.rainbowreef.entity;

import java.time.LocalDate;
import java.time.Month;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.thevaliantsquidward.rainbowreef.entity.ai.goalz.ConditionalStopGoal;
import net.thevaliantsquidward.rainbowreef.entity.ai.goalz.CrabBottomWander;
import net.thevaliantsquidward.rainbowreef.entity.ai.goalz.CrabFindWater;
import net.thevaliantsquidward.rainbowreef.entity.ai.goalz.CrabLeaveWater;
import net.thevaliantsquidward.rainbowreef.entity.ai.goalz.CrabPathfinder;
import net.thevaliantsquidward.rainbowreef.entity.ai.goalz.FishDigGoal;
import net.thevaliantsquidward.rainbowreef.entity.base.DancingEntity;
import net.thevaliantsquidward.rainbowreef.entity.interfaces.DancesToJukebox;
import net.thevaliantsquidward.rainbowreef.registry.ReefItems;
import net.thevaliantsquidward.rainbowreef.util.RRTags;
import org.jetbrains.annotations.Nullable;

public class CrabEntity
extends DancingEntity
implements Bucketable,
DancesToJukebox {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(CrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(CrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState danceAnimationState = new AnimationState();

    public CrabEntity(EntityType<? extends DancingEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
        if (this.isDancing() && this.getJukeboxPos() != null) {
            this.m_21563_().m_24964_(this.getJukeboxPos().m_252807_());
        }
    }

    private void setupAnimationStates() {
        this.idleAnimationState.m_246184_(this.m_6084_() && !this.isDancing(), this.f_19797_);
        this.danceAnimationState.m_246184_(this.isDancing(), this.f_19797_);
    }

    @Nonnull
    public ItemStack m_28282_() {
        ItemStack stack = new ItemStack((ItemLike)ReefItems.CRAB_BUCKET.get());
        if (this.m_8077_()) {
            stack.m_41714_(this.m_7770_());
        }
        return stack;
    }

    public void m_6872_(@Nonnull ItemStack bucket) {
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
        Bucketable.m_148822_((Mob)this, (ItemStack)bucket);
        CompoundTag compoundnbt = bucket.m_41784_();
        compoundnbt.m_128405_("BucketVariantTag", this.getVariant());
    }

    public void m_142278_(@Nonnull CompoundTag compound) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)compound);
        if (compound.m_128425_("BucketVariantTag", 3)) {
            this.setVariant(compound.m_128451_("BucketVariantTag"));
        }
    }

    @Nonnull
    public InteractionResult m_6071_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        return Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.m_6071_(player, hand));
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
        compound.m_128379_("FromBucket", this.m_27487_());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        this.m_27497_(compound.m_128471_("FromBucket"));
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean p_203706_1_) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)p_203706_1_);
    }

    @Nonnull
    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    public static String getVariantName(int variant) {
        return switch (variant) {
            case 1 -> "halloween";
            case 2 -> "ghost";
            case 3 -> "sally";
            case 4 -> "emerald";
            case 5 -> "blue";
            case 6 -> "purple";
            case 7 -> "candy";
            case 8 -> "redghost";
            default -> "vampire";
        };
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return !this.m_27487_() && !this.m_8077_();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @javax.annotation.Nullable SpawnGroupData spawnDataIn, @javax.annotation.Nullable CompoundTag dataTag) {
        Holder holder = worldIn.m_204166_(this.m_20183_());
        float spookyVariantChange = this.m_217043_().m_188501_();
        LocalDate currentDate = LocalDate.now();
        float variantChange = this.m_217043_().m_188501_();
        if (currentDate.getMonth() == Month.OCTOBER && currentDate.getDayOfMonth() == 31) {
            if ((double)spookyVariantChange <= 0.33) {
                this.setVariant(1);
            } else if ((double)spookyVariantChange <= 0.66) {
                this.setVariant(2);
            } else if ((double)spookyVariantChange <= 0.1) {
                this.setVariant(8);
            } else {
                this.setVariant(0);
            }
        } else if (holder.m_203565_(Biomes.f_220595_)) {
            this.setVariant(1);
        } else if (holder.m_203565_(Biomes.f_48217_) && (double)variantChange <= 0.1) {
            this.setVariant(8);
        } else if (holder.m_203565_(Biomes.f_48217_) && (double)variantChange > 0.1) {
            this.setVariant(2);
        } else if (holder.m_203565_(Biomes.f_186760_)) {
            this.setVariant(3);
        } else if (holder.m_203565_(Biomes.f_48167_) || holder.m_203565_(Biomes.f_48170_)) {
            this.setVariant(4);
        } else if (holder.m_203565_(Biomes.f_48174_) || holder.m_203565_(Biomes.f_48225_)) {
            this.setVariant(5);
        } else if (holder.m_203565_(Biomes.f_48168_) || holder.m_203565_(Biomes.f_48171_)) {
            this.setVariant(6);
        } else if (holder.m_203565_(Biomes.f_48166_)) {
            this.setVariant(7);
        } else {
            this.setVariant(0);
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public static AttributeSupplier setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 2.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22284_, 2.0).m_22265_();
    }

    public boolean m_6040_() {
        return true;
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(0, (Goal)new ConditionalStopGoal(this){

            @Override
            public boolean m_8036_() {
                CrabEntity crab = (CrabEntity)this.getCreatura();
                return crab.isDancing();
            }

            @Override
            public boolean m_8045_() {
                CrabEntity crab = (CrabEntity)this.getCreatura();
                return crab.isDancing();
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new FishDigGoal(this, 120, RRTags.HOG_DIGGABLE));
        this.f_21345_.m_25352_(1, (Goal)new CrabFindWater((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new CrabLeaveWater((PathfinderMob)this));
        this.f_21345_.m_25352_(3, (Goal)new CrabBottomWander((PathfinderMob)this, 1.0, 10, 50));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected PathNavigation m_6037_(Level worldIn) {
        CrabPathfinder crab = new CrabPathfinder((Mob)this, worldIn){

            @Override
            public boolean m_6342_(BlockPos pos) {
                return this.f_26495_.m_8055_(pos).m_60819_().m_76178_();
            }
        };
        return crab;
    }

    @Override
    public void m_7023_(Vec3 travelVector) {
        if (this.isDancing()) {
            travelVector = Vec3.f_82478_;
        }
        if (this.m_21515_() && this.m_20069_() && !this.isDancing()) {
            this.m_19920_(this.m_6113_(), travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            if (this.f_20899_) {
                this.m_20256_(this.m_20184_().m_82490_(1.4));
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.72, 0.0));
            } else {
                this.m_20256_(this.m_20184_().m_82490_(0.4));
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.08, 0.0));
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12526_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12527_;
    }

    protected SoundEvent m_7975_(DamageSource p_28281_) {
        return SoundEvents.f_12529_;
    }

    public static <T extends Mob> boolean canSpawn(EntityType<CrabEntity> p_223364_0_, LevelAccessor levelAccessor, MobSpawnType reason, BlockPos p_223364_3_, RandomSource p_223364_4_) {
        return !levelAccessor.m_8055_(p_223364_3_).m_280296_();
    }
}

