/*
 * Decompiled with CFR 0.152.
 */
package net.thevaliantsquidward.rainbowreef.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.thevaliantsquidward.rainbowreef.entity.ai.goalz.CustomizableRandomSwimGoal;
import net.thevaliantsquidward.rainbowreef.entity.base.RRMob;
import net.thevaliantsquidward.rainbowreef.entity.interfaces.kinematics.IKSolver;
import net.thevaliantsquidward.rainbowreef.entity.pathing.AdvancedWaterboundPathNavigation;
import net.thevaliantsquidward.rainbowreef.util.RRTags;

public class EelEntity
extends RRMob
implements Bucketable {
    public IKSolver tailKinematics;
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(EelEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(EelEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final AnimationState swimAnimationState = new AnimationState();
    public final AnimationState landAnimationState = new AnimationState();
    public final AnimationState breathAnimationState = new AnimationState();
    public final AnimationState noBreathAnimationState = new AnimationState();

    public EelEntity(EntityType<? extends WaterAnimal> entityType, Level level) {
        super(entityType, level, Integer.MAX_VALUE);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 100, 4, 0.02f, 0.1f, false);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 4);
        this.tailKinematics = new IKSolver((LivingEntity)this, 4, 0.3, 0.5, true, false);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.tailKinematics.TakePerTickAction((LivingEntity)this);
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    @Override
    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_204029_(FluidTags.f_13131_) && !this.m_21691_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.01, 0.0));
        }
        super.m_7023_(pTravelVector);
    }

    private void setupAnimationStates() {
        this.swimAnimationState.m_246184_(this.m_6084_() && this.m_20072_(), this.f_19797_);
        this.landAnimationState.m_246184_(this.m_6084_() && !this.m_20072_(), this.f_19797_);
        this.breathAnimationState.m_246184_(this.m_6084_() && this.m_20072_(), this.f_19797_);
    }

    public boolean m_20068_() {
        return this.m_20069_();
    }

    protected PathNavigation m_6037_(Level p_27480_) {
        return new AdvancedWaterboundPathNavigation((Mob)this, p_27480_, true, false);
    }

    public static String getVariantName(int variant) {
        return switch (variant) {
            case 1 -> "green";
            case 2 -> "dragon";
            case 3 -> "laced";
            case 4 -> "fimbriated";
            case 5 -> "japanese_dragon";
            case 6 -> "mud";
            case 7 -> "fresh";
            default -> "green";
        };
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return !this.m_27487_() && !this.m_8077_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    public void m_6872_(@Nonnull ItemStack bucket) {
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
        Bucketable.m_148822_((Mob)this, (ItemStack)bucket);
        CompoundTag compoundnbt = bucket.m_41784_();
        compoundnbt.m_128405_("BucketVariantTag", this.getVariant());
    }

    public void m_142278_(@Nonnull CompoundTag compound) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)compound);
        if (compound.m_128425_("BucketVariantTag", 3)) {
            this.setVariant(compound.m_128451_("BucketVariantTag"));
        }
    }

    public ItemStack m_28282_() {
        return null;
    }

    @Nonnull
    protected InteractionResult m_6071_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        return Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.m_6071_(player, hand));
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    private void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
        compound.m_128379_("FromBucket", this.m_27487_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        this.m_27497_(compound.m_128471_("FromBucket"));
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean p_203706_1_) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)p_203706_1_);
    }

    public static <T extends Mob> boolean canSpawn(EntityType<EelEntity> p_223364_0_, LevelAccessor p_223364_1_, MobSpawnType reason, BlockPos p_223364_3_, RandomSource p_223364_4_) {
        return WaterAnimal.m_218282_(p_223364_0_, (LevelAccessor)p_223364_1_, (MobSpawnType)reason, (BlockPos)p_223364_3_, (RandomSource)p_223364_4_);
    }

    @Nonnull
    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        float variantChange = this.m_217043_().m_188501_();
        float aberrant = this.m_217043_().m_188501_();
        System.out.println(worldIn.m_204166_(this.m_20183_()));
        System.out.println(worldIn.m_204166_(this.m_20183_()).m_203656_(RRTags.EEL_FRESH));
        if (worldIn.m_204166_(this.m_20183_()).m_203656_(RRTags.EEL_FRESH)) {
            if ((double)variantChange < 0.5) {
                this.setVariant(6);
            } else {
                this.setVariant(7);
            }
        } else if (variantChange <= 0.25f) {
            this.setVariant(1);
        } else if (variantChange <= 0.5f) {
            if ((double)aberrant < 0.1) {
                this.setVariant(5);
            } else {
                this.setVariant(2);
            }
        } else if (variantChange <= 0.75f) {
            this.setVariant(3);
        } else {
            this.setVariant(4);
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public static AttributeSupplier setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 7.0).m_22268_(Attributes.f_22279_, 0.8).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(0, (Goal)new CustomizableRandomSwimGoal((PathfinderMob)this, 1.0, 200, 10, 10, 3, true));
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12526_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12527_;
    }

    protected SoundEvent m_7975_(DamageSource p_28281_) {
        return SoundEvents.f_12529_;
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.f_12528_;
    }
}

