/*
 * Decompiled with CFR 0.152.
 */
package net.thevaliantsquidward.rainbowreef.entity.ai.goalz;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;

public class GoalUtils {
    @Nullable
    public static Vec3 getRandomSwimmablePosWithSeabed(PathfinderMob pPathfinder, int pRadius, int pVerticalDistance) {
        Vec3 testPos = DefaultRandomPos.m_148403_((PathfinderMob)pPathfinder, (int)pRadius, (int)pVerticalDistance);
        int MaxSearchAmount = pRadius * pRadius * pRadius;
        for (int x = 0; testPos != null && x < MaxSearchAmount; ++x) {
            if (testPos != null) {
                Vec3 belowPos = testPos.m_82492_(0.0, 1.0, 0.0);
                if (pPathfinder.m_9236_().m_8055_(BlockPos.m_274446_((Position)belowPos)).m_60634_((BlockGetter)pPathfinder.m_9236_(), BlockPos.m_274446_((Position)testPos), (Entity)pPathfinder) && pPathfinder.m_9236_().m_8055_(BlockPos.m_274446_((Position)testPos)).m_60647_((BlockGetter)pPathfinder.m_9236_(), BlockPos.m_274446_((Position)testPos), PathComputationType.WATER)) {
                    return testPos;
                }
                if (x == MaxSearchAmount - 1) {
                    return testPos;
                }
            }
            testPos = DefaultRandomPos.m_148403_((PathfinderMob)pPathfinder, (int)pRadius, (int)pVerticalDistance);
        }
        return null;
    }

    @Nullable
    public static Vec3 getRandomSwimmablePosThatIsntTheSameDepth(PathfinderMob pPathfinder, int pRadius, int pVerticalDistance, boolean preferCrevices) {
        Level world = pPathfinder.m_9236_();
        int MaxSearchAmount = pRadius * pRadius * pRadius;
        BlockPos currentPos = null;
        int currentSolidSidesCount = 0;
        for (int i = 0; i < MaxSearchAmount; ++i) {
            Vec3 rand = DefaultRandomPos.m_148403_((PathfinderMob)pPathfinder, (int)pRadius, (int)pVerticalDistance);
            if (rand == null) continue;
            BlockPos seafloor = BlockPos.m_274446_((Position)rand);
            while (world.m_6425_(seafloor).m_205070_(FluidTags.f_13131_) && seafloor.m_123342_() > 1) {
                int tempSolidSidesCount = GoalUtils.countSolidSides(pPathfinder.m_9236_(), seafloor.m_123341_(), seafloor.m_123342_(), seafloor.m_123343_());
                if ((double)seafloor.m_123342_() != pPathfinder.m_20182_().m_7098_()) {
                    if (preferCrevices) {
                        if (tempSolidSidesCount > currentSolidSidesCount) {
                            currentPos = seafloor;
                            currentSolidSidesCount = tempSolidSidesCount;
                        }
                    } else {
                        return seafloor.m_252807_();
                    }
                }
                seafloor = seafloor.m_7495_();
            }
        }
        if (currentPos == null) {
            return null;
        }
        return currentPos.m_252807_();
    }

    public static int countSolidSides(Level level, double x, double y, double z) {
        BlockPos nodepos = new BlockPos((int)x, (int)y, (int)z);
        int end = 0;
        if (level.m_8055_(nodepos.m_7494_()).m_280296_()) {
            ++end;
        }
        if (level.m_8055_(nodepos.m_7495_()).m_280296_()) {
            ++end;
        }
        if (level.m_8055_(nodepos.m_122029_()).m_280296_()) {
            ++end;
        }
        if (level.m_8055_(nodepos.m_122024_()).m_280296_()) {
            ++end;
        }
        if (level.m_8055_(nodepos.m_122012_()).m_280296_()) {
            ++end;
        }
        if (level.m_8055_(nodepos.m_122019_()).m_280296_()) {
            ++end;
        }
        return end;
    }
}

