/*
 * Decompiled with CFR 0.152.
 */
package net.thevaliantsquidward.rainbowreef.entity.base.NemHoster;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.thevaliantsquidward.rainbowreef.blocks.AnemoneBlock;
import net.thevaliantsquidward.rainbowreef.entity.base.VariantSchoolingFish;
import net.thevaliantsquidward.rainbowreef.util.RRPOI;

public class NemHoster
extends VariantSchoolingFish {
    private static final EntityDataAccessor<BlockPos> HOME = SynchedEntityData.m_135353_(NemHoster.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    int nemSearchCooldown = 0;
    int maxNemSearchCD;
    int homeRadius;
    int restInterval;
    int restTime;

    public NemHoster(EntityType<? extends VariantSchoolingFish> pEntityType, Level pLevel, int searchCD, int homeRadius, int restInterval, int restTime) {
        super(pEntityType, pLevel, 200);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 1000, 60, 0.02f, 0.1f, false);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 4);
        this.maxNemSearchCD = searchCD;
        this.homeRadius = homeRadius;
        this.restInterval = restInterval;
        this.restTime = restTime;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HOME, (Object)new BlockPos(0, 0, 0));
    }

    @Override
    public void m_8119_() {
        this.reviewNem();
        if (this.nemSearchCooldown > 0) {
            --this.nemSearchCooldown;
        }
        super.m_8119_();
    }

    public void reviewNem() {
        BlockPos nemPos = this.getNemPos();
        if (nemPos != null && !(this.m_9236_().m_8055_(nemPos).m_60734_() instanceof AnemoneBlock)) {
            this.setNemPos(null);
            this.nemSearchCooldown = 0;
        }
    }

    public void setNemPos(BlockPos pos) {
        if (pos == null) {
            this.f_19804_.m_135381_(HOME, (Object)BlockPos.f_121853_);
        } else {
            this.f_19804_.m_135381_(HOME, (Object)pos);
        }
    }

    public BlockPos getNemPos() {
        if (this.f_19804_.m_135370_(HOME) == BlockPos.f_121853_) {
            return null;
        }
        return (BlockPos)this.f_19804_.m_135370_(HOME);
    }

    public boolean hasNem() {
        BlockPos nemPos = this.getNemPos();
        if (nemPos != null && !(this.m_9236_().m_8055_(nemPos).m_60734_() instanceof AnemoneBlock)) {
            this.setNemPos(null);
            this.findAndSetNems();
            return false;
        }
        return this.f_19804_.m_135370_(HOME) != BlockPos.f_121853_;
    }

    public boolean canSee(BlockPos pos) {
        Vec3 vec3 = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
        Vec3 vec31 = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        if (vec31.m_82554_(vec3) > 20.0) {
            return false;
        }
        return this.m_9236_().m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() == HitResult.Type.MISS;
    }

    public void findAndSetNems() {
        List<BlockPos> list = this.findNems();
        BlockPos closest = null;
        if (list.isEmpty()) {
            return;
        }
        for (BlockPos pos : list) {
            if (closest != null && !(this.m_20275_(closest.m_123341_(), closest.m_123342_(), closest.m_123343_()) > this.m_20275_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())) || !this.canSee(pos)) continue;
            closest = pos;
        }
        if (closest != null) {
            this.setNemPos(closest);
        }
    }

    public List<BlockPos> findNems() {
        BlockPos blockpos = this.m_20183_();
        PoiManager poimanager = ((ServerLevel)this.m_9236_()).m_8904_();
        Stream stream = poimanager.m_27181_(p_218130_ -> p_218130_.m_203565_(RRPOI.GREEN_NEM.getKey()) || p_218130_.m_203565_(RRPOI.ORANGE_NEM.getKey()) || p_218130_.m_203565_(RRPOI.YELLOW_NEM.getKey()), blockpos, 100, PoiManager.Occupancy.ANY);
        return stream.map(PoiRecord::m_27257_).sorted(Comparator.comparingDouble(p_148811_ -> p_148811_.m_123331_((Vec3i)blockpos))).collect(Collectors.toList());
    }
}

