/*
 * Decompiled with CFR 0.152.
 */
package net.thevaliantsquidward.rainbowreef.entity.base;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class RRMob
extends WaterAnimal {
    public float prevTilt;
    public float tilt;
    public int feedCDLim = 0;
    public int feedCD = 0;
    public SmoothSwimmingMoveControl feedingController = new SmoothSwimmingMoveControl((Mob)this, 1000, 10, 0.02f, 0.1f, false);

    protected RRMob(EntityType<? extends WaterAnimal> pEntityType, Level pLevel, int feedCooldown) {
        super(pEntityType, pLevel);
        this.feedCDLim = feedCooldown;
        this.setFeedCD(this.feedCDLim + this.m_217043_().m_188503_(this.feedCDLim));
    }

    public void setMoveControl(MoveControl newControl) {
        this.f_21342_ = newControl;
    }

    public void setFeedCD(int set) {
        this.feedCD = set;
    }

    public int getFeedCD() {
        return this.feedCD;
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevTilt = this.tilt;
        if (this.m_20069_()) {
            float v = Mth.m_14118_((float)this.m_146908_(), (float)this.f_19859_);
            if (Math.abs(v) > 1.0f) {
                if (Math.abs(this.tilt) < 25.0f) {
                    this.tilt -= Math.signum(v);
                }
            } else if (Math.abs(this.tilt) > 0.0f) {
                float tiltSign = Math.signum(this.tilt);
                this.tilt -= tiltSign * 0.85f;
                if (this.tilt * tiltSign < 0.0f) {
                    this.tilt = 0.0f;
                }
            }
        } else {
            this.tilt = 0.0f;
        }
        --this.feedCD;
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_204029_(FluidTags.f_13131_) && this.m_21691_() && this.checkFloat(this.m_20183_())) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.005 * this.m_21133_(Attributes.f_22279_), 0.0));
        }
        super.m_7023_(pTravelVector);
    }

    public void spawnEffectsAtBlock(BlockPos target) {
        float radius = 0.3f;
        for (int i1 = 0; i1 < 3; ++i1) {
            double motionX = this.m_217043_().m_188583_() * 0.07;
            double motionY = this.m_217043_().m_188583_() * 0.07;
            double motionZ = this.m_217043_().m_188583_() * 0.07;
            float angle = (float)(0.0174532925 * (double)this.f_20883_ + (double)i1);
            double extraX = radius * Mth.m_14031_((float)((float)Math.PI + angle));
            double extraY = 0.8f;
            double extraZ = radius * Mth.m_14089_((float)angle);
            BlockState state = this.m_9236_().m_8055_(target);
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), (double)target.m_123341_() + 0.5 + extraX, (double)target.m_123342_() + 0.5 + extraY, (double)target.m_123343_() + 0.5 + extraZ, 1, motionX, motionY, motionZ, 1.0);
        }
    }

    private int findSeafloorDist(BlockPos selfpos) {
        int depth = 0;
        if (!this.m_9236_().m_46859_(selfpos) && !this.m_9236_().m_6425_(selfpos).m_205070_(FluidTags.f_13131_)) {
            return Integer.MAX_VALUE;
        }
        while (this.m_9236_().m_6425_(selfpos).m_205070_(FluidTags.f_13131_) && selfpos.m_123342_() > 1) {
            selfpos = selfpos.m_7495_();
            ++depth;
        }
        return depth;
    }

    private boolean checkFloat(BlockPos selfpos) {
        int north = this.findSeafloorDist(selfpos.m_7494_().m_122012_());
        int south = this.findSeafloorDist(selfpos.m_7494_().m_122019_());
        int east = this.findSeafloorDist(selfpos.m_7494_().m_122029_());
        int west = this.findSeafloorDist(selfpos.m_7494_().m_122024_());
        return north <= 1 || south <= 1 || east <= 1 || west <= 1;
    }
}

