/*
 * Decompiled with CFR 0.152.
 */
package net.thevaliantsquidward.rainbowreef.entity.interfaces.kinematics;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.thevaliantsquidward.rainbowreef.util.MathHelpers;

public class IKSolver {
    public Vec3 prevPos = new Vec3(0.0, 0.0, 0.0);
    public Vec3 nowPos = new Vec3(0.0, 0.0, 0.0);
    public float prevPitch = 0.0f;
    public float pitch = 0.0f;
    public boolean tailHasGravity = false;
    public boolean canReturnToCenter = false;
    public double vertLimPercentage;
    public double prevYHeadRot = 0.0;
    public double deltaYHeadRot = 0.0;
    public boolean prevHasFlipped = false;
    private final LivingEntity entity;
    private final int nodeCount;
    private final double nodeHitboxRadius;
    private final double stiffness = 60.0;
    private Vec3[] nodes = new Vec3[0];
    private Vec3[] coreNodes = new Vec3[0];
    private double nodeDist;
    private int bodyLength;
    private double bodyPitch = 0.0;
    private double currentBodyPitch = 0.0;
    private double[] tailYaws = new double[0];
    private double[] tailPitches = new double[0];
    private double[] currentTailYaws = new double[0];
    private double[] currentTailPitches = new double[0];
    private Vec3 torsoFront;
    private Vec3 torsoFrontOffset = new Vec3(0.0, 0.0, -1.0);
    private Vec3 torsoBack;
    private Vec3 torsoBackOffset = new Vec3(0.0, 0.0, 1.0);
    private Vec3 rightRefPoint;
    private Vec3 rightRefOffset = new Vec3(1.0, 0.0, 0.0);
    private Vec3 leftRefPoint;
    private Vec3 leftRefOffset = new Vec3(-1.0, 0.0, 0.0);
    private Vec3 upRefPoint;
    private final Vec3 upRefOffset = new Vec3(0.0, -1.0, 0.0);
    private Vec3 downRefPoint;
    private final Vec3 downRefOffset = new Vec3(0.0, 1.0, 0.0);
    private Boolean shiftNodes = false;

    public IKSolver(LivingEntity entity, int nodeCount, double nodeDist, double VertLimPercentage, boolean tailHasGravity, boolean returnToCenter) {
        this.entity = entity;
        this.nodeCount = nodeCount;
        this.nodeDist = nodeDist;
        this.nodeHitboxRadius = nodeDist * 0.9;
        this.tailHasGravity = tailHasGravity;
        this.canReturnToCenter = returnToCenter;
        this.vertLimPercentage = VertLimPercentage;
        this.nodes = new Vec3[nodeCount];
        this.tailYaws = new double[nodeCount];
        this.tailPitches = new double[nodeCount];
        this.currentTailYaws = new double[nodeCount];
        this.currentTailPitches = new double[nodeCount];
        this.torsoFrontOffset = this.torsoFrontOffset.m_82542_(1.0, 1.0, nodeDist);
        this.torsoBackOffset = this.torsoBackOffset.m_82542_(1.0, 1.0, nodeDist);
        this.leftRefPoint = MathHelpers.rotateAroundCenterFlatDeg(entity.m_20182_(), entity.m_20182_().m_82546_(this.leftRefOffset), Double.valueOf(-entity.m_146908_()));
        this.rightRefPoint = MathHelpers.rotateAroundCenterFlatDeg(entity.m_20182_(), entity.m_20182_().m_82546_(this.rightRefOffset), Double.valueOf(-entity.m_146908_()));
        this.upRefPoint = MathHelpers.rotateAroundCenterFlatDeg(entity.m_20182_(), entity.m_20182_().m_82546_(this.upRefOffset), Double.valueOf(-entity.m_146908_()));
        this.downRefPoint = MathHelpers.rotateAroundCenterFlatDeg(entity.m_20182_(), entity.m_20182_().m_82546_(this.downRefOffset), Double.valueOf(-entity.m_146908_()));
        this.torsoFront = MathHelpers.rotateAroundCenterFlatDeg(entity.m_20182_(), entity.m_20182_().m_82546_(this.torsoFrontOffset), Double.valueOf(-entity.m_146908_()));
        this.torsoBack = MathHelpers.rotateAroundCenterFlatDeg(entity.m_20182_(), entity.m_20182_().m_82546_(this.torsoBackOffset), Double.valueOf(-entity.m_146908_()));
        this.initTailPoints();
    }

    public IKSolver(LivingEntity entity, int nodeCount, int nodeDist, boolean shiftNodes, boolean tailHasGravity) {
        this.entity = entity;
        this.nodeCount = nodeCount;
        this.nodeDist = nodeDist;
        this.nodeHitboxRadius = (double)nodeDist - 0.2;
        this.nodes = new Vec3[nodeCount];
        this.coreNodes = new Vec3[nodeCount];
        this.tailYaws = new double[nodeCount];
        this.tailPitches = new double[nodeCount];
        this.currentTailYaws = new double[nodeCount];
        this.currentTailPitches = new double[nodeCount];
        this.leftRefPoint = MathHelpers.rotateAroundCenterFlatDeg(entity.m_20182_(), entity.m_20182_().m_82546_(this.leftRefOffset), Double.valueOf(-entity.m_146908_()));
        this.rightRefPoint = MathHelpers.rotateAroundCenterFlatDeg(entity.m_20182_(), entity.m_20182_().m_82546_(this.rightRefOffset), Double.valueOf(-entity.m_146908_()));
        this.upRefPoint = MathHelpers.rotateAroundCenterFlatDeg(entity.m_20182_(), entity.m_20182_().m_82546_(this.upRefOffset), Double.valueOf(-entity.m_146908_()));
        this.downRefPoint = MathHelpers.rotateAroundCenterFlatDeg(entity.m_20182_(), entity.m_20182_().m_82546_(this.downRefOffset), Double.valueOf(-entity.m_146908_()));
        this.torsoFront = MathHelpers.rotateAroundCenterFlatDeg(entity.m_20182_(), entity.m_20182_().m_82546_(this.torsoFrontOffset), Double.valueOf(-entity.m_146908_()));
        this.torsoBack = MathHelpers.rotateAroundCenterFlatDeg(entity.m_20182_(), entity.m_20182_().m_82546_(this.torsoBackOffset), Double.valueOf(-entity.m_146908_()));
        if (shiftNodes) {
            this.torsoFrontOffset = new Vec3(0.0, -1.0, -1.0);
            this.torsoBackOffset = new Vec3(0.0, -1.0, 1.0);
            this.shiftNodes = true;
        }
        this.initTailPoints();
    }

    public void TakePerTickAction(LivingEntity entity) {
        this.prevPos = this.nowPos;
        this.nowPos = this.entity.m_20182_();
        if (entity.f_19797_ <= 1) {
            this.initTailPoints();
        }
        this.calculateTailAngles(entity);
    }

    public void initTailPoints() {
        this.torsoFront = MathHelpers.rotateAroundCenter3dDeg(this.nowPos, this.nowPos.m_82546_(this.torsoFrontOffset), -this.entity.m_146908_(), -this.pitch);
        this.torsoBack = MathHelpers.rotateAroundCenter3dDeg(this.nowPos, this.nowPos.m_82546_(this.torsoBackOffset), -this.entity.m_146908_(), this.prevPitch);
        Vec3 diff = this.torsoBack.m_82546_(this.torsoFront);
        this.nodes[0] = this.torsoBack.m_82549_(diff);
        for (int i = 1; i < this.nodeCount; ++i) {
            this.nodes[i] = this.torsoBack.m_82549_(diff.m_82542_((double)(i + 1), 1.0, (double)(i + 1)));
        }
    }

    public void calculateTailAngles(LivingEntity entity) {
        int i;
        this.torsoFront = MathHelpers.rotateAroundCenter3dDeg(entity.m_20182_(), entity.m_20182_().m_82546_(this.torsoFrontOffset), -entity.m_146908_(), -entity.m_146909_());
        this.torsoBack = MathHelpers.rotateAroundCenter3dDeg(entity.m_20182_(), entity.m_20182_().m_82546_(this.torsoBackOffset), -entity.m_146908_(), -entity.m_146909_());
        this.nodes[0] = MathHelpers.distConstraintSingle(this.torsoBack, this.nodes[0], this.nodeDist, this.vertLimPercentage);
        float angleY = (float)(57.2957763671875 * MathHelpers.getAngleForLinkTopDownFlat(this.torsoFront, this.torsoBack, this.nodes[0], this.leftRefPoint, this.rightRefPoint));
        this.nodes[0] = MathHelpers.quickReturn(entity.m_9236_(), this.torsoBack, this.nodes[0], angleY, 1.0f, this.tailHasGravity, this.canReturnToCenter);
        this.nodes[0] = MathHelpers.driveAway(this.torsoFront, this.nodes[0], entity.m_20191_().m_82362_(), false);
        this.nodes[0] = MathHelpers.driveAway(entity.m_20182_(), this.nodes[0], entity.m_20191_().m_82362_(), false);
        this.nodes[0] = MathHelpers.driveAway(this.torsoBack, this.nodes[0], this.nodeHitboxRadius, false);
        this.nodes[1] = MathHelpers.distConstraintSingle(this.nodes[0], this.nodes[1], this.nodeDist, this.vertLimPercentage);
        angleY = (float)(57.2957763671875 * MathHelpers.getAngleForLinkTopDownFlat(this.torsoBack, this.nodes[0], this.nodes[1], this.leftRefPoint, this.rightRefPoint));
        this.nodes[1] = MathHelpers.quickReturn(entity.m_9236_(), this.nodes[0], this.nodes[1], angleY, 2.0f, this.tailHasGravity, this.canReturnToCenter);
        this.nodes[1] = MathHelpers.driveAway(this.torsoFront, this.nodes[1], entity.m_20191_().m_82362_(), false);
        this.nodes[1] = MathHelpers.driveAway(entity.m_20182_(), this.nodes[1], entity.m_20191_().m_82362_(), false);
        this.nodes[1] = MathHelpers.driveAway(this.torsoBack, this.nodes[1], this.nodeHitboxRadius, false);
        this.nodes[1] = MathHelpers.driveAway(this.nodes[0], this.nodes[1], this.nodeHitboxRadius, false);
        for (i = 2; i < this.nodeCount; ++i) {
            this.nodes[i] = this.shiftNodes != false ? this.nodes[i].m_82492_(0.0, -1.0, 0.0) : this.nodes[i];
            this.nodes[i] = MathHelpers.distConstraintSingle(this.nodes[i - 1], this.nodes[i], this.nodeDist, this.vertLimPercentage);
            angleY = (float)(57.2957763671875 * MathHelpers.getAngleForLinkTopDownFlat(this.nodes[i - 2], this.nodes[i - 1], this.nodes[i], this.leftRefPoint, this.rightRefPoint));
            this.nodes[i] = MathHelpers.quickReturn(entity.m_9236_(), this.nodes[i - 1], this.nodes[i], angleY, 2.0f, this.tailHasGravity, this.canReturnToCenter);
            this.nodes[i] = MathHelpers.driveAway(this.torsoFront, this.nodes[i], entity.m_20191_().m_82362_(), false);
            this.nodes[i] = MathHelpers.driveAway(entity.m_20182_(), this.nodes[i], entity.m_20191_().m_82362_(), false);
            this.nodes[i] = MathHelpers.driveAway(this.torsoBack, this.nodes[i], this.nodeHitboxRadius, false);
            int x = 0;
            while (i < i) {
                this.nodes[i] = MathHelpers.driveAway(this.nodes[x], this.nodes[i], this.nodeHitboxRadius, false);
                ++i;
            }
        }
        this.tailYaws[0] = Math.toRadians(MathHelpers.angleTo((Vec3)this.torsoFront, (Vec3)this.torsoBack).f_82471_ - MathHelpers.angleTo((Vec3)this.torsoBack, (Vec3)this.nodes[0]).f_82471_);
        this.tailYaws[1] = Math.toRadians(MathHelpers.angleTo((Vec3)this.torsoBack, (Vec3)this.nodes[0]).f_82471_ - MathHelpers.angleTo((Vec3)this.nodes[0], (Vec3)this.nodes[1]).f_82471_);
        for (i = 2; i < this.nodes.length - 1; ++i) {
            this.tailYaws[i] = Math.toRadians(MathHelpers.angleTo((Vec3)this.nodes[i - 2], (Vec3)this.nodes[i - 1]).f_82471_ - MathHelpers.angleTo((Vec3)this.nodes[i - 1], (Vec3)this.nodes[i]).f_82471_);
        }
        this.tailPitches[0] = MathHelpers.angleFromYdiff(this.torsoFront, this.torsoBack, this.nodes[0]);
        this.tailPitches[1] = MathHelpers.angleFromYdiff(this.torsoBack, this.nodes[0], this.nodes[1]);
        for (i = 2; i < this.nodes.length - 1; ++i) {
            this.tailPitches[i] = MathHelpers.angleFromYdiff(this.nodes[i - 2], this.nodes[i - 1], this.nodes[i]);
        }
        this.leftRefPoint = MathHelpers.rotateAroundCenterFlatDeg(entity.m_20182_(), this.entity.m_20182_().m_82546_(this.leftRefOffset), Double.valueOf(-entity.m_146908_()));
        this.rightRefPoint = MathHelpers.rotateAroundCenterFlatDeg(entity.m_20182_(), this.entity.m_20182_().m_82546_(this.rightRefOffset), Double.valueOf(-entity.m_146908_()));
        this.upRefPoint = MathHelpers.rotateAroundCenterFlatDeg(entity.m_20182_(), this.entity.m_20182_().m_82546_(this.upRefOffset), Double.valueOf(-entity.m_146908_()));
        this.downRefPoint = MathHelpers.rotateAroundCenterFlatDeg(entity.m_20182_(), this.entity.m_20182_().m_82546_(this.downRefOffset), Double.valueOf(-entity.m_146908_()));
    }

    public void calculateTailAnglesNoConstraint(LivingEntity entity) {
        int i;
        this.prevPitch = this.pitch;
        this.pitch = MathHelpers.pitchProcess(this.nowPos, this.prevPos);
        this.torsoFront = MathHelpers.rotateAroundCenter3dDeg(entity.m_20182_(), entity.m_20182_().m_82546_(this.torsoFrontOffset), -entity.m_146908_(), 57.295776f * this.pitch);
        this.torsoBack = MathHelpers.rotateAroundCenter3dDeg(entity.m_20182_(), entity.m_20182_().m_82546_(this.torsoBackOffset), -entity.m_146908_(), 57.295776f * this.prevPitch);
        this.nodes[0] = MathHelpers.distConstraintSingle(this.torsoBack, this.nodes[0], this.nodeDist, this.vertLimPercentage);
        for (i = 1; i < this.nodeCount; ++i) {
            this.nodes[i] = MathHelpers.distConstraintSingle(this.nodes[i - 1], this.nodes[i], this.nodeDist, this.vertLimPercentage);
        }
        for (int x = this.nodeCount - 1; x >= 0; --x) {
            if (x == 0) {
                this.nodes[x] = MathHelpers.driveAway(this.torsoFront, this.nodes[x], entity.m_20191_().m_82362_(), false);
                this.nodes[x] = MathHelpers.driveAway(entity.m_20182_(), this.nodes[x], entity.m_20191_().m_82362_(), false);
                this.nodes[x] = MathHelpers.driveAway(this.torsoBack, this.nodes[x], this.nodeHitboxRadius, false);
                break;
            }
            this.nodes[x] = MathHelpers.driveAway(this.torsoFront, this.nodes[x], entity.m_20191_().m_82362_(), false);
            this.nodes[x] = MathHelpers.driveAway(entity.m_20182_(), this.nodes[x], entity.m_20191_().m_82362_(), false);
            this.nodes[x] = MathHelpers.driveAway(this.torsoBack, this.nodes[x], this.nodeHitboxRadius, false);
            for (int i2 = 0; i2 < x; ++i2) {
                this.nodes[x] = MathHelpers.driveAway(this.nodes[i2], this.nodes[x], this.nodeHitboxRadius, false);
            }
        }
        this.nodes[0] = MathHelpers.distConstraintSingle(this.torsoBack, this.nodes[0], this.nodeDist, this.vertLimPercentage);
        for (i = 1; i < this.nodeCount; ++i) {
            this.nodes[i] = MathHelpers.distConstraintSingle(this.nodes[i - 1], this.nodes[i], this.nodeDist, this.vertLimPercentage);
        }
        this.tailYaws[0] = Math.toRadians(MathHelpers.angleTo((Vec3)this.torsoFront, (Vec3)this.torsoBack).f_82471_ - MathHelpers.angleTo((Vec3)this.torsoBack, (Vec3)this.nodes[0]).f_82471_);
        this.tailYaws[1] = Math.toRadians(MathHelpers.angleTo((Vec3)this.torsoBack, (Vec3)this.nodes[0]).f_82471_ - MathHelpers.angleTo((Vec3)this.nodes[0], (Vec3)this.nodes[1]).f_82471_);
        for (i = 2; i < this.nodes.length - 1; ++i) {
            this.tailYaws[i] = Math.toRadians(MathHelpers.angleTo((Vec3)this.nodes[i - 2], (Vec3)this.nodes[i - 1]).f_82471_ - MathHelpers.angleTo((Vec3)this.nodes[i - 1], (Vec3)this.nodes[i]).f_82471_);
        }
        this.tailPitches[0] = MathHelpers.angleFromYdiff(this.torsoFront, this.torsoBack, this.nodes[0]);
        this.tailPitches[1] = MathHelpers.angleFromYdiff(this.torsoBack, this.nodes[0], this.nodes[1]);
        for (i = 2; i < this.nodes.length - 1; ++i) {
            this.tailPitches[i] = MathHelpers.angleFromYdiff(this.nodes[i - 2], this.nodes[i - 1], this.nodes[i]);
        }
        this.leftRefPoint = MathHelpers.rotateAroundCenterFlatDeg(entity.m_20182_(), this.entity.m_20182_().m_82546_(this.leftRefOffset), Double.valueOf(-entity.m_146908_()));
        this.rightRefPoint = MathHelpers.rotateAroundCenterFlatDeg(entity.m_20182_(), this.entity.m_20182_().m_82546_(this.rightRefOffset), Double.valueOf(-entity.m_146908_()));
        this.upRefPoint = MathHelpers.rotateAroundCenterFlatDeg(entity.m_20182_(), this.entity.m_20182_().m_82546_(this.upRefOffset), Double.valueOf(-entity.m_146908_()));
        this.downRefPoint = MathHelpers.rotateAroundCenterFlatDeg(entity.m_20182_(), this.entity.m_20182_().m_82546_(this.downRefOffset), Double.valueOf(-entity.m_146908_()));
    }

    private boolean isSuspectedCompletedRotation(float lastRotation) {
        float rotations = Mth.m_14154_((float)(lastRotation / 1.5707964f));
        float partialRotation = 1.0f - (rotations - (float)((int)rotations));
        return (double)partialRotation < 0.026 * (double)rotations;
    }

    public double[] getTailYaws() {
        return this.tailYaws;
    }

    public double[] getTailPitches() {
        return this.tailPitches;
    }

    public double[] getCurrentTailYaws() {
        return this.currentTailYaws;
    }

    public double[] getCurrentTailPitches() {
        return this.currentTailPitches;
    }

    public double getBodyPitch() {
        return this.bodyPitch;
    }

    public double getCurrentBodyPitch() {
        return this.currentBodyPitch;
    }

    public void visualizeNodes(Level level) {
        boolean viewOffset = true;
        level.m_7107_((ParticleOptions)ParticleTypes.f_123772_, this.torsoFront.f_82479_, this.torsoFront.f_82480_ + (double)viewOffset, this.torsoFront.f_82481_, 0.0, 0.0, 0.0);
        level.m_7107_((ParticleOptions)ParticleTypes.f_123772_, this.torsoBack.f_82479_, this.torsoBack.f_82480_ + (double)viewOffset, this.torsoBack.f_82481_, 0.0, 0.0, 0.0);
        level.m_7107_((ParticleOptions)ParticleTypes.f_123772_, this.nodes[0].f_82479_, this.nodes[0].f_82480_ + (double)viewOffset, this.nodes[0].f_82481_, 0.0, 0.0, 0.0);
        for (int i = 1; i < this.nodeCount; ++i) {
            level.m_7107_((ParticleOptions)ParticleTypes.f_123772_, this.nodes[i].f_82479_, this.nodes[i].f_82480_ + (double)viewOffset, this.nodes[i].f_82481_, 0.0, 0.0, 0.0);
        }
    }

    private static enum nodeLimits {
        POS_LIMIT,
        NEG_LIMIT;

    }
}

