/*
 * Decompiled with CFR 0.152.
 */
package net.thevaliantsquidward.rainbowreef.util;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class MathHelpers {
    public static Vec3 quickReturn(Level level, Vec3 anchor, Vec3 point, float angleY, float perTickRate, boolean gravity, boolean returning) {
        if (returning) {
            if (angleY >= 0.0f && angleY < 180.0f) {
                point = MathHelpers.rotateAroundCenterFlatDeg(anchor, point, Double.valueOf(-perTickRate));
            } else if (angleY < 0.0f && angleY >= -180.0f) {
                point = MathHelpers.rotateAroundCenterFlatDeg(anchor, point, Double.valueOf(perTickRate));
            }
        }
        if (gravity && (level.m_8055_(new BlockPos((int)point.m_7096_(), (int)(point.m_7098_() - 0.02), (int)point.m_7094_())).m_60795_() || !level.m_8055_(new BlockPos((int)point.m_7096_(), (int)(point.m_7098_() - 0.02), (int)point.m_7094_())).m_280296_())) {
            point = point.m_82492_(0.0, 0.02, 0.0);
        }
        return point;
    }

    public static Vec3 distConstraintSingle(Vec3 anchor, Vec3 point, double distLim, double VertLimPercentage) {
        double flatDist;
        double dist = anchor.m_82554_(point);
        Vec3 diff = anchor.m_82546_(point);
        Vec3 returnVec = point;
        if (dist > distLim) {
            returnVec = point.m_82549_(diff.m_82541_().m_82490_(dist - distLim));
        }
        if ((flatDist = MathHelpers.flatDist(anchor, point)) < distLim * VertLimPercentage) {
            double dX = diff.m_7096_();
            double dZ = diff.m_7094_();
            double dY = diff.m_7098_();
            returnVec = point.m_82520_(0.0, dY * (dist - distLim), 0.0);
        }
        return returnVec;
    }

    public static Vec3 driveAway(Vec3 anchor, Vec3 point, double hitboxRad, boolean flat) {
        double dist = anchor.m_82554_(point);
        Vec3 diff = anchor.m_82546_(point);
        Vec3 returnVec = point;
        if (dist < hitboxRad) {
            returnVec = point.m_82546_(diff.m_82541_().m_82542_(hitboxRad - dist, hitboxRad - dist, hitboxRad - dist));
        }
        double flatDist = MathHelpers.flatDist(anchor, point);
        return returnVec;
    }

    public static Vec3 distConstraint(ArrayList<Vec3> prevChain, Vec3 point, double nodeRadius) {
        Vec3 anchor = prevChain.get(prevChain.size() - 1);
        Vec3 returnStuff = anchor.m_82549_(point.m_82546_(anchor).m_82541_().m_82542_(nodeRadius, nodeRadius, nodeRadius));
        for (Vec3 nextNode : prevChain) {
            if (!(returnStuff.m_82554_(nextNode) < nodeRadius)) continue;
            returnStuff = anchor.m_82549_(returnStuff.m_82546_(nextNode).m_82541_().m_82542_(nodeRadius, nodeRadius, nodeRadius));
        }
        return returnStuff;
    }

    public static double constrainAngle(double angle, double constraint) {
        if (angle < 0.0) {
            angle = 360.0 - angle % 360.0;
        }
        if (angle < 0.0 && angle < -constraint) {
            return -constraint;
        }
        if (angle > 0.0 && angle > constraint) {
            return constraint;
        }
        return angle;
    }

    public static Vec2 angleTo(Vec3 target, Vec3 mePos) {
        double d0 = target.f_82479_ - mePos.f_82479_;
        double d1 = target.f_82480_ - mePos.f_82480_;
        double d2 = target.f_82481_ - mePos.f_82481_;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        double XAngle = (float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875));
        double YAngle = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
        return new Vec2((float)XAngle, (float)YAngle);
    }

    public static Vec3 rotateAroundCenterFlatDeg(Vec3 center, Vec3 me, Double angleInDeg) {
        angleInDeg = -(0.01745329238474369 * angleInDeg);
        double x1 = me.f_82479_ - center.f_82479_;
        double z1 = me.f_82481_ - center.f_82481_;
        double x2 = x1 * Math.cos(angleInDeg) - z1 * Math.sin(angleInDeg);
        double z2 = x1 * Math.sin(angleInDeg) + z1 * Math.cos(angleInDeg);
        double newMeX = x2 + center.f_82479_;
        double newMeZ = z2 + center.f_82481_;
        return new Vec3(newMeX, me.f_82480_, newMeZ);
    }

    public static Vec3 rotateAroundCenter3dDeg(Vec3 center, Vec3 me, float yRot, float xRot) {
        yRot = -((float)Math.PI / 180 * yRot);
        xRot = -((float)Math.PI / 180 * xRot);
        double x1 = me.f_82479_ - center.f_82479_;
        double z1 = me.f_82481_ - center.f_82481_;
        double y1 = me.f_82480_ - center.f_82480_;
        double x2 = x1 * Math.cos(yRot) - z1 * Math.sin(yRot);
        double z2 = x1 * Math.sin(yRot) + z1 * Math.cos(yRot);
        double y2 = -(z1 * Math.sin(xRot) + y1 * Math.cos(xRot));
        double newMeX = x2 + center.f_82479_;
        double newMeZ = z2 + center.f_82481_;
        double newMeY = y2 + center.f_82480_;
        return new Vec3(newMeX, newMeY, newMeZ);
    }

    public static float pitchProcess(Vec3 head, Vec3 tail) {
        if (!head.equals((Object)tail)) {
            double ground = tail.m_82554_(head);
            double height = head.m_7098_() - tail.m_7098_();
            return (float)Math.asin(height / ground);
        }
        return 0.0f;
    }

    public static double angleFromYdiff(Vec3 lead, Vec3 point, Vec3 trail) {
        double backHeight = point.f_82480_ - trail.f_82480_;
        double frontHeight = lead.f_82480_ - point.f_82480_;
        double backDist = point.m_82554_(trail);
        double frontDist = lead.m_82554_(point);
        double angFront = Math.atan(frontHeight / frontDist);
        double angBack = Math.atan(backHeight / backDist);
        return angBack - angFront;
    }

    public static double getAngleForLinkTopDownFlat(Vec3 point, Vec3 parent, Vec3 child, Vec3 leftRef, Vec3 rightRef) {
        double C = Math.hypot(Math.abs(parent.f_82479_ - child.f_82479_), Math.abs(parent.f_82481_ - child.f_82481_));
        double A = Math.hypot(Math.abs(parent.f_82479_ - point.f_82479_), Math.abs(parent.f_82481_ - point.f_82481_));
        double B = Math.hypot(Math.abs(point.f_82479_ - child.f_82479_), Math.abs(point.f_82481_ - child.f_82481_));
        double distToLeft = Math.abs(Math.hypot(child.f_82479_ - leftRef.f_82479_, child.f_82481_ - leftRef.f_82481_));
        double distToRight = Math.abs(Math.hypot(child.f_82479_ - rightRef.f_82479_, child.f_82481_ - rightRef.f_82481_));
        double c = Math.acos((A * A + B * B - C * C) / (2.0 * A * B));
        if (distToLeft >= distToRight) {
            return c;
        }
        return -c;
    }

    public static double angleClamp(double angle, double poslim) {
        if (angle > 0.0) {
            return Mth.m_14008_((double)angle, (double)poslim, (double)(6.2831854820251465 - poslim));
        }
        return Mth.m_14008_((double)angle, (double)(-(6.2831854820251465 - poslim)), (double)(-poslim));
    }

    public static double LerpDegreesConstantSpeed(double start, double end, double amount) {
        double difference = Math.abs(end - start);
        if (difference > 3.1415927410125732) {
            if (end > start) {
                start += 6.2831854820251465;
            } else {
                end += 6.2831854820251465;
            }
        }
        double value = start < end ? Math.max(end, start + amount) : Math.min(end, start + amount);
        float rangeZero = (float)Math.PI * 2;
        if (value >= 0.0 && value <= 6.2831854820251465) {
            return value;
        }
        return value % (double)rangeZero;
    }

    public static double LerpDegrees(double start, double end, double amount) {
        double difference = Math.abs(end - start);
        if (difference > 3.1415927410125732) {
            if (end > start) {
                start += 6.2831854820251465;
            } else {
                end += 6.2831854820251465;
            }
        }
        double value = start + (end - start) * amount;
        float rangeZero = (float)Math.PI * 2;
        if (Double.isNaN(value)) {
            return 0.0;
        }
        if (value >= 0.0 && value <= 6.2831854820251465) {
            return value;
        }
        return value % (double)rangeZero;
    }

    public static double flatDist(Vec3 a, Vec3 b) {
        return Math.abs(Math.hypot(a.f_82479_ - b.f_82479_, a.f_82481_ - b.f_82481_));
    }
}

