/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.artillerysupport.dispenser;

import java.util.Random;
import java.util.function.BiFunction;
import net.genzyuro.artillerysupport.entity.smokebomb.AbstractSmokeBombProjectileEntity;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class SmokeBombDispenseBehavior
implements DispenseItemBehavior {
    private final BiFunction<Level, Vec3, AbstractSmokeBombProjectileEntity> entityCreator;

    public SmokeBombDispenseBehavior(BiFunction<Level, Vec3, AbstractSmokeBombProjectileEntity> entityCreator) {
        this.entityCreator = entityCreator;
    }

    public ItemStack m_6115_(BlockSource source, ItemStack stack) {
        ServerLevel level = source.m_7727_();
        Direction dispenserFacing = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
        Vec3 position = source.m_7961_().m_121945_(dispenserFacing).m_252807_();
        AbstractSmokeBombProjectileEntity entity = this.entityCreator.apply((Level)level, position);
        entity.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
        Vec3 direction = Vec3.m_82528_((Vec3i)((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_)).m_122436_());
        String initialDirection = this.getDirectionFromDispenserFacing(dispenserFacing);
        entity.setInitialDirection(initialDirection);
        entity.m_6686_(direction.f_82479_ + level.m_213780_().m_188583_() * 0.02, direction.f_82480_ + level.m_213780_().m_188583_() * 0.02, direction.f_82481_ + level.m_213780_().m_188583_() * 0.02, 5.0f, 1.0f);
        level.m_7967_((Entity)entity);
        level.m_6263_(null, position.f_82479_, position.f_82480_, position.f_82481_, SoundEvents.f_11687_, SoundSource.BLOCKS, 1.0f, 1.2f);
        stack.m_41774_(1);
        return stack;
    }

    private String getDirectionFromDispenserFacing(Direction facing) {
        if (facing == Direction.UP || facing == Direction.DOWN) {
            String[] possibleDirections = new String[]{"North", "South", "East", "West"};
            return possibleDirections[new Random().nextInt(possibleDirections.length)];
        }
        return switch (facing) {
            case Direction.NORTH -> "South";
            case Direction.SOUTH -> "North";
            case Direction.EAST -> "West";
            case Direction.WEST -> "East";
            default -> "North";
        };
    }
}

