/*
 * Decompiled with CFR 0.152.
 */
package com.dreamtea.tms.mobs.creeper;

import com.dreamtea.tms.mobs.creeper.CreeperConsts;
import com.dreamtea.tms.mobs.hostile.HostileScalar;
import com.dreamtea.tms.util.RandomSelector;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1548;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_5819;

public class CreeperScalar
extends HostileScalar {
    private List<class_1293> cloudEffect = new ArrayList<class_1293>();
    private List<class_1293> constantEffects = new ArrayList<class_1293>();
    private boolean invisible = false;
    private boolean charging = false;
    public static final String CLOUD_KEY = "cloudEffects";
    public static final String INVISIBLE_KEY = "ninja";

    public CreeperScalar() {
        super(new CreeperConsts());
    }

    public void chooseEffects(class_5819 r) {
        this.chooseEffects(r, CreeperConsts.outcomes, 0);
    }

    public void addGlowing(class_1548 creeper, boolean on) {
        if (!this.invisible) {
            return;
        }
        if (on) {
            creeper.method_6092(new class_1293(class_1294.field_5912, Integer.MAX_VALUE));
        } else {
            creeper.method_6016(class_1294.field_5912);
        }
    }

    public void applyEffects(class_1548 creeper) {
        this.constantEffects.forEach(eff -> creeper.method_6092(eff));
    }

    private void chooseEffects(class_5819 r, Map<String, Integer> outcomes, int nothing) {
        String outcome = RandomSelector.getFromWeighted(outcomes, nothing, r);
        if (outcome == null) {
            return;
        }
        switch (outcome) {
            case "CHARGED": {
                this.charging = true;
                break;
            }
            case "SPECIAL": {
                class_1293 chosen = RandomSelector.getFromWeighted(CreeperConsts.weightedEffects, r);
                chosen.method_5580(true);
                if (chosen.method_5579().equals(class_1294.field_5905)) {
                    this.invisible = true;
                }
                this.cloudEffect.add(chosen);
                this.constantEffects.add(chosen);
                break;
            }
            case "REROLL": {
                this.chooseEffects(r, outcomes, nothing + 200);
            }
            case "STANDARD": {
                this.cloudEffect.add(RandomSelector.getFromList(CreeperConsts.standardEffects, r));
            }
        }
    }

    public List<class_1293> cloudEffects() {
        return this.cloudEffect;
    }

    public void writeNbt(class_2487 nbt) {
        class_2499 clouds = new class_2499();
        this.cloudEffect.forEach(eff -> clouds.add((Object)eff.method_5582(new class_2487())));
        nbt.method_10566(CLOUD_KEY, (class_2520)clouds);
        nbt.method_10556(INVISIBLE_KEY, this.invisible);
    }

    public void readFromNbt(class_2487 nbt) {
        if (nbt.method_10573(CLOUD_KEY, 9)) {
            class_2499 nbtList = nbt.method_10554(CLOUD_KEY, 10);
            for (int i = 0; i < nbtList.size(); ++i) {
                class_2487 nbtCompound = nbtList.method_10602(i);
                class_1293 statusEffectInstance = class_1293.method_5583((class_2487)nbtCompound);
                if (statusEffectInstance == null) continue;
                this.cloudEffect.add(statusEffectInstance);
            }
        }
        this.invisible = nbt.method_10577(INVISIBLE_KEY);
        this.charging = nbt.method_10577("ignited");
    }

    public boolean isCharging() {
        return this.charging;
    }
}

