/*
 * Decompiled with CFR 0.152.
 */
package net.lostpatrol.tradetweaks.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nonnull;
import net.lostpatrol.tradetweaks.client.gui.TradeSelectionScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TradeListWidget
extends ObjectSelectionList<TradeEntry> {
    private static final ResourceLocation VILLAGER_LOCATION = new ResourceLocation("textures/gui/container/villager2.png");
    private final TradeSelectionScreen parent;

    public TradeListWidget(Minecraft minecraft, int width, int height, int y0, int y1, int itemHeight) {
        super(minecraft, width, height, y0, y1, itemHeight);
        this.parent = (TradeSelectionScreen)minecraft.f_91080_;
        this.m_93488_(false);
        this.m_93496_(false);
        this.m_93471_(true);
    }

    public int m_5759_() {
        return this.f_93388_ - 40;
    }

    protected void m_280310_(@Nonnull GuiGraphics guiGraphics) {
        guiGraphics.m_280588_(0, this.f_93390_, this.parent.f_96543_, this.parent.f_96544_);
    }

    protected void m_240140_(GuiGraphics guiGraphics, int top, int width, int height, int outerColor, int innerColor) {
        int i = this.f_93393_ + (this.f_93388_ - width) / 2;
        int j = this.f_93393_ + (this.f_93388_ + width) / 2;
        guiGraphics.m_280509_(i, top - 2, j, top + height + 2, outerColor);
        guiGraphics.m_280509_(i + 1, top - 1, j - 1, top + height + 1, innerColor);
    }

    protected int m_5756_() {
        return this.f_93393_ + this.f_93388_ - 6;
    }

    protected void addTrade(MerchantOffer offer, int index) {
        this.m_7085_((AbstractSelectionList.Entry)new TradeEntry(offer, index));
    }

    protected MerchantOffer getTrade(int index) {
        if (index >= 0 && index < this.m_6702_().size()) {
            return ((TradeEntry)((Object)this.m_6702_().get((int)index))).offer;
        }
        return null;
    }

    protected void clearTrades() {
        this.m_93516_();
    }

    private void renderTradeItem(GuiGraphics guiGraphics, Font font, ItemStack itemStack, int x, int y, int mouseX, int mouseY, int iconSize) {
        if (itemStack == null || itemStack.m_41619_()) {
            return;
        }
        guiGraphics.m_280480_(itemStack, x, y);
        guiGraphics.m_280370_(font, itemStack, x, y);
        if (this.mouseOnItem(mouseX, mouseY, x, y, iconSize)) {
            guiGraphics.m_280509_(x, y, x + iconSize, y + iconSize, 0x33FF0000);
            guiGraphics.m_280153_(font, itemStack, mouseX, mouseY);
        }
    }

    private boolean mouseOnItem(int mouseX, int mouseY, int x, int y, int iconSize) {
        return mouseX >= x && mouseX < x + iconSize && mouseY >= y && mouseY < y + iconSize;
    }

    private void renderButtonArrows(GuiGraphics guiGraphics, int posX, int posY) {
        RenderSystem.enableBlend();
        guiGraphics.m_280398_(VILLAGER_LOCATION, posX, posY + 3, 0, 15.0f, 171.0f, 10, 9, 512, 256);
    }

    class TradeEntry
    extends ObjectSelectionList.Entry<TradeEntry> {
        private final MerchantOffer offer;
        private final int index;
        private static final int ITEM_SPACING = 25;

        public TradeEntry(MerchantOffer offer, int index) {
            this.offer = offer;
            this.index = index;
        }

        public void m_6311_(@Nonnull GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            Font font = Minecraft.m_91087_().f_91062_;
            int panelWidth = TradeListWidget.this.f_93388_;
            int xPos = TradeListWidget.this.f_93393_ + (TradeListWidget.this.f_93388_ - width) / 2 + 15;
            int yPos = top;
            TradeListWidget.this.renderTradeItem(guiGraphics, font, this.offer.m_45358_(), xPos, yPos, mouseX, mouseY, 16);
            TradeListWidget.this.renderTradeItem(guiGraphics, font, this.offer.m_45364_(), xPos + 25, yPos, mouseX, mouseY, 16);
            TradeListWidget.this.renderTradeItem(guiGraphics, font, this.offer.m_45368_(), xPos + 75, yPos, mouseX, mouseY, 16);
            TradeListWidget.this.renderButtonArrows(guiGraphics, xPos + 50, yPos);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (button == 0) {
                if (TradeListWidget.this.parent == null) {
                    return false;
                }
                if (TradeListWidget.this == TradeListWidget.this.parent.leftPanel) {
                    TradeListWidget.this.parent.selectExistingTrade(this.index);
                } else {
                    TradeListWidget.this.parent.selectReplacement(this.index);
                }
                return true;
            }
            return false;
        }

        @Nonnull
        public Component m_142172_() {
            return Component.m_237110_((String)"tradetweaks.gui.narration.trade_entry", (Object[])new Object[]{this.offer.m_45358_().m_41786_(), this.offer.m_45368_().m_41786_()});
        }
    }
}

