/*
 * Decompiled with CFR 0.152.
 */
package net.lostpatrol.tradetweaks.client.gui;

import java.util.List;
import javax.annotation.Nonnull;
import net.lostpatrol.tradetweaks.client.gui.TradeListWidget;
import net.lostpatrol.tradetweaks.common.dummy.DummyVillager;
import net.lostpatrol.tradetweaks.common.select.TradeReplacer;
import net.lostpatrol.tradetweaks.network.NetworkHandler;
import net.lostpatrol.tradetweaks.network.packet.PacketTradeReplace;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TradeSelectionScreen
extends Screen {
    private static final int PANEL_WIDTH = 160;
    private static final int PANEL_MARGIN = 10;
    private static final int ITEM_HEIGHT = 20;
    protected static final int PANEL_SPACING = 10;
    private static final int CONTAINER_PADDING = 10;
    private static final int CONTAINER_WIDTH = 330;
    private final int villagerId;
    private final MerchantOffers offers;
    private final int level;
    private final VillagerProfession profession;
    private final Villager dummyVillager;
    TradeListWidget leftPanel;
    private TradeListWidget rightPanel;
    private Button confirmButton;
    private int selectedTradeIndex = -1;
    private int selectedReplacementIndex = -1;
    private final Component LEFT_TITLE = Component.m_237115_((String)"tradetweaks.gui.existing_trades");
    private final Component RIGHT_TITLE = Component.m_237115_((String)"tradetweaks.gui.replacement_options").m_130940_(ChatFormatting.GREEN);

    @OnlyIn(value=Dist.CLIENT)
    public TradeSelectionScreen(DummyVillager dummyVillager) {
        super((Component)Component.m_237115_((String)"tradetweaks.gui.trade_selection").m_130940_(ChatFormatting.BOLD));
        this.villagerId = dummyVillager.getVillagerId();
        this.offers = dummyVillager.getOffers();
        this.level = dummyVillager.getProfessionLevel();
        this.profession = dummyVillager.getProfession();
        this.dummyVillager = dummyVillager.getDummyVillager();
    }

    protected void m_7856_() {
        super.m_7856_();
        int containerX = (this.f_96543_ - 330) / 2;
        int containerY = 30;
        int panelHeight = this.f_96544_ - containerY - 50;
        this.leftPanel = new TradeListWidget(this.f_96541_, 160, panelHeight, containerY, containerY + panelHeight, 20);
        this.leftPanel.m_93507_(containerX);
        this.m_142416_((GuiEventListener)this.leftPanel);
        this.rightPanel = new TradeListWidget(this.f_96541_, 160, panelHeight, containerY, containerY + panelHeight, 20);
        this.rightPanel.m_93507_(containerX + 160 + 10);
        this.m_142416_((GuiEventListener)this.rightPanel);
        this.confirmButton = new Button.Builder((Component)Component.m_237115_((String)"tradetweaks.gui.confirm"), button -> this.confirmReplacement()).m_252794_(this.f_96543_ / 2 - 50, this.f_96544_ - 30).m_253046_(100, 20).m_253136_();
        this.confirmButton.f_93623_ = false;
        this.confirmButton.f_93624_ = false;
        this.m_142416_((GuiEventListener)this.confirmButton);
        this.refreshTrades();
    }

    private void refreshTrades() {
        this.leftPanel.clearTrades();
        for (int i = 0; i < this.offers.size(); ++i) {
            this.leftPanel.addTrade((MerchantOffer)this.offers.get(i), i);
        }
    }

    public void m_88315_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        int containerX = (this.f_96543_ - 330) / 2;
        int containerY = 30;
        int containerWidth = 330;
        int containerHeight = this.f_96544_ - containerY - 50;
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 10, 0xFFFFFF);
        guiGraphics.m_280653_(this.f_96547_, this.LEFT_TITLE, containerX + 80, 20, 0xFFFFFF);
        if (this.selectedTradeIndex >= 0) {
            guiGraphics.m_280653_(this.f_96547_, this.RIGHT_TITLE, containerX + 160 + 10 + 80, 20, 0xFFFFFF);
        }
    }

    public void selectExistingTrade(int index) {
        MerchantOffer selectedOffer;
        List<MerchantOffer> possibleTrades;
        if (this.selectedTradeIndex == index) {
            return;
        }
        this.selectedTradeIndex = index;
        this.selectedReplacementIndex = -1;
        this.rightPanel.clearTrades();
        this.updateConfirmButton();
        if (index >= 0 && index < this.offers.size() && (possibleTrades = TradeReplacer.getPossibleTrades(selectedOffer = (MerchantOffer)this.offers.get(index), this.level, this.profession, this.dummyVillager)) != null) {
            for (int i = 0; i < possibleTrades.size(); ++i) {
                this.rightPanel.addTrade(possibleTrades.get(i), i);
            }
        }
    }

    public void selectReplacement(int index) {
        this.selectedReplacementIndex = index;
        this.updateConfirmButton();
    }

    private void updateConfirmButton() {
        this.confirmButton.f_93623_ = this.selectedTradeIndex >= 0 && this.selectedReplacementIndex >= 0;
        this.confirmButton.f_93624_ = this.selectedTradeIndex >= 0;
    }

    private void confirmReplacement() {
        MerchantOffer replacement;
        if (this.selectedTradeIndex >= 0 && this.selectedReplacementIndex >= 0 && (replacement = this.rightPanel.getTrade(this.selectedReplacementIndex)) != null) {
            NetworkHandler.sendTradeReplaceToServer(new PacketTradeReplace(this.villagerId, this.selectedTradeIndex, replacement));
            this.m_7379_();
        }
    }
}

